しら CDN V1.3
===============

しら CDN是一个使用CloudFlare合作伙伴功能来为用户提供免费的Layer3/Layer4/Layer7防护和缓存加速功能的程序,并且集成了CloudXns为用户提供A记录解析,这是目前其他面板没有的,目前处于Beta阶段目前实现了以下功能：

 + CloudFlare免费套餐使用接入
 + CNAME记录加速
 + 借助CloudXns实现A记录加速
 + 免费的https(CloudFlare要求需要设置额外的验证CNAME)
 + 免费使用CloudFlare的Railgun功能
 + http模式回源
 + 无限添加域名和子域
 + 可删除域名随时转到cloudflare官方或者其它合作伙伴
 + 可单独增删改某条记录
 + 支持A记录和AAAA记录

> しら CDN基于ThinkPHP开发,支持php5.4到7.1之间(推荐使用7.1,7.0,5.6)


## 部署相关

> 设置网站目录和入库目录说明

根目录则是整个程序目录,入口目录为/public.

不建议将public目录设置为网站目录,这样可能会带来不可预料的后果!

不建议将public以外的目录暴露在http可以访问的目录内,这样可能存在未知的安全隐患.

> 伪静态设置

伪静态和ThinkPHP的伪静态一样,下面贴出nginx的伪静态设置,如果你的入口在二级或更深层的目录请自行修改伪静态配置.

~~~
    location / {
        if (!-e $request_filename){
            rewrite  ^(.*)$  /index.php?s=$1  last;   break;
        }
    }
~~~
> 修改/application/config.php内的配置

~~~

    'webname'=>'しらCDN', //网站名称
	'cf_api'=>'https://api.cloudflare.com/host-gw.html',//cloudflare经销商api,不需要修改
    'cf_key'=>'', //cloudflare合作伙伴密钥
    'forward_domain'=>'', //转发域名转发时使用的域名
    'domain_id'=>0, //转发域名的cloudxns的id
    'xns_key'=>'', //cloudxns的API KEY
    'xns_secret'=>'', ///cloudxns的SECRET KEY
	'debug_level'=>0, //cloudflare的debug等级,一般不需要使用

~~~
> 修改/application/database.php内的配置

~~~

    // 服务器地址
    'hostname'        => '127.0.0.1',
    // 数据库名
    'database'        => 'srk_cf',
    // 用户名
    'username'        => 'root',
    // 密码
    'password'        => '',
    // 端口
    'hostport'        => '',
~~~
> 导入import.sql

不会导入的请从100M+的建筑物上跳下去,到地面之后你将知道如何导入.

## 版本升级
> 从1.2升级到1.3

+ 删除/public/static/index文件夹并使用1.3版本同目录替换
+ 删除/application/index/controller/Panel.php并使用1.3版本同目录替换
+ 将1.3版本/application/index/controller/Domain.php放置到同路径下
+ 删除/application/index/view/panel目录使用1.3版本同目录替换
+ 将1.3版本/application/index/view/domain和里面所有文件放置到同路径下
+ MySQL执行下面语句即可完成升级.

~~~
    ALTER TABLE `srk_domain` CHANGE `ip` `ip` VARCHAR(40) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;
~~~


## 版权信息

しらCDN遵循Apache2开源协议发布，并提供免费使用.

你可以修改任何代码,但是你需要保留面板内页上的Power By 矢澤にこ字样和其链接(你可以增加不传递权重的标签).

Power By [矢澤にこ](https://blog.ni-co.moe/)

更多细节参阅 [LICENSE.txt](LICENSE.txt)
