<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 应用公共文件

// 执行请求
function performRequest($data, $headers=NULL) {
	$data["host_key"] = \think\Config::get('cf_key');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, \think\Config::get('cf_api'));
	$dlevel = \think\Config::get('debug_level');
    if ($dlevel > 1) {
        curl_setopt($ch, CURLOPT_VERBOSE, 1); 
    }
    if ($dlevel > 0) {
        //echo "REQUEST DATA (to be sent via POST):\n";
        print_r($data);
    }

    if ($headers) {
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers); 
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    if ($data) {
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    }

    curl_setopt($ch, CURLOPT_TIMEOUT, 60); 
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
    curl_setopt($ch, CURLOPT_AUTOREFERER,    TRUE);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    if (($http_result = curl_exec($ch)) === FALSE) {
        echo "WARNING: A connectivity error occured while contacting the service.\n";
        trigger_error(curl_error($ch));
        return FALSE;
    }

    curl_close($ch);
    // var_dump($data,$http_result);exit;
    return $http_result;
}
//请求的过程
function processResponse(& $response) {
    $settings  = NULL;
    
    if (PRINT_RESPONSE) {
        echo "RAW RESPONSE DATA:\n".$response."\n";
    }

    echo "DECODED RESPONSE DATA:\n";
    $decoded_response = json_decode($response);
    print_r($decoded_response);
}

//返回信息检查
function returnCheck($params){
	is_array($params) or $params = json_decode($params,true);
	$errMsg = \think\Config::get('err_msg');
	if($params['result'] == 'error'){
		
		if(!isset($errMsg[$params['err_code']])){
            // var_dump($params);exit;
            return $params['err_code'].':'.$params['msg'];
		}else{
            // var_dump($params);exit;
			return $errMsg[$params['err_code']];
		}
		
	}else{
		return $params;
	}
}

//实例化一个xns的api
function newXnsApi(){
    $api = new \CloudXNS\Api();
    $api->setApiKey(\think\Config::get('xns_key'));
    $api->setSecretKey(\think\Config::get('xns_secret'));
    $api->setProtocol(true);
    return $api;
}

//添加转发记录
function addForwardRecord($ip,$type = 'A',$api =null){
    $api or $api = newXnsApi();
    $did = \think\Config::get('domain_id');
    $host = md5(time().rand(1,9999));
    $return = $api->record->recordAdd($did, $host, $ip, $type , 10, 600, 1);
    $return = json_decode($return,true);
    // var_dump($type);exit;
    // var_dump($return);exit;
    if(isset($return['code']) && ($return['code'] == 34 || $return['code'] == 300 || $return['code'] == 403)){
        return false;
    }else{
        return ['cname'=>$host.'.'.\think\Config::get('forward_domain'),'response'=>$return];
    }
}
//修改转发记录
function updateForwardRecord($ip,$record_id,$api =null){
    $api or $api = newXnsApi();
    $did = \think\Config::get('domain_id');
    $api->record->recordUpdate($did, $host, $ip, 'A', 10, 600, 1, '', 854069);
}
//删除记录
function delForwardRecord($record_id,$api =null){
    $api or $api = newXnsApi();
    $did = \think\Config::get('domain_id');
    return $api->record->recordDelete($record_id, $did);
}

//ip转cname(调用添加转发记录)
function ip2cname($ip,$type = 'A'){
    $return = addForwardRecord($ip,$type);
    // var_dump($return);exit;
    if(!$return){
        return false;
    }else{
        
        return [
            'ip'=>$ip,
            'record_id'=>$return['response']['record_id'][0],
            'cname'=>$return['cname']
        ];
    }
}

function recordChick($data,$type = "A"){
    if($type =='A' || $type =='AAAA'){
        if(filter_var($data, FILTER_VALIDATE_IP, FILTER_FLAG_NO_RES_RANGE) && intval(substr($data,0,3)) != 127) {
            return $data;
        }else{
            return false;
        }
    }elseif($type == 'CNAME'){
        return true;
    }else{
        return false;
    }
    
}