<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006~2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: liu21st <liu21st@gmail.com>
// +----------------------------------------------------------------------

return [
    // +----------------------------------------------------------------------
    // | 应用设置
    // +----------------------------------------------------------------------

    // 应用命名空间
    'app_namespace'          => 'app',
    // 应用调试模式
    'app_debug'              => true,
    // 应用Trace
    'app_trace'              => false,
    // 应用模式状态
    'app_status'             => '',
    // 是否支持多模块
    'app_multi_module'       => true,
    // 入口自动绑定模块
    'auto_bind_module'       => true,
    // 注册的根命名空间
    'root_namespace'         => [],
    // 扩展函数文件
    'extra_file_list'        => [THINK_PATH . 'helper' . EXT],
    // 默认输出类型
    'default_return_type'    => 'html',
    // 默认AJAX 数据返回格式,可选json xml ...
    'default_ajax_return'    => 'json',
    // 默认JSONP格式返回的处理方法
    'default_jsonp_handler'  => 'jsonpReturn',
    // 默认JSONP处理方法
    'var_jsonp_handler'      => 'callback',
    // 默认时区
    'default_timezone'       => 'PRC',
    // 是否开启多语言
    'lang_switch_on'         => false,
    // 默认全局过滤方法 用逗号分隔多个
    'default_filter'         => '',
    // 默认语言
    'default_lang'           => 'zh-cn',
    // 应用类库后缀
    'class_suffix'           => false,
    // 控制器类后缀
    'controller_suffix'      => false,

    // +----------------------------------------------------------------------
    // | 模块设置
    // +----------------------------------------------------------------------

    // 默认模块名
    'default_module'         => 'index',
    // 禁止访问模块
    'deny_module_list'       => ['common'],
    // 默认控制器名
    'default_controller'     => 'Index',
    // 默认操作名
    'default_action'         => 'index',
    // 默认验证器
    'default_validate'       => '',
    // 默认的空控制器名
    'empty_controller'       => 'Error',
    // 操作方法后缀
    'action_suffix'          => '',
    // 自动搜索控制器
    'controller_auto_search' => false,

    // +----------------------------------------------------------------------
    // | URL设置
    // +----------------------------------------------------------------------

    // PATHINFO变量名 用于兼容模式
    'var_pathinfo'           => 's',
    // 兼容PATH_INFO获取
    'pathinfo_fetch'         => ['ORIG_PATH_INFO', 'REDIRECT_PATH_INFO', 'REDIRECT_URL'],
    // pathinfo分隔符
    'pathinfo_depr'          => '/',
    // URL伪静态后缀
    'url_html_suffix'        => 'html',
    // URL普通方式参数 用于自动生成
    'url_common_param'       => false,
    // URL参数方式 0 按名称成对解析 1 按顺序解析
    'url_param_type'         => 0,
    // 是否开启路由
    'url_route_on'           => true,
    // 路由使用完整匹配
    'route_complete_match'   => false,
    // 路由配置文件（支持配置多个）
    'route_config_file'      => ['route'],
    // 是否强制使用路由
    'url_route_must'         => false,
    // 域名部署
    'url_domain_deploy'      => false,
    // 域名根，如thinkphp.cn
    'url_domain_root'        => '',
    // 是否自动转换URL中的控制器和操作名
    'url_convert'            => true,
    // 默认的访问控制器层
    'url_controller_layer'   => 'controller',
    // 表单请求类型伪装变量
    'var_method'             => '_method',
    // 表单ajax伪装变量
    'var_ajax'               => '_ajax',
    // 表单pjax伪装变量
    'var_pjax'               => '_pjax',
    // 是否开启请求缓存 true自动缓存 支持设置请求缓存规则
    'request_cache'          => false,
    // 请求缓存有效期
    'request_cache_expire'   => null,
    // 全局请求缓存排除规则
    'request_cache_except'   => [],

    // +----------------------------------------------------------------------
    // | 模板设置
    // +----------------------------------------------------------------------

    'template'               => [
        // 模板引擎类型 支持 php think 支持扩展
        'type'         => 'Think',
        // 模板路径
        'view_path'    => '',
        // 模板后缀
        'view_suffix'  => 'html',
        // 模板文件名分隔符
        'view_depr'    => DS,
        // 模板引擎普通标签开始标记
        'tpl_begin'    => '{',
        // 模板引擎普通标签结束标记
        'tpl_end'      => '}',
        // 标签库标签开始标记
        'taglib_begin' => '{',
        // 标签库标签结束标记
        'taglib_end'   => '}',
    ],

    // 视图输出字符串内容替换
    'view_replace_str'       => [],
    // 默认跳转页面对应的模板文件
    'dispatch_success_tmpl'  => APP_PATH . 'tpl/dispatch_jump.html',
    'dispatch_error_tmpl'    => APP_PATH . 'tpl/dispatch_jump.html',

    // +----------------------------------------------------------------------
    // | 异常及错误设置
    // +----------------------------------------------------------------------

    // 异常页面的模板文件
    'exception_tmpl'         => THINK_PATH . 'tpl' . DS . 'think_exception.tpl',

    // 错误显示信息,非调试模式有效
    'error_message'          => '页面错误！请稍后再试～',
    // 显示错误信息
    'show_error_msg'         => false,
    // 异常处理handle类 留空使用 \think\exception\Handle
    'exception_handle'       => '',

    // +----------------------------------------------------------------------
    // | 日志设置
    // +----------------------------------------------------------------------

    'log'                    => [
        // 日志记录方式，内置 file socket 支持扩展
        'type'  => 'File',
        // 日志保存目录
        'path'  => LOG_PATH,
        // 日志记录级别
        'level' => [],
    ],

    // +----------------------------------------------------------------------
    // | Trace设置 开启 app_trace 后 有效
    // +----------------------------------------------------------------------
    'trace'                  => [
        // 内置Html Console 支持扩展
        'type' => 'Html',
    ],

    // +----------------------------------------------------------------------
    // | 缓存设置
    // +----------------------------------------------------------------------

    'cache'                  => [
        // 驱动方式
        'type'   => 'File',
        // 缓存保存目录
        'path'   => CACHE_PATH,
        // 缓存前缀
        'prefix' => '',
        // 缓存有效期 0表示永久缓存
        'expire' => 0,
    ],

    // +----------------------------------------------------------------------
    // | 会话设置
    // +----------------------------------------------------------------------

    'session'                => [
        'id'             => '',
        // SESSION_ID的提交变量,解决flash上传跨域
        'var_session_id' => '',
        // SESSION 前缀
        'prefix'         => 'think',
        // 驱动方式 支持redis memcache memcached
        'type'           => '',
        // 是否自动开启 SESSION
        'auto_start'     => true,
    ],

    // +----------------------------------------------------------------------
    // | Cookie设置
    // +----------------------------------------------------------------------
    'cookie'                 => [
        // cookie 名称前缀
        'prefix'    => '',
        // cookie 保存时间
        'expire'    => 0,
        // cookie 保存路径
        'path'      => '/',
        // cookie 有效域名
        'domain'    => '',
        //  cookie 启用安全传输
        'secure'    => false,
        // httponly设置
        'httponly'  => '',
        // 是否使用 setcookie
        'setcookie' => true,
    ],

    //分页配置
    'paginate'               => [
        'type'      => 'bootstrap',
        'var_page'  => 'page',
        'list_rows' => 15,
    ],
    'webname'=>'しらCDN',
	'cf_api'=>'https://api.cloudflare.com/host-gw.html',
    'cf_key'=>'', 
    'forward_domain'=>'', 
    'domain_id'=>0, 
    'xns_key'=>'',
    'xns_secret'=>'', 
	'debug_level'=>0,
	'err_msg'=>[ //cloudflare经销商api错误码对应的消息
        100=>"没有密钥或密钥错误.",
        101=>"没有操作或者操作错误.",
        103=>"请输入您的cloudflare电子邮箱.",
        104=>"错误的unique_id,只允许使用'-_a-z0-9#@+.,'.",
        105=>"unique_id超过最大允许值.",
        106=>"clobber_unique_id的值只能是0或1.",
        107=>"这个操作至少需要unique_id和邮箱其中一个.",
        108=>"请输入您的cloudflare账户的密码.",
        109=>"cloudflare密码太简单了.",
        110=>"你的cloudflare密码至少需要6个字符以上.",
        111=>"请提供一个cloudflare用户名.",
        112=>"cloudflare的用户名至少为3个字符.",
        113=>"用户名错误,cloudflare的用户名由字母和数字和-_号组成.",
        114=>"用户名错误,你的用户名内含有不允许的词语或者字符.",
        115=>"没有设置用户key.",
        116=>"错误的用户key.",
        117=>"unique_id已被其他用户使用.",
        118=>"您输入的邮箱已被使用.",
        119=>"您输入的邮箱已被使用,但是还没有激活,请检查您的邮箱.",
        120=>"您输入的邮箱已被使用,如果您忘记了密码,请到cloudflare官网进行重置.",
        121=>"账户验证码已经过期.",
        122=>"这个用户名已被使用,请重新输入一个.",
        123=>"这个账户不存在,请检查.",
        124=>"密码错误,请重新输入或去cloudflare官网重置密码.",
        125=>"用户密钥不存在(请尝试重新登录).",
        126=>"请输入正确的cloudflare账户(email).",
        127=>"A variation of this email address is already taken in our system. Only one variation is allowed. For example, cloud.flare+alias@gmail.com and [email protected] are both the same email address.",
        200=>"没有设置主域名.",
        201=>"错误的主域名.",
        202=>"没有设置主域名的解析地址.",
        203=>"主域名解析地址错误.",
        204=>"没有设置子域名.",
        205=>"在子域名中找到错误的值.",
        206=>"在子域名中找到超出最大长度的值,最大允许120个字符.",
        207=>"cloudflare已经为您托管个了这个域名.",
        208=>"cloudflare的其它用户已经托管了这个域名,如果这个域名是您的,请联系cloudflare的技术支持并提供破您的域名和错误代码#208.",
        209=>"cloudflare的其它用户已经托管了这个域名,如果这个域名是您的,请联系cloudflare的技术支持并提供破您的域名和错误代码#209.",
        210=>"cloudflare无法删除这个域名,域名不存在或不属于你",
        211=>"cloudflare无法删除这个域名,这个域名已被禁止或者已经删除.",
        212=>"cloudflare无法删除这个域名,这个域名可能是托管在其他合作伙伴那里的.",
        213=>"cloudflare无法删除这个域名,它已经从您账户中删除.",
        214=>"这个域名已经使用NS方式托管到cloudflare或baidu,要想使用cname模式请到您的账户删除您要使用cname模式的域名然后再次尝试.",
        215=>"cloudflare目前限制新站点的注册,目前你的站点正在进行排队,排队结束后你将受到通知.",
        216=>"你的DNS现在是由cloudflare提供的，如果你想使用我们的服务，你必须先在clouflare账户内删除这个域名.",
        217=>"CF不能通过这个服务商进行服务。如果你是此域名真实持有人，你可以删除之前的CF域名，重新进行此流程。你可以联系cloudflare并提供错误代码#217.",
        218=>"这个域名貌似不是一个已经注册的域名.",
        219=>"这个域名已经存在并验证.",
        600=>"没有收到提交的数据.",
        601=>"不能连接到cloudflare数据库,请稍后再试,此问题如果频繁出现,请联系cloudflare的技术支持并提供错误代码#601.",
        700=>"错误的合作密钥.",
        701=>"一个未知的错误已经创建,这是cloudflare的问题,cloudflare将即时解决问题,请稍后再试.",
        702=>"一个未知的错误授权已经创建,这是cloudflare的问题,cloudflare将即时解决问题,请稍后再试.",
        703=>"一个错误的删除已经创建,这是cloudflare的问题,cloudflare将即时解决问题,请稍后再试.",
        303=>"订阅状态无效. 使用 V, CNL, or ALL.",
        311=>"错误的用户.",
        312=>"错误的子域.",
        313=>"子域名不接受新订阅.",
        314=>"订阅已经激活.",
        315=>"以订阅,子组不能重新激活.",
        317=>"错误的域名.",
        321=>"域名无效.",
        322=>"域名已订阅到不同的子项.",
        340=>"其他错误 (Subscribe).",
        350=>"域名不在cloudflare有效.",
        331=>"错误的订阅id.",
        332=>"子域名已取消.",
        333=>"其他错误 (Unsubscribe).",
        334=>"这个域名在某个经销商那里. 删除域名前请先取消订阅.",
	],
];
