<?php
namespace app\index\model;
use \think\Db;
class Domain
{
    private static $init = null;

    public static function instance($init = null){
        if($init){
            self::$init = $init;
        }elseif(!self::$init){
            self::$init = new self();
        }
        return self::$init;
    }

    public function findHost($domain,$zname,$db = null){
        $db or $db = Db::name('domain');
        $sub = str_replace($zname,'',$domain);
        return $db->where(['domain'=>$zname,'sub'=>$sub])->find();
    }

    public function getEarliestHost($zone,$db = null){
        $db or $db = Db::name('domain');
        return $db->where(['domain'=>$zone])->order('id asc')->find();
    }

    public function addDomainInfo($data,$db = null){
        $db or $db = Db::name('domain');
        return $db->insert($data);
    }

    public function addMultiDomainInfo($data,$db = null){
        $db or $db = Db::name('domain');
        return $db->insertAll($data);
    }

    public function findDomain($zone,$unique_id,$db = null){
        $db or $db = Db::name('domain');
        return $db->where(['domain'=>$zone,'unique_id'=>$unique_id])->select();
    }

    public function delForwardRecord($id,$db = null){
        $db or $db = Db::name('domain');
        return $db->where(['id'=>$id])->delete();
    }

    public function delAllDomainInfo($domain,$db = null){
        $db or $db = Db::name('domain');
        return $db->where(['domain'=>$domain])->delete();
    }
}