<?php

// includes and security
include_once('../../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// pickup params
$gateway_id = (int) $_REQUEST['gateway_id'];
$gateway_settings = $_REQUEST['gateway_settings'];
$gateway_config_id = isset($_REQUEST['gateway_config_id'])?(int)$_REQUEST['gateway_config_id']:null;

// load the gateway for later
$gateway = $db->getRow('SELECT * FROM plugin_payment_gateways WHERE id = '.(int)$gateway_id.' LIMIT 1');

// prepare result
$result = array();
$result['error'] = false;
$result['msg'] = '';

// validate submission
if($gateway_id == 0)
{
    $result['error'] = true;
    $result['msg'] = adminFunctions::t("gateway_invalid", "Please specify the gateway.");
}
elseif(_CONFIG_DEMO_MODE == true)
{
    $result['error'] = true;
    $result['msg'] = adminFunctions::t("no_changes_in_demo_mode");
}

if(strlen($result['msg']) == 0)
{
    if($gateway_config_id > 0)
    {
        // update the existing record
        $dbUpdate = new DBObject("plugin_payment_gateways_configured", array("gateway_id", "params", "date_updated"), 'id');
        $dbUpdate->gateway_id = $gateway_id;
        $dbUpdate->params = json_encode($gateway_settings, true);
        $dbUpdate->date_updated = coreFunctions::sqlDateTime();
        
        $dbUpdate->id = $gateway_config_id;
        $dbUpdate->update();

        $result['error'] = false;
        $result['msg'] = 'Gateway config for \'' . $gateway['label'] . '\' updated.';
    }
    else
    {
        // add the gateway entry
        $dbInsert = new DBObject("plugin_payment_gateways_configured", array("gateway_id", "params", "status", "date_created"));
        $dbInsert->gateway_id = $gateway_id;
        $dbInsert->params = json_encode($gateway_settings, true);
        $dbInsert->status = 'active';
        $dbInsert->date_created = coreFunctions::sqlDateTime();
        if(!$dbInsert->insert())
        {
            $result['error'] = true;
            $result['msg'] = adminFunctions::t("gateway_error_problem_record", "There was a problem adding the gateway config, please try again.");
        }
        else
        {
            $result['error'] = false;
            $result['msg'] = 'Gateway config for \'' . $gateway['label'] . '\' has been added.';
        }
    }
}

echo json_encode($result);
exit;
