<?php
// initial constants
define('ADMIN_SELECTED_PAGE', 'payment');
define('ADMIN_SELECTED_SUB_PAGE', 'payment_manage');

// includes and security
include_once('../../../core/includes/master.inc.php');
include_once(DOC_ROOT . '/' . ADMIN_FOLDER_NAME . '/_local_auth.inc.php');

// load plugin details
$plugin = $db->getRow("SELECT * FROM plugin WHERE folder_name = 'payment' LIMIT 1");
if(!$plugin)
{
    adminFunctions::redirect(ADMIN_WEB_ROOT . '/plugin_manage.php?error=' . urlencode('There was a problem loading the plugin details.'));
}
define('ADMIN_PAGE_TITLE', $plugin['plugin_name'] . ' Plugin Settings');
$pluginObj = pluginHelper::getInstance('payment');

// preload available gateways for bottom list
$availableGateways = $pluginObj->getAvailableGatewayGroups();

// action any requests
if(isset($_REQUEST['remove_gateway_config_id'])) {
    $db->query('DELETE FROM plugin_payment_gateways_configured WHERE id = '.(int)$_REQUEST['remove_gateway_config_id'].' LIMIT 1');
}

if(isset($_REQUEST['enable_gateway_config_id'])) {
    $db->query('UPDATE plugin_payment_gateways_configured SET status = "active" WHERE id = '.(int)$_REQUEST['enable_gateway_config_id'].' LIMIT 1');
}

if(isset($_REQUEST['disable_gateway_config_id'])) {
    $db->query('UPDATE plugin_payment_gateways_configured SET status = "disabled" WHERE id = '.(int)$_REQUEST['disable_gateway_config_id'].' LIMIT 1');
}

// prepare variables
$plugin_enabled = (int) $plugin['plugin_enabled'];
$pluginId = (int) $plugin['id'];

// handle page submissions
if(isset($_REQUEST['submitted']))
{
    // validate submission
    if(_CONFIG_DEMO_MODE == true)
    {
        adminFunctions::setError(adminFunctions::t("no_changes_in_demo_mode"));
    }

    // update the settings
    if(adminFunctions::isErrors() == false)
    {
        // update the user
        $dbUpdate = new DBObject("plugin", array("plugin_enabled", "plugin_settings"), 'id');
        $dbUpdate->plugin_enabled = $plugin_enabled;
        $dbUpdate->id = $pluginId;
        $dbUpdate->update();

        // update plugin config
        pluginHelper::loadPluginConfigurationFiles(true);
        adminFunctions::setSuccess('Plugin settings updated.');
    }
}

// page header
include_once(ADMIN_ROOT . '/_header.inc.php');
?>

<div class="right_col">
    <div>
        <div class="page-title">
            <div class="title_left">
                <h3><?php echo ADMIN_PAGE_TITLE; ?></h3>
            </div>
        </div>
        <div class="clearfix"></div>
        
        <div class="row">
            <div class="col-md-12 col-sm-12 col-xs-12">
                <?php echo adminFunctions::compileNotifications(); ?>
                <form method="POST" action="settings.php" name="pluginForm" id="pluginForm" autocomplete="off" class="form-horizontal form-label-left">
                    <div class="x_panel">
                        <div class="x_title">
                            <h2>Plugin State</h2>
                            <div class="clearfix"></div>
                        </div>
                        <div class="x_content">
                            <p>Whether the payment gateways plugin is enabled. Setting this to 'No' will disable any payments on the site.</p>
                            <div class="form-group">
                                <label class="control-label col-md-3 col-sm-3 col-xs-12">Plugin Enabled:</label>
                                <div class="col-md-6 col-sm-6 col-xs-12">
                                    <select name="plugin_enabled" id="plugin_enabled" class="form-control">
                                        <?php
                                        $enabledOptions = array(0 => 'No', 1 => 'Yes');
                                        foreach($enabledOptions AS $k => $enabledOption)
                                        {
                                            echo '<option value="' . $k . '"';
                                            if($plugin_enabled == $k)
                                            {
                                                echo ' SELECTED';
                                            }
                                            echo '>' . $enabledOption . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="x_panel">
                        <div class="x_content">
                            <div class="form-group">
                                <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-3">
                                    <button type="button" class="btn btn-default" onClick="window.location = '<?php echo ADMIN_WEB_ROOT; ?>/plugin_manage.php';">Cancel</button>
                                    <button type="button" class="btn btn-default" onClick="window.location = 'gateway_manage.php';">Manage Gateways</button>
                                    <button type="submit" class="btn btn-primary">Save Settings</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <input name="submitted" type="hidden" value="1"/>
                </form>
            </div>
        </div>
    </div>
</div>

<div class="customFilter" id="customFilter" style="display: none;"></div>

<div id="addGatewayFormWrapper" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header"><button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span></button></div>
            <div class="modal-body" id="addGatewayForm"></div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onClick="processEnableGateway(); return false;">Save Gateway</button>
            </div>
        </div>
    </div>
</div>

<?php
include_once(ADMIN_ROOT . '/_footer.inc.php');
?>