<?php
/**
 * 评论回复邮件提醒插件
 *
 * @package CommentToMail
 * @author DEFE
 * @version 1.2.3
 * @link http://defe.me
 */
class CommentToMail_Plugin implements Typecho_Plugin_Interface {
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate() {
        if (!ini_get('allow_url_fopen')) {
            throw new Typecho_Plugin_Exception(_t('对不起, 您的主机没有打开 allow_url_fopen 功能, 无法正常使用此插件'));
        }
        
        Typecho_Plugin::factory('Widget_Feedback')->finishComment = array('CommentToMail_Plugin', 'toMail');
        return _t('请对插件进行正确设置，以使插件顺利工作！');
    }

    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate() {

    }

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form) {
        $cfg_mode= new Typecho_Widget_Helper_Form_Element_Radio('cfg_mode',
                array( 'smtp' => 'smtp',
                       'mail' => 'mail()',
                       'sendmail' => 'sendmail()'),
                'smtp', '发信方式');
        $form->addInput($cfg_mode);

        $cfg_host = new Typecho_Widget_Helper_Form_Element_Text('cfg_host', NULL, 'smtp.',
                _t('SMTP地址'), _t('请填写 SMTP 服务器地址'));
        $form->addInput($cfg_host->addRule('required', _t('必须填写一个SMTP服务器地址')));

        $cfg_port = new Typecho_Widget_Helper_Form_Element_Text('cfg_port', NULL, '25',
                _t('SMTP端口'), _t('SMTP服务端口,一般为25。'));
        $cfg_port->input->setAttribute('class', 'mini');
        $form->addInput($cfg_port->addRule('required', _t('必须填写SMTP服务端口'))
                ->addRule('isInteger', _t('端口号必须是纯数字')));

        $cfg_user = new Typecho_Widget_Helper_Form_Element_Text('cfg_user', NULL, NULL,
                _t('SMTP用户'),_t('SMTP服务验证用户名,一般为邮箱名如：youname@domain.com'));
        $form->addInput($cfg_user->addRule('required', _t('SMTP服务验证用户名')));

        $cfg_pass = new Typecho_Widget_Helper_Form_Element_Password('cfg_pass', NULL, NULL,
                _t('SMTP密码'));
        $form->addInput($cfg_pass->addRule('required', _t('SMTP服务验证密码')));

        $cfg_validate=new Typecho_Widget_Helper_Form_Element_Checkbox('cfg_validate',
                array('validate'=>'服务器需要验证',
                    'ssl'=>'ssl加密'),
                array('validate'),'SMTP验证');
        $form->addInput($cfg_validate);

        $cfg_mail = new Typecho_Widget_Helper_Form_Element_Text('cfg_mail', NULL, NULL,
                _t('接收邮箱'),_t('接收邮件用的信箱,如为空则使用文章作者个人设置中的邮箱！'));
        $form->addInput($cfg_mail->addRule('email', _t('请填写正确的邮箱！')));

        $cfg_send = new Typecho_Widget_Helper_Form_Element_Checkbox('cfg_send',
                array('approved' => '提醒已通过评论',
                        'waiting' => '提醒待审核评论',
                        'spam' => '提醒垃圾评论'),
                array('approved', 'waiting'), '提醒设置',_t('该选项仅针对博主，访客只发送已通过的评论。'));
        $form->addInput($cfg_send);

        $cfg_other = new Typecho_Widget_Helper_Form_Element_Checkbox('cfg_other',
                array('to_owner' => '有评论及回复时，发邮件通知博主。',
                    'to_guest' => '评论被回复时，发邮件通知评论者。',
                    'to_me'=>'自己回复自己的评论时，发邮件通知。(同时针对博主和访客)',
                    'to_log' => '记录邮件发送日志。'),
                array('to_owner','to_guest','to_me'), '其他设置',_t('如果选上"记录邮件发送日志"选项，则会在./CommentToMail/log/mail_log.txt 文件中记录发送信息。<br />
                    关键性错误日志将自动记录到./CommentToMail/log/error_log.txt文件中。<br />
                    '));
        $form->addInput($cfg_other->multiMode());

        $cfg_title = new Typecho_Widget_Helper_Form_Element_Text('cfg_title',null,"[{site}]:《{title}》有新的评论",
                _t('博主接收邮件标题'));
        $form->addInput($cfg_title);

        $cfg_format = new Typecho_Widget_Helper_Form_Element_Textarea('cfg_format', NULL, NULL,
			_t('邮件正文'), _t('站名{site} 文章名{title} 作者{author} IP{ip} 评论者邮箱{mail} 评论链接{permalink} <br />
                            管理评论链接{manage} 评论内容{text} 时间{time} 评论状态{status}'));
        $form->addInput($cfg_format);

        $cfg_title1 = new Typecho_Widget_Helper_Form_Element_Text('cfg_title1',null,"[{site}]:您在《{title}》的评论有了回复",
                _t('访客接收邮件标题'));
        $form->addInput($cfg_title1);

        $cfg_format1 = new Typecho_Widget_Helper_Form_Element_Textarea('cfg_format1', NULL, "",
			_t('回复邮件正文'), _t('站名{site} 文章名{title} 作者{author} IP{ip} 评论者邮箱{mail} 评论链接{permalink} <br />评论内容{text} 原评论作者{author_p} 原评论内容{text_p}'));
        $form->addInput($cfg_format1);
    }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form) {

    }

    /**
     * 组合邮件内容
     *
     * @access public
     * @param $post 调用参数
     * @return void
     */
    public static function toMail($post) {       
        
        $db = Typecho_Db::get();
        $smtp=array();
        
        $options = Typecho_Widget::widget('Widget_Options');
        $smtp['site'] = $options->title;       
        
        $settings = Helper::options()->plugin('CommentToMail');
        
        $smtp['mode']=$settings->cfg_mode; 

        /**获取SMTP设置*/
        $smtp['user'] = $settings->cfg_user;
        $smtp['pass'] = $settings->cfg_pass;
        $smtp['host'] = $settings->cfg_host;
        $smtp['port'] = $settings->cfg_port;

        if(in_array('to_log',$settings->cfg_other)) $smtp['maillog']=TRUE;

        //获取验证信息
        if(in_array('validate',$settings->cfg_validate)) $smtp['validate']=true;
        if(in_array('ssl',$settings->cfg_validate)) $smtp['ssl']=true;
        
        $smtp['cid']=$post->cid;
        $smtp['coid']=$post->coid;
        $smtp['created']=$post->created;
        $smtp['author']=$post->author;
        $smtp['authorId']=$post->authorId;
        $smtp['ownerId']=$post->ownerId;
        $smtp['mail']=$post->mail;
        $smtp['ip']=$post->ip;
        $smtp['title']=$post->title;
        $smtp['text']=$post->text;
        $smtp['permalink']=$post->permalink;
        $smtp['status']=$post->status;
        $smtp['parent']=$post->parent;
        
        //向博主发邮件的标题格式和邮件正文格式
        $smtp['ownerSubject']=$settings->cfg_title;
        $smtp['ownerBody']=$settings->cfg_format;
        
        //向访客发邮件的标题格式和邮件正文格式
        $smtp['guestSubject']=$settings->cfg_title1;        
        $smtp['guestBody']=$settings->cfg_format1;
        
        $smtp['manage']= $options->siteUrl."admin/manage-comments.php";
        //$smtp['acceptMail']=$_POST['acceptmail'];
        //获取是否接收邮件的选项        
        if(isset ($_POST['banmail']) && 'stop' == $_POST['banmail']){
            $smtp['banMail']=1;
        }  else{
            $smtp['banMail']=0;
        }
        
        //验证博主是否接收自己的邮件
        $to_me=(!in_array('to_me',$settings->cfg_other) && $post->ownerId==$post->authorId)?FALSE:TRUE;
      
        //向博主发送邮件  不接收自己的评论
        if(in_array($post->status,$settings->cfg_send) && in_array('to_owner',$settings->cfg_other) && $to_me){ //&& $post->ownerId!=$post->authorId 
            if(!empty ($settings->cfg_mail)){
                $smtp['toOwner']=$settings->cfg_mail;
            }else{
                Typecho_Widget::widget('Widget_Users_Author@' . $post->cid, array('uid' => $post->authorId))->to($users);
                $smtp['toOwner']=$users->mail;                
            } 
        }
        
        //向访客发送邮件
        if(0!=$post->parent && 'approved'==$post->status && in_array('to_guest',$settings->cfg_other)){
            $select=$db->select('author', 'mail', 'text')
                    ->from('table.comments')
                    ->where('coid = ?', $post->parent);
            $result = $db->query($select);
            $original = $db->fetchRow($result);
            if(!in_array('to_me',$settings->cfg_other) && $post->mail==$original['mail']){
                $smtp['toGuest']='';
            }else{
                $smtp['toGuest']=$original['mail'];
                $smtp['originalText']=$original['text'];
                $smtp['originalAuthor']=$original['author']; 
            }
        }
               
        //只有当发送博主或访客的邮箱任意一个不为空时执行发送邮件
        if(!empty ($smtp['toOwner']) || !empty ($smtp['toGuest'])){
            $filename=Typecho_Common::randString(4).time();
            $smtp= (object)$smtp;
            file_put_contents('./usr/plugins/CommentToMail/cache/'.$filename, gzdeflate(serialize($smtp)));
            self::SendMail($filename,$options->siteUrl);
        }
        
        //多少释放点内存
        $db=$smtp=null;
    }    
     /**
     * 发送邮件
     *
     * @access public
     * @param string $filename 存放邮件的临时文件名
     * @param string $siteUrl 网站连接
     * @return void
     */
    public static function SendMail($filename,$siteUrl) {
        $dmpt=parse_url($siteUrl);
        $host = $dmpt['host'];
        $url=substr($dmpt['path'], 0,-1).__TYPECHO_PLUGIN_DIR__."/CommentToMail/send_mail.php";      
        
        $get='mail='.base64_encode($filename);

        $head = "GET ". $url . "?" . $get . " HTTP/1.0\r\n";
        $head .= "Host: " . $host . "\r\n";
        $head .= "\r\n";
             
        $fp = @fsockopen ($host, 80, $errno, $errstr, 30);
        if($fp){                
            fputs ($fp, $head);                
            fclose($fp);
        }else{
             file_put_contents('.'.__TYPECHO_PLUGIN_DIR__.'/CommentToMail/log/error_log.txt', "fsockopen错误--".$errno.':'.$errstr);
        }
      
    }

}
