<?php
/**
 * 邀请码注册（测试版）
 *
 * @package InvitationCode
 * @author 晨曦啊
 * @version 0.1.0
 * @link https://cx-a.com
 *
 * 历史版本
 * version 0.1.0 at 2018-11-12
 * 不用替换文件
 * 正常返回提示，页面不跳转
 * version 0.0.1 at 2018-11-11
 * 邀请码注册
 *
 */

class InvitationCode_Plugin implements Typecho_Plugin_Interface
{
    /**
     * 激活插件方法,如果激活失败,直接抛出异常
     *
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate()
    {
        //Typecho_Plugin::factory('admin/register.php')->InvitationCodeInput = array('InvitationCode_Plugin', 'add_input');
     	Typecho_Plugin::factory('admin/footer.php')->end = array('InvitationCode_Plugin', 'add_input');
        Typecho_Plugin::factory('Widget_Register')->register = array('InvitationCode_Plugin', 'render');
        return _t('开启成功！');
    }


    /**
     * 禁用插件方法,如果禁用失败,直接抛出异常
     *
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate(){}

    /**
     * 获取插件配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form)
    {
        $open = new Typecho_Widget_Helper_Form_Element_Radio('open_cxa', array("on" => "开启", "off" => "关闭"), "on",
            _t('是否开启邀请码注册'), "请尝试进行评论测试，以免不同模板造成误判。");
        $form->addInput($open);

        $code = new Typecho_Widget_Helper_Form_Element_Textarea('code_cxa', NULL, "cxa.com",
            _t('邀请码'), _t('多条邀请码请用换行符隔开'));
        $form->addInput($code);
    }

    /**
     * 个人用户的配置面板
     *
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form){}

    /**
     * 插件实现方法
     *
     * @access public
     * @return void
     */
    public static function render($dataStruct)
    {
        $options = Typecho_Widget::widget('Widget_Options');
        $set = $options->plugin('InvitationCode');
        if($set->open_cxa == 'on'){
            $code=$_POST['code_cxa'];
            $code_arr = explode("\n", $set->code_cxa);
            if (empty($code)) {
              	$error=['code_cxa'=>'未填填写邀请码！'];
              	InvitationCode_Plugin::Tips_cxa($error);
            }
      
            if (!$code_arr || $code_arr[0] == '') {
              	$error=['code_cxa'=>'系统未填设置邀请码！请在后台设置！'];
                InvitationCode_Plugin::Tips_cxa($error);
            }

            foreach ($code_arr as $value) {
                if(trim($code) === trim($value)){
                    return $dataStruct;
                }
            }

            $error=['code_cxa'=>'邀请码错误！'];
            InvitationCode_Plugin::Tips_cxa($error);
        }
        return $dataStruct;
    }
	public static function Tips_cxa($error){
        $notice = is_array($error) ? array_values($error) : array($error);
        Typecho_Cookie::set('__typecho_notice', Json::encode($notice));
        Typecho_Cookie::set('__typecho_notice_type', 'notice');
        Typecho_Cookie::set('__typecho_remember_name', $_POST['name']);
        Typecho_Cookie::set('__typecho_remember_mail', $_POST['mail']);
        InvitationCode_Plugin::goBack_c();
    }
     /**
     * 返回来路
     *
     * @access public
     * @param string $suffix 附加地址
     * @param string $default 默认来路
     */
    public static function goBack_c($suffix = NULL, $default = NULL)
    {
        //获取来源
        $referer = isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '';

        //判断来源
        if (!empty($referer)) {
            // ~ fix Issue 38
            if (!empty($suffix)) {
                $parts = parse_url($referer);
                $myParts = parse_url($suffix);

                if (isset($myParts['fragment'])) {
                    $parts['fragment'] = $myParts['fragment'];
                }

                if (isset($myParts['query'])) {
                    $args = array();
                    if (isset($parts['query'])) {
                        parse_str($parts['query'], $args);
                    }

                    parse_str($myParts['query'], $currentArgs);
                    $args = array_merge($args, $currentArgs);
                    $parts['query'] = http_build_query($args);
                }

                $referer = Typecho_Common::buildUrl($parts);
            }

            InvitationCode_Plugin::redirect_c($referer, false);
        } else if (!empty($default)) {
            InvitationCode_Plugin::redirect_c($default);
        }
        exit;
    }
  
      /**
     * 重定向函数
     *
     * @access public
     * @param string $location 重定向路径
     * @param boolean $isPermanently 是否为永久重定向
     * @return void
     */
    public static function redirect_c($location, $isPermanently = false)
    {
        /** Typecho_Common */
        $location = Typecho_Common::safeUrl($location);

        if ($isPermanently) {
            header('Location: ' . $location, false, 301);
            exit;
        } else {
            header('Location: ' . $location, false, 302);
            exit;
        }
    }
  
  
    public static function add_input(){
        $options = Typecho_Widget::widget('Widget_Options');
      	$url=$_SERVER['PHP_SELF'];
      	if(preg_match('/admin\/register.php/',$url)){
            $set = $options->plugin('InvitationCode');
            if($set->open_cxa == 'on'){
                $ja=<<<a
<script>
var mail=document.getElementById('mail');
var inputs='<p><label for="code_cxa" class="sr-only">邀请码</label><input type="text" id="code_cxa" name="code_cxa" placeholder="邀请码" value="" class="text-l w-100" /></p>';
var p_input = document.createElement("p");
    p_input.id = "code_input";
mail.parentNode.appendChild(p_input);
document.getElementById('code_input').innerHTML=inputs;
</script>
a;
		echo $ja;
            }
        }
    }
}