<?php
/*
	OAuth After Execution Hook Point
	This file is executed after OAuth does any API function calls.
	This will allow you to add additional security to your copy of OAuth.
	
	$APICommand is the API command that ran or was suppossed to run.
	
	$isClient is set to true if the key is for a specific client and false if the key has admin permissions
	
	$clientid is set to the clients id value or 0 for admin key.
	
	$allowedFunctions is a list of functions specifically allowed for this particular key.
	
	$deniedFunctions is a list of functions specifically denied for this particular key.
	
	$return is an array of values that is to be returned to the initial request.
	
	If $return["result"] = "success" then the API call was run successfully.
	
	** Please note this is not meant to be used to extend the OAuth API **
*/

// If this is a client make an API Call
if ($isClient) {
	// Removal of admin notes in certain functions
	unset($return["notes"]);
	unset($return["adminnotes"]);
	
	// You can unset any returned value by using the unset variable. The values will not be returned to the client.
}

?>