<?php
//加密方式:ioncube 
//此程序由【PHP解密】http://www.phpjiemi.com/ (VIP会员功能）在线逆向还原，QQ：2436152386
//会员:sky@03sec.com 您好,破解:ioncube加密,本次扣金币:1个,金币余额:9个,感谢您的支持. 
?>
<?php  namespace MGModule\AdvancedBilling\extensions\CreditBilling;
class CreditBilling extends \MGModule\AdvancedBilling\core\extension\Extension implements \MGModule\AdvancedBilling\core\events\WHMCSBasedEvents 
{
	public $type = self::TYPE_BASE;
	public $name = "CreditBilling";
	public $friendlyName = "Credit Billing";
	public $description = "Extension used to charge clients for their products from their credit balance";
	public $version = "1.0.1";
	public $customPages = array( "credits" => array( "title" => "User Credits", "icon" => "glyphicon glyphicon-euro" ) );
	const EMAIL_LOW_CREDIT_REMINDER = 1;
	public function __construct() 
	{
		parent::__construct();
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("enable", "enable", "Enable Credit Billing", "Check this option if you want to enable Credit Billing for this product", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("billingPeriod", "billingPeriod", "Create Invoice Each", "Days", 30);
		$obj->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("minimalCredit", "minimalCredit", "Minimum Credit", "Minimum amount that will be charged from client's account", 10);
		$obj->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("lowCreditNotify", "lowCreditNotify", "Low Credit Notification", "Send email Notification about low credit amount on account", 50);
		$obj->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("emailInterval", "emailInterval", "Email Inverval", "Set email interval for email notification", 3);
		$obj->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("autosuspend", "autosuspend", "Autosuspend", "Autosuspend account when user does not have sufficient funds", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("dueDate", "dueDate", "Due Date", "Days", 7);
		$obj->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$gateways = $this->getCCGateways();
		$autoRefill = new \MGModule\AdvancedBilling\core\form\fields\Switcher("autoRefillEnable", "autoRefillEnable", "Autorefill", "Enable to charge from client's credit card when client's balance reach 0", false);
		$autoRefill->addStyle("colWidth", 9);
		$arGateway = new \MGModule\AdvancedBilling\core\form\fields\Select2("autoRefillGateway", "autoRefillGateway", "Gateway", "", 0, 0, $gateways);
		$arGateway->addStyle("colWidth", 9);
		$arAmount = new \MGModule\AdvancedBilling\core\form\fields\Text("autoRefillMinimalAmount", "autoRefillMinimalAmount", "Minimum Amount", "Minimum amount to charge from client's credit card", 30);
		$arAmount->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		$arMaxAmmount = new \MGModule\AdvancedBilling\core\form\fields\Text("autoRefillMaximalAmount", "autoRefillMaximalAmount", "Maximum Amount", "Maximum amount to charge from client's credit card", 100);
		$arMaxAmmount->addStyle("additionalClass", "form-inline")->addStyle("colWidth", 9);
		if( empty($gateways) ) 
		{
			$autoRefill->addStyle("display", "none");
			$arGateway->addStyle("display", "none");
			$arAmount->addStyle("display", "none");
			$arMaxAmmount->addStyle("display", "none");
		}
		$this->productConfiguration->add($autoRefill);
		$this->productConfiguration->add($arGateway);
		$this->productConfiguration->add($arAmount);
		$this->productConfiguration->add($arMaxAmmount);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("extension", "extension", "", "", $this->name);
		$obj->addStyle("additionalClass", "hidden");
		$this->extensionConfiguration->add($obj);
		$license = new \MGModule\AdvancedBilling\core\form\fields\Text("license", "license", "License Key");
		$license->addStyle("colWidth", 9)->addStyle("custom", "width: 100%");
		$this->extensionConfiguration->add($license);
	}
	public function setValidation($settings) 
	{
		if( empty($settings["enable"]) ) 
		{
			return NULL;
		}
		$obj =& $this->productConfiguration->get("billingPeriod");
		$obj->validation = "int|required";
		$obj =& $this->productConfiguration->get("minimalCredit");
		$obj->validation = "int|required";
		$obj =& $this->productConfiguration->get("lowCreditNotify");
		$obj->validation = "int|required";
		$obj =& $this->productConfiguration->get("dueDate");
		$obj->validation = "int";
		if( $settings["autoRefillEnable"] ) 
		{
			$arAmount =& $this->productConfiguration->get("autoRefillMinimalAmount");
			$arAmount->validation = "numeric";
			$arMaxAmmount =& $this->productConfiguration->get("autoRefillMaximalAmount");
			$arMaxAmmount->validation = "numeric";
		}
	}
	public function getCCGateways() 
	{
		$gateways = array( );
		$q = \MGModule\AdvancedBilling\classes\Database::getInstance()->getAll("SELECT DISTINCT gateway FROM tblpaymentgateways WHERE setting='type' AND LOWER(value)='cc' ");
		foreach( $q as $row ) 
		{
			$gateways[$row->gateway] = $row->gateway;
		}
		return $gateways;
	}
	public function cronStart() 
	{
	}
	public function cronEnd() 
	{
		$accounts = models\Autosuspend::factory()->where("suspended", "=", 0)->fetchAll();
		foreach( $accounts as $account ) 
		{
			$result = \MGModule\AdvancedBilling\Addon::localAPICall("modulesuspend", array( "accountid" => $account->hostingId, "suspendreason" => "Low Credits Amount" ));
			if( $result["result"] == "success" ) 
			{
				$acc = models\Autosuspend::factory($account->hostingId);
				$acc->suspended = 1;
				$acc->save();
			}
		}
	}
	public function cronLoop($productId) 
	{
		$this->loadProductConfiguration($productId);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return NULL;
		}
		$interval = (0 < intval($this->productConfiguration->get("billingPeriod")->value) ? intval($this->productConfiguration->get("billingPeriod")->value) : 1);
		$hostings = \MGModule\AdvancedBilling\models\AdvancedBilling\Hosting::factory()->select(array( "id" => null ))->where("packageid", "=", $productId)->fetchAll();
		foreach( $hostings as $hosting ) 
		{
			$acc = new \MGModule\AdvancedBilling\classes\Account($hosting->id);
			if( $acc->hasRecords() && ($acc->data["invoiceDate"] == "" || $acc->data["invoiceDate"] <= strtotime("-" . $interval . " Days")) ) 
			{
				$accounts[] = $acc;
			}
		}
		$this->billAccounts($accounts, $productId);
	}
	private function billAccounts($accounts, $productId) 
	{
		foreach( $accounts as $acc ) 
		{
			$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
			$invoiceId = $invoice->generateInvoice($productId, $acc->hosting->id, true, true, $this->productConfiguration->get("dueDate")->value, false);
			unset($invoice);
			if( $invoiceId !== false ) 
			{
				$this->payForHosting($acc, $invoiceId);
			}
		}
	}
	private function payForHosting($acc, $invoiceId) 
	{
		$paid = $this->calcPaidAmount($acc->hosting->id, $acc->client->id, $invoiceId);
		$result = \MGModule\AdvancedBilling\Addon::localAPICall("addinvoicepayment", array( "invoiceid" => $invoiceId, "transid" => "Credit Pay For Hosting #" . $acc->id . " - " . date("Y-m-d H:i:s"), "amount" => round($paid, 2), "paymentmethod" => $acc->hosting->paymentmethod, "noemail" => true ));
		if( $result["result"] == "success" ) 
		{
			$hostingData = \MGModule\AdvancedBilling\models\AdvancedBilling\HostingData::factory($acc->hosting->id);
			$data["invoiceDate"] = time();
			$hostingData->updateData($acc->hosting->id, $data);
			$credits = models\UsersCredits::factory()->where("hostingId", "=", $acc->hosting->id)->andWhere("userId", "=", $acc->client->id)->fetchOne();
			$credits->hostingId = $acc->hosting->id;
			$credits->userId = $acc->client->id;
			$credits->paid = 0;
			$credits->save();
		}
		$acc->deleteAllItems();
	}
	private function calcPaidAmount($hostingId, $userId, $invoiceId) 
	{
		$credits = models\UsersCredits::factory()->where("hostingId", "=", $hostingId)->andWhere("userId", "=", $userId)->fetchOne();
		$invoice = \MGModule\AdvancedBilling\classes\Database::getInstance()->getRow("SELECT * FROM tblinvoices WHERE id=" . $invoiceId);
		$paidAmount = 0;
		$abs = abs($invoice->total - $credits->paid);
		if( $abs <= 0.01 ) 
		{
			$paidAmount = $invoice->total;
		}
		else 
		{
			$paidAmount = $credits->paid;
		}
		return $paidAmount;
	}
	public function resourceAdded($recordId, $hostingId) 
	{
		$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
		$this->loadProductConfiguration($account->product->id);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return NULL;
		}
		$record = \MGModule\AdvancedBilling\models\AdvancedBilling\Records::factory($account->product->submodule);
		$recordTotal = $record->getPriceToPay($account->hosting->id, $recordId);
		if( $recordTotal <= 0 ) 
		{
			return NULL;
		}
		if( $this->productConfiguration->get("autoRefillEnable")->value ) 
		{
			$this->autoRefill($account->client->id, $account->hosting->id, $recordTotal);
		}
		$credits = models\UsersCredits::factory()->where("hostingId", "=", $hostingId)->andWhere("userId", "=", $account->client->id)->fetchOne();
		$creditAmount = $credits->credit + $account->client->credit;
		$warned = false;
		if( $creditAmount < $this->productConfiguration->get("lowCreditNotify")->value ) 
		{
			$warned = $this->sendNotificationEmail($hostingId, $account->client->id);
		}
		if( $credits->credit <= $recordTotal && 0.01 < $account->client->credit ) 
		{
			$this->getCreditsFromClient($account->client->id, $account->hosting->id, $recordTotal);
		}
		$credits->fetchOne();
		if( $this->checkAccountToSuspend($account, $recordTotal, $credits->credit) ) 
		{
			$this->suspendAccount($hostingId, $account->product->id, $account->client->id);
		}
		$credits->fetchOne();
		if( $recordTotal <= $credits->credit ) 
		{
			$credits->credit = $credits->credit - $recordTotal;
			$credits->paid = $credits->paid + $recordTotal;
			$credits->save();
		}
	}
	private function autoRefill($userId, $hostingId, $recordTotal) 
	{
		$settings = models\AutoRefill::factory($hostingId);
		if( $settings->isEmpty() ) 
		{
			return NULL;
		}
		$client = \MGModule\AdvancedBilling\classes\Database::getInstance()->getRow("SELECT credit FROM tblclients WHERE id = " . $userId);
		$charge = 0;
		$diff = $client->credit - $recordTotal;
		if( 0 < $settings->autoRefillValue && $diff < $settings->autoRefilUnder ) 
		{
			$charge = $settings->autoRefillValue;
		}
		else 
		{
			if( $diff < $settings->autoRefilUnder && $settings->autoRefillValue <= 0 ) 
			{
				$charge = abs($settings->autoRefilUnder - $diff);
			}
			else 
			{
				if( $diff < 0 ) 
				{
					$charge = abs($diff);
				}
			}
		}
		if( 0 < $charge ) 
		{
			$this->chargeClientCard($charge, $userId, $hostingId);
		}
	}
	private function chargeClientCard($charge, $userId, $hostingId) 
	{
		try 
		{
			$client = new \MGModule\AdvancedBilling\classes\Client($userId);
			$ccCharged = $client->chargeCreditCard($this->productConfiguration->get("autoRefillGateway")->value, $charge);
			if( $ccCharged ) 
			{
				\MGModule\AdvancedBilling\Addon::localAPICall("addcredit", array( "clientid" => $userId, "description" => "Credit Card Has Been Charged For Hosting #" . $hostingId . "(" . date("Y-m-d H:i:s") . ")", "amount" => $charge ));
			}
			\MGModule\AdvancedBilling\classes\Logger::info("Service #" . $hostingId . ". User #" . $userId . " has been charged for " . $charge);
		}
		catch( \Exception $e ) 
		{
			\MGModule\AdvancedBilling\classes\Logger::error("Service #" . $hostingId . ". User #" . $userId . " " . $e->getMessage());
		}
	}
	private function isAutoSuspendOverrided($account) 
	{
		$overrideAutoSuspend = $account->hosting->overrideautosuspend;
		$overrideSuspendUntil = ($account->hosting->overidesuspenduntil ? time() < strtotime($account->hosting->overidesuspenduntil) : false);
		if( $account->hosting->overrideautosuspend && $account->hosting->overidesuspenduntil != "0000-00-00" ) 
		{
			return $overrideAutoSuspend && $overrideSuspendUntil;
		}
		if( $account->hosting->overrideautosuspend ) 
		{
			return $overrideAutoSuspend;
		}
	}
	public function checkAccountToSuspend($account, $recordTotal, $credit) 
	{
		return $credit < $recordTotal && $this->productConfiguration->get("autosuspend")->value && $this->isAutoSuspendOverrided($account);
	}
	private function sendNotificationEmail($hostingId, $userId) 
	{
		$remainder = models\Remainders::factory()->where("hostingId", "=", $hostingId)->andWhere("emailType", "=", self::EMAIL_LOW_CREDIT_REMINDER)->orderBy("emailSentDate", "desc")->fetchOne();
		$emailInterval = $this->productConfiguration->get("emailInterval")->value * 3600 * 24;
		if( time() < $emailInterval + strtotime($remainder->emailSentDate) ) 
		{
			return false;
		}
		$result = \MGModule\AdvancedBilling\Addon::localAPICall("sendemail", array( "id" => $userId, "messagename" => "Credit Warning", "customvars" => array( "minimal_credit" => $this->productConfiguration->get("lowCreditNotify")->value ) ));
		if( $result["result"] == "success" ) 
		{
			$remainder->hostingId = $hostingId;
			$remainder->emailSentDate = date("Y-m-d H:i:s");
			$remainder->emailType = self::EMAIL_LOW_CREDIT_REMINDER;
			$remainder->save();
		}
		return true;
	}
	private function getCreditsFromClient($userId, $hostingId, $recordTotal) 
	{
		$userCredits = models\UsersCredits::factory()->where("hostingId", "=", $hostingId)->andWhere("userId", "=", $userId)->fetchOne();
		$credits = \MGModule\AdvancedBilling\models\AdvancedBilling\Clients::factory($userId)->fetchOne();
		$diff = ceil($recordTotal - $userCredits->credit);
		if( $diff < $this->productConfiguration->get("minimalCredit")->value ) 
		{
			$diff = $this->productConfiguration->get("minimalCredit")->value;
		}
		if( $credits->credit < $diff ) 
		{
			$diff = $credits->credit;
		}
		$result = \MGModule\AdvancedBilling\Addon::localAPICall("addcredit", array( "clientid" => $userId, "description" => "Credit Pay For Hosting #" . $hostingId . " (" . date("Y-m-d H:i:s") . ")", "amount" => $diff * -1 ));
		\MGModule\AdvancedBilling\classes\Logger::info((string) $diff . " credit has been taken from client #" . $userId . " account.");
		$userCredits->userId = $userId;
		$userCredits->hostingId = $hostingId;
		$userCredits->credit += $diff;
		$userCredits->save();
	}
	private function suspendAccount($hostingId, $productId, $clientId) 
	{
		$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
		$invoiceId = $invoice->generateInvoice($productId, $hostingId, true, true, $this->productConfiguration->get("dueDate")->value);
		unset($invoice);
		if( $invoiceId !== false ) 
		{
			$autosuspend = models\Autosuspend::factory($hostingId);
			$autosuspend->hostingId = $hostingId;
			$autosuspend->invoiceId = $invoiceId;
			$autosuspend->suspended = 0;
			$autosuspend->save();
			$credits = models\UsersCredits::factory()->where("hostingId", "=", $hostingId)->andWhere("userId", "=", $clientId)->fetchOne();
			if( 0.01 < $credits->credit ) 
			{
				$amount = round($credits->credit, 2, PHP_ROUND_HALF_UP);
				$hosting = \MGModule\AdvancedBilling\models\AdvancedBilling\Hosting::factory($hostingId);
				$result = \MGModule\AdvancedBilling\Addon::localAPICall("addinvoicepayment", array( "invoiceid" => $invoiceId, "transid" => "Credit Pay For Hosting #" . $hostingId . " - " . date("Y-m-d H:i:s"), "amount" => $credits->paid + $amount, "paymentmethod" => $hosting->paymentmethod, "noemail" => true ));
				if( $result["result"] == "success" ) 
				{
					$credits->credit = $credits->credit - $amount;
					$credits->save();
				}
			}
			$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
			$account->deleteAllItems();
		}
	}
	public function productUpgrade($params) 
	{
		$upgradeId = $params["upgradeid"];
		$upgrade = \MGModule\AdvancedBilling\classes\Database::getInstance()->getRow("SELECT u.*, c.id as clientId\n                    FROM tblupgrades u\n                    LEFT JOIN tblhosting h ON u.relid = h.id\n                    LEFT JOIN tblclients c ON h.userid = c.id\n                    WHERE u.id = ? AND u.type = 'package'", array( $upgradeId ));
		$hostingId = $upgrade->relid;
		$productId = $upgrade->originalvalue;
		$userId = $upgrade->clientId;
		$this->loadProductConfiguration($productId);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return NULL;
		}
		$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
		if( !$account->hasRecords() ) 
		{
			return NULL;
		}
		$dueDate = $this->productConfiguration->get("dueDate")->value;
		$firstItem = $account->getMixedItems(1, 0, null, null, "asc");
		$startDate = (empty($firstItem["fresh"]) ? $firstItem["hourly"]->
		{
			0}
		->time : $firstItem["fresh"]->
		{
			0}
		->time);
		$endDate = date("Y-m-d");
		$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
		$invoiceId = $invoice->generateInvoice($productId, $hostingId, true, true, $dueDate, false, $startDate, $endDate);
		$this->makeRefundForHosting($invoiceId, $userId, $account);
	}
	public function afterModuleChangePackage($params) 
	{
		if( !$_SESSION["adminid"] ) 
		{
			return NULL;
		}
		$currentPid = $params["params"]["pid"];
		$hostingId = $params["params"]["serviceid"];
		$userId = $params["clientsdetails"]["id"];
		$enabledPids = \MGModule\AdvancedBilling\classes\Database::getInstance()->getAll("SELECT productId FROM AdvancedBilling_ProductConfiguration \n                 WHERE enabled=1 AND productId != " . $currentPid);
		foreach( $enabledPids as $product ) 
		{
			$this->loadProductConfiguration($product->productId);
			if( !$this->productConfiguration->get("enable")->value ) 
			{
				continue;
			}
			$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
			$firstItem = $account->getMixedItems(1, 0, null, null, "asc");
			$startDate = (empty($firstItem["fresh"]) ? $firstItem["hourly"]->
			{
				0}
			->time : $firstItem["fresh"]->
			{
				0}
			->time);
			$endDate = date("Y-m-d");
			$dueDate = $this->productConfiguration->get("dueDate")->value;
			$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
			$invoiceId = $invoice->generateInvoice($product->productId, $hostingId, true, true, $dueDate, false, $startDate, $endDate);
			$this->makeRefundForHosting($invoiceId, $userId, $account);
		}
	}
	public function serviceDelete($params) 
	{
		$hostingId = $params["serviceid"];
		$credits = models\UsersCredits::factory()->where("hostingId", "=", $hostingId)->fetchAll();
		$credits->remove();
	}
	public function InvoicePaid($params) 
	{
		$invoiceId = $params["invoiceid"];
		$autosuspend = models\Autosuspend::factory()->where("invoiceId", "=", $invoiceId)->fetchOne();
		if( 0 < $autosuspend->count() ) 
		{
			$result = \MGModule\AdvancedBilling\Addon::localAPICall("moduleunsuspend", array( "accountid" => $autosuspend->hostingId ));
			$credits = models\UsersCredits::factory()->where("hostingId", "=", $autosuspend->hostingId)->fetchOne();
			$credits->warned = 0;
			$credits->save();
			$remainders = models\Remainders::factory()->where("hostingId", "=", $autosuspend->hostingId)->andWhere("emailType", "=", self::EMAIL_LOW_CREDIT_REMINDER)->fetchOne();
			$remainders->remove();
			$autosuspend->remove();
		}
	}
	public function afterModuleUnsuspend($params) 
	{
		$hostingId = $params["hostingid"];
		$autosuspend = models\Autosuspend::factory()->where("hostingId", "=", $hostingId)->fetchOne();
		$autosuspend->remove();
		$remainders = models\Remainders::factory()->where("hostingId", "=", $autosuspend->hostingId)->andWhere("emailType", "=", self::EMAIL_LOW_CREDIT_REMINDER)->fetchOne();
		$remainders->remove();
	}
	public function afterModuleTerminate($params) 
	{
		$hostingId = $params["params"]["accountid"];
		$productId = $params["params"]["pid"];
		$userId = $params["params"]["clientsdetails"]["id"];
		$this->loadProductConfiguration($productId);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return NULL;
		}
		$dueDate = $this->productConfiguration->get("dueDate")->value;
		$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
		$invoiceId = $invoice->generateInvoice($productId, $hostingId, true, true, $dueDate, false);
		$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
		$this->makeRefundForHosting($invoiceId, $userId, $account);
	}
	private function makeRefundForHosting($invoiceId, $userId, &$account) 
	{
		$credits = models\UsersCredits::factory()->where("userId", "=", $userId)->andWhere("hostingId", "=", $account->hosting->id)->fetchOne();
		if( $invoiceId !== false ) 
		{
			$invoice = \MGModule\AdvancedBilling\classes\Database::getInstance()->getRow("SELECT * FROM tblinvoices WHERE id = ?", array( $invoiceId ));
			$creditsTotal = $credits->credits + $credits->paid;
			if( $invoice->total < $creditsTotal ) 
			{
				$creditsTotal = $invoice->total;
			}
			if( $creditsTotal ) 
			{
				$res = \MGModule\AdvancedBilling\Addon::localAPICall("addtransaction", array( "userid" => $userId, "invoiceid" => $invoiceId, "description" => "Refund For Hosting #" . $account->hosting->id, "amountin" => $creditsTotal, "paymentmethod" => $account->hosting->paymentmethod ));
			}
			$account->deleteAllItems();
			$refund = $creditsTotal < $credits->credits + $credits->paid;
		}
		else 
		{
			$refund = $credits->credit;
		}
		if( 0 < $refund ) 
		{
			$result = \MGModule\AdvancedBilling\Addon::localAPICall("addcredit", array( "clientid" => $userId, "description" => "Refund For Hosting #" . $account->hosting->id, "amount" => $refund ));
		}
		$credits->remove();
	}
	public function integrationCodeShow($hostingId, $productId) 
	{
		$this->loadProductConfiguration($productId);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return NULL;
		}
		\MGModule\AdvancedBilling\mgLibs\Lang::setContext("CreditBilling");
		$MGLANG = \MGModule\AdvancedBilling\mgLibs\Lang::loadLangFromFile(__DIR__ . DS . "lang");
		if( $_REQUEST["modaction"] == "autorefill" ) 
		{
			if( isset($_REQUEST["enableAutoRefill"]) ) 
			{
				$minValue = $this->productConfiguration->get("autoRefillMinimalAmount")->value;
				$maxValue = $this->productConfiguration->get("autoRefillMaximalAmount")->value;
				if( $_REQUEST["autoRefillUnder"] < 0 ) 
				{
					$autoRefillError = \MGModule\AdvancedBilling\mgLibs\Lang::T("Value cannot be lower then 0");
				}
				else 
				{
					if( $_REQUEST["autoRefillValue"] < $minValue ) 
					{
						$autoRefillError = \MGModule\AdvancedBilling\mgLibs\Lang::T("Value cannot be lower then ") . $minValue;
					}
					else 
					{
						if( $maxValue < $_REQUEST["autoRefillValue"] ) 
						{
							$autoRefillError = \MGModule\AdvancedBilling\mgLibs\Lang::T("Value cannot be higher then ") . $maxValue;
						}
					}
				}
				if( empty($autoRefillError) ) 
				{
					$autorefill = models\AutoRefill::factory($hostingId);
					$autorefill->hostingId = $hostingId;
					$autorefill->autoRefillUnder = $_REQUEST["autoRefillUnder"];
					$autorefill->autoRefillValue = $_REQUEST["autoRefillValue"];
					$autorefill->save();
				}
				$autoRefillInfo = \MGModule\AdvancedBilling\mgLibs\Lang::T("Configuration has been saved");
			}
			else 
			{
				$autorefill = models\AutoRefill::factory($hostingId);
				$autorefill->remove();
				$autoRefillInfo = \MGModule\AdvancedBilling\mgLibs\Lang::T("Configuration has been saved");
			}
		}
		$autorefill = models\AutoRefill::factory($hostingId);
		$vars = array( "clientAutoRefill" => (0 < $autorefill->count() ? true : false), "autoRefillError" => $autoRefillError, "autoRefillInfo" => $autoRefillInfo, "autoRefillUnder" => $autorefill->autoRefillUnder, "autoRefillValue" => $autorefill->autoRefillValue, "autoRefillMin" => $this->productConfiguration->get("autoRefillMinimalAmount")->value, "autoRefillMax" => $this->productConfiguration->get("autoRefillMaximalAmount")->value, "autoRefillEnable" => $this->productConfiguration->get("autoRefillEnable")->value );
		\MGModule\AdvancedBilling\mgLibs\Smarty::I()->setTemplateDir(__DIR__);
		return \MGModule\AdvancedBilling\mgLibs\Smarty::I()->view("templates/clientarea", $vars);
	}
	public function AdminAreaHeadOutput($params) 
	{
		return "\n        <script type=\"script/javascript\">\n            jQuery(document).ready(function(){\n                jQuery(\".mg-wrapper\").hide();\n            });\n        </script>\n        ";
	}
	public function activate() 
	{
		$remainders = models\Remainders::factory();
		$remainders->installInDatabase();
		$autosuspend = models\Autosuspend::factory();
		$autosuspend->installInDatabase();
		$userCredits = models\UsersCredits::factory();
		$userCredits->installInDatabase();
		$autoRefill = models\AutoRefill::factory();
		$autoRefill->installInDatabase();
		$emailTemplate = \MGModule\AdvancedBilling\classes\Database::getInstance()->getRow("SELECT id FROM tblemailtemplates WHERE name = ?", array( "Credit Warning" ));
		if( !$emailTemplate ) 
		{
			\MGModule\AdvancedBilling\classes\Database::getInstance()->query("INSERT INTO tblemailtemplates (type, name, subject, message) VALUES (?, ?, ?, ?)", array( "general", "Credit Warning", "Credit Warning", "Hello {\$client_name}\n                     <br />\n                     <br /> \n                     Your credit balance has gone below {\$minimal_credit}. \n                     <br />\n                     Please add some credits or your account will be suspended." ));
		}
	}
	public function deactivate() 
	{
	}
	public function checkLicense() 
	{
return array('status' => 'Active', 'description' => 'Crack by 03SEC');
	}
}
?>