<?php  namespace MGModule\AdvancedBilling\extensions\Graphs;
class Graphs extends \MGModule\AdvancedBilling\core\extension\Extension 
{
	public $type = self::TYPE_OTHER;
	public $name = "Graphs";
	public $friendlyName = "Graphs";
	public $description = "Extension used to create resource usage graphs for services";
	public $version = "1.0.1";
	public $customPages = array( "graphs" => array( "title" => "Graphs", "icon" => "glyphicon glyphicon-stats" ) );
	public function __construct() 
	{
		parent::__construct();
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("enable", "enable", "Enable", "Check this option if you want to enable Graph Extension for this product", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("extension", "extension", "", "", $this->name);
		$obj->addStyle("additionalClass", "hidden");
		$this->extensionConfiguration->add($obj);
		$license = new \MGModule\AdvancedBilling\core\form\fields\Text("license", "license", "License Key");
		$license->addStyle("colWidth", 9)->addStyle("custom", "width: 100%");
		$this->extensionConfiguration->add($license);
	}
	public function checkLicense() 
	{
		$key = $this->extensionConfiguration->get("license")->value;
		$file = ROOTDIR . DIRECTORY_SEPARATOR . "modules" . DIRECTORY_SEPARATOR . "addons" . DIRECTORY_SEPARATOR . "AdvancedBilling" . DIRECTORY_SEPARATOR . "license.php";
		if( !$key && file_exists($file) ) 
		{
			include($file);
			$this->extensionConfiguration->set("license", $advanced_billing_licensekey);
			$this->extensionConfiguration->save();
			$key = $advanced_billing_licensekey;
		}
	}
	public function integrationCodeShow($hostingId, $productId) 
	{
		$this->loadProductConfiguration($productId);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return false;
		}
		if( strpos($_SERVER["SCRIPT_NAME"], "clientarea.php") !== false && $_REQUEST["action"] == "productdetails" ) 
		{
			$controller = new controllers\ClientArea();
			return $controller->indexHTML();
		}
	}
	protected function activate() 
	{
	}
	protected function deactivate() 
	{
	}
}
?>