<?php
//加密方式:ioncube 
//此程序由【PHP解密】http://www.phpjiemi.com/ (VIP会员功能）在线逆向还原，QQ：2436152386
//会员:sky@03sec.com 您好,破解:ioncube加密,本次扣金币:1个,金币余额:4个,感谢您的支持. 
?>
<?php  namespace MGModule\AdvancedBilling\extensions\RecurringBilling;
class RecurringBilling extends \MGModule\AdvancedBilling\core\extension\Extension implements \MGModule\AdvancedBilling\core\events\WHMCSBasedEvents 
{
	public $type = self::TYPE_BASE;
	public $name = "RecurringBilling";
	public $friendlyName = "Recurring Billing";
	public $description = "Extension used to bill clients at specified time intervals";
	public $version = "1.0.1";
	const BILL_ON_INVOICE_GENERATE = 1;
	const BILL_ON_SPECIFIC_DAY = 2;
	const BILL_EVERY_X_DAYS = 3;
	public function __construct() 
	{
		parent::__construct();
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("enable", "enable", "Enable", "Check this option if you want to enable recurring billing extension for this product", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("bill_on_terminate", "bill_on_terminate", "Bill on terminate", "Bill your client after account is terminated", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$invoicemin = new \MGModule\AdvancedBilling\core\form\fields\Text("invoiceminamount", "invoiceminamount", "Minimum Billing Amount", "The Minimum Amount, that should be billed in the new Invoice creation");
		$invoicemin->addStyle("colWidth", 9)->addStyle("additionalClass", "form-inline");
		$billTypeValue = new \MGModule\AdvancedBilling\core\form\fields\Text("billing_type_value", "billing_type_value", "Billing Type Value", "");
		$billTypeValue->addStyle("colWidth", 9)->addStyle("rowStyle", "display: none;")->addStyle("additionalClass", "form-inline");
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Select2("billing_type", "billing_type", "Billing Type", "", 0, 0, array( self::BILL_ON_INVOICE_GENERATE => "Bill On Invoice Generate", self::BILL_ON_SPECIFIC_DAY => "Bill On Specific Day", self::BILL_EVERY_X_DAYS => "Bill Every X Days" ));
		$obj->addStyle("colWidth", 9);
		$obj->setAction(self::BILL_ON_INVOICE_GENERATE, "change", $invoicemin, "hide");
		$obj->setAction(self::BILL_ON_SPECIFIC_DAY, "change", $invoicemin, "show");
		$obj->setAction(self::BILL_EVERY_X_DAYS, "change", $invoicemin, "show");
		$obj->setAction(self::BILL_ON_INVOICE_GENERATE, "change", $billTypeValue, "hide");
		$obj->setAction(self::BILL_ON_SPECIFIC_DAY, "change", $billTypeValue, "show");
		$obj->setAction(self::BILL_EVERY_X_DAYS, "change", $billTypeValue, "show");
		$this->productConfiguration->add($obj);
		$this->productConfiguration->add($billTypeValue);
		$this->productConfiguration->add($invoicemin);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("dueDate", "dueDate", "Due Date", "Days");
		$obj->addStyle("colWidth", 9)->addStyle("additionalClass", "form-inline");
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("autogenerate_invoice", "autogenerate_invoice", "Autogenerate Invoice", "When this is enabled invoices will be generated automatically", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("autoapplycredit", "autoapplycredit", "Auto Apply Credits", "Auto apply any available credit from clients credit balance", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("showbillinginfo", "showbillinginfo", "Advanced Billing Info", "Show Billing Cycle Information from Advanced Billing Module", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Switcher("applygroupdiscount", "applygroupdiscount", "Apply Group Discount", "Apply the discount to Invoice, that is set in the Client Group", false);
		$obj->addStyle("colWidth", 9);
		$this->productConfiguration->add($obj);
		$obj = new \MGModule\AdvancedBilling\core\form\fields\Text("extension", "extension", "", "", $this->name);
		$obj->addStyle("additionalClass", "hidden");
		$this->extensionConfiguration->add($obj);
		$license = new \MGModule\AdvancedBilling\core\form\fields\Text("license", "license", "License Key");
		$license->addStyle("colWidth", 9)->addStyle("custom", "width: 100%");
		$this->extensionConfiguration->add($license);
	}
	public function setValidation($settings) 
	{
		if( empty($settings["enable"]) ) 
		{
			return NULL;
		}
		$obj =& $this->productConfiguration->get("dueDate");
		$obj->validation = "int|required";
		if( $settings["billing_type"] == self::BILL_ON_SPECIFIC_DAY || $settings["billing_type"] == self::BILL_EVERY_X_DAYS ) 
		{
			$billTypeValue =& $this->productConfiguration->get("billing_type_value");
			$billTypeValue->validation = "int";
			if( !empty($settings["invoiceminamount"]) || $settings["invoiceminamount"] != 0 ) 
			{
				$invoicemin =& $this->productConfiguration->get("invoiceminamount");
				$invoicemin->validation = "int";
			}
		}
	}
	public function setProductConfiguration($fieldName, $fieldValue) 
	{
		$prepared = $this->prepareValue($fieldName, $fieldValue);
		if( !empty($prepared) ) 
		{
			extract($prepared, EXTR_OVERWRITE);
		}
		parent::setProductConfiguration($fieldName, $fieldValue);
	}
	public function prepareValue($fieldName, $fieldValue) 
	{
		$methods = get_class_methods($this);
		$parsedName = preg_replace("/_/", "", $fieldName);
		$methodFromFieldName = "setfield" . $parsedName;
		foreach( $methods as $method ) 
		{
			if( strpos($method, "setField") === false ) 
			{
				continue;
			}
			$parsedMethod = strtolower($method);
			if( $methodFromFieldName == $parsedMethod ) 
			{
				return $this->$method($fieldName, $fieldValue);
			}
		}
	}
	protected function setFieldInvoiceMinAmount($fieldName, $fieldValue) 
	{
		$newValue = (double) preg_replace("/,/", ".", $fieldValue);
		return array( "fieldName" => $fieldName, "fieldValue" => $newValue );
	}
	protected function applyGroupDiscount(MGModule\AdvancedBilling\classes\Invoice $invoice) 
	{
		if( $this->productConfiguration->get("applygroupdiscount")->value ) 
		{
			$invoice->enableDiscount();
		}
	}
	public function cronLoop($productId) 
	{
		$this->loadProductConfiguration($productId);
		if( !$this->productConfiguration->get("enable")->value ) 
		{
			return NULL;
		}
		if( $this->getCustomData("cronLoop_" . $productId) && date("Y-m-d") == date("Y-m-d", $this->getCustomData("cronLoop_" . $productId)) ) 
		{
			return NULL;
		}
		\MGModule\AdvancedBilling\classes\Logger::info("Generating invoices for product #" . $productId . "...");
		$hostings = \MGModule\AdvancedBilling\models\AdvancedBilling\Hosting::factory()->select(array( "id" => null ))->where("packageid", "=", $productId)->fetchAll();
		foreach( $hostings as $hosting ) 
		{
			$acc = new \MGModule\AdvancedBilling\classes\Account($hosting->id);
			if( $acc->hasRecords() ) 
			{
				$accounts[] = $acc;
			}
		}
		switch( $this->productConfiguration->get("billing_type")->value ) 
		{
			case self::BILL_EVERY_X_DAYS: $this->billAccountsEveryXDay($this->productConfiguration, $accounts, $productId);
			break;
			case self::BILL_ON_SPECIFIC_DAY: $this->billAccountsOnSpecificDay($this->productConfiguration, $accounts, $productId);
			break;
		}
		$this->setCustomData("cronLoop_" . $productId, time());
	}
	public function billAccountsEveryXDay($productConfiguration, $accounts, $productId) 
	{
		$interval = $productConfiguration->get("billing_type_value")->value;
		$dueDate = $productConfiguration->get("dueDate")->value;
		$autoApplyCredit = $productConfiguration->get("autoapplycredit")->value;
		$autoGenerateInvoice = $productConfiguration->get("autogenerate_invoice")->value;
		$startDate = date("Y-m-d", strtotime("-" . $interval . " days"));
		foreach( $accounts as $acc ) 
		{
			$lastInvoiceCreated = $this->getCustomData("lastInvoiceCreatedFor_" . $acc->hosting->id);
			if( $startDate < $lastInvoiceCreated || empty($lastInvoiceCreated) && $startDate < $acc->hosting->regdate ) 
			{
				continue;
			}
			$oldest = $acc->getOldestItem();
			$lastInvoiceDate = date("Y-m-d", strtotime($oldest->time));
			$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
			$this->applyGroupDiscount($invoice);
			if( $productConfiguration->get("billing_type")->value != 0 && 0 < $productConfiguration->get("invoiceminamount")->value ) 
			{
				$invoice->setBilledAmount($productConfiguration->get("invoiceminamount")->value);
			}
			$invoiceId = $invoice->generateInvoice($productId, $acc->hosting->id, true, $autoGenerateInvoice, $dueDate, $autoApplyCredit, $lastInvoiceDate, date("Y-m-d"));
			if( !empty($invoiceId) ) 
			{
				$acc->deleteAllItems();
				$this->setCustomData("lastInvoiceCreatedFor_" . $acc->hosting->id, date("Y-m-d"));
			}
		}
	}
	public function billAccountsOnSpecificDay($productConfiguration, $accounts, $productId) 
	{
		$billingDay = $productConfiguration->get("billing_type_value")->value;
		$dueDate = $productConfiguration->get("dueDate")->value;
		$autoApplyCredit = $productConfiguration->get("autoapplycredit")->value;
		$autoGenerateInvoice = $productConfiguration->get("autogenerate_invoice")->value;
		$currentDay = date("d");
		$daysCount = date("t");
		if( $daysCount < $billingDay ) 
		{
			\MGModule\AdvancedBilling\classes\Logger::info("Value " . $billingDay . " is greater than days count in current month. Running billing for last day in month");
			$billingDay = $daysCount;
		}
		if( $currentDay != $billingDay ) 
		{
			return false;
		}
		foreach( $accounts as $account ) 
		{
			$oldest = $account->getOldestItem();
			$lastInvoiceDate = date("Y-m-d", strtotime($oldest->time));
			$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
			$this->applyGroupDiscount($invoice);
			if( $productConfiguration->get("billing_type")->value != 0 && 0 < $productConfiguration->get("invoiceminamount")->value ) 
			{
				$invoice->setBilledAmount($productConfiguration->get("invoiceminamount")->value);
			}
			$invoiceId = $invoice->generateInvoice($productId, $account->hosting->id, true, $autoGenerateInvoice, $dueDate, $autoApplyCredit, $lastInvoiceDate, date("Y-m-d"));
			unset($invoice);
			if( !empty($invoiceId) ) 
			{
				$account->deleteAllItems();
				$this->setCustomData("lastInvoiceCreatedFor_" . $account->hosting->id, date("Y-m-d"));
			}
		}
	}
	public function AfterModuleTerminate($params) 
	{
		$hostingId = $params["params"]["accountid"];
		$productId = $params["params"]["pid"];
		$product = \MGModule\AdvancedBilling\models\AdvancedBilling\ProductConfiguration::factory();
		$product->where("productId", "=", $productId)->fetchOne();
		if( $product->enabled != "1" ) 
		{
			return NULL;
		}
		$this->loadProductConfiguration($productId);
		if( $this->productConfiguration->get("enable")->value != "on" || $this->productConfiguration->get("bill_on_terminate")->value != "on" ) 
		{
			return NULL;
		}
		$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
		if( !$account->hasRecords() ) 
		{
			return NULL;
		}
		$autoGenerateInvoice = $this->productConfiguration->get("autogenerate_invoice")->value;
		$autoApplyCredit = $this->productConfiguration->get("autoapplycredit")->value;
		$dueDate = $this->productConfiguration->get("dueDate")->value;
		$oldest = $account->getOldestItem();
		$lastInvoiceDate = date("Y-m-d", strtotime($oldest->time));
		$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
		$this->applyGroupDiscount($invoice);
		$invoiceId = $invoice->generateInvoice($productId, $hostingId, true, $autoGenerateInvoice, $dueDate, $autoApplyCredit, $lastInvoiceDate, date("Y-m-d"));
		unset($invoice);
		if( $invoiceId !== false ) 
		{
			$account->deleteAllItems();
		}
	}
	public function InvoiceCreation($params) 
	{
		$invoiceId = $params["invoiceid"];
		$items = \MGModule\AdvancedBilling\classes\Database::getInstance()->getAll("SELECT i.relid, h.packageid\n                                FROM tblinvoiceitems i\n                                LEFT JOIN tblhosting h ON i.relid = h.id\n                                WHERE i.invoiceid = ? AND i.type = 'Hosting'", array( $invoiceId ));
		foreach( $items as $item ) 
		{
			$hostingId = $item->relid;
			$productId = $item->packageid;
			$this->loadProductConfiguration($productId);
			if( $this->productConfiguration->get("enable")->value != "on" || $this->productConfiguration->get("billing_type")->value != self::BILL_ON_INVOICE_GENERATE ) 
			{
				continue;
			}
			$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
			if( !$account->hasRecords() ) 
			{
				continue;
			}
			$invoice = new \MGModule\AdvancedBilling\classes\Invoice($hostingId);
			$this->applyGroupDiscount($invoice);
			$result = $invoice->updateInvoice($hostingId, $productId, $invoiceId, true);
			if( $result !== false ) 
			{
				$account->deleteAllItems($productId);
				$this->setCustomData("lastInvoiceCreatedFor_" . $account->hosting->id, date("Y-m-d"));
			}
		}
	}
	public function DailyCronJob() 
	{
		global $whmcs;
		global $CONFIG;
		if( $CONFIG["AutoSuspension"] != "on" ) 
		{
			return NULL;
		}
		$invoiceRepo = new \MGModule\AdvancedBilling\models\AdvancedBilling\Invoices();
		$invoices = $invoiceRepo->getOverDueByXDays($CONFIG["AutoSuspensionDays"]);
		foreach( $invoices as $invoice ) 
		{
			$itemsRepo = new \MGModule\AdvancedBilling\models\AdvancedBilling\InvoiceItems();
			$items = $itemsRepo->getABItemsByInvoiceId($invoice->id);
			foreach( $items as $item ) 
			{
				$hosting = \MGModule\AdvancedBilling\models\AdvancedBilling\Hosting::factory($item->relid);
				if( $hosting->domainstatus == \MGModule\AdvancedBilling\models\AdvancedBilling\Hosting::STATUS_SUSPENDED ) 
				{
					continue;
				}
				$config = array( "accountid" => $item->relid, "suspendreason" => $whmcs->get_lang("suspendreasonoverdue") );
				$result = \MGModule\AdvancedBilling\Addon::localAPICall("ModuleSuspend", $config);
				if( $result["result"] == "success" ) 
				{
					\MGModule\AdvancedBilling\classes\Logger::info("Hosting #" . $item->relid . " has been suspended. Reason: Payment over due");
				}
				else 
				{
					\MGModule\AdvancedBilling\classes\Logger::error("Unable to suspend hosting #" . $item->relid);
				}
			}
		}
	}
	public function billOnDemand($hostingId) 
	{
		if( !$hostingId ) 
		{
			\MGModule\AdvancedBilling\classes\Logger::error("Empty hostingId provided!");
			return false;
		}
		$account = new \MGModule\AdvancedBilling\classes\Account($hostingId);
		$this->loadProductConfiguration($account->product->id);
		$dueDate = $this->productConfiguration->get("dueDate")->value;
		$autoGenerateInvoice = $this->productConfiguration->get("autogenerate_invoice")->value;
		$autoApplyCredit = $this->productConfiguration->get("autoapplycredit")->value;
		$oldest = $account->getOldestItem();
		$lastInvoiceDate = date("Y-m-d", strtotime($oldest->time));
		$invoice = new \MGModule\AdvancedBilling\classes\Invoice();
		$this->applyGroupDiscount($invoice);
		$invoiceId = $invoice->generateInvoice($account->product->id, $hostingId, true, $autoGenerateInvoice, $dueDate, $autoApplyCredit, $lastInvoiceDate, date("Y-m-d"));
		if( $invoiceId !== false ) 
		{
			$account->deleteAllItems($account->product->id);
			$this->setCustomData("lastInvoiceCreatedFor_" . $a->hosting->id, date("Y-m-d"));
		}
		return $invoiceId;
	}
	public function checkLicense() 
	{
		return array('status' => 'Active', 'description' => 'Crack by 03SEC');
	}
	protected function activate() 
	{
	}
	protected function deactivate() 
	{
	}
}
?>