{**********************************************************************
* ProxmoxVPS product developed. (2015-07-22)
* *
*
*  CREATED BY MODULESGARDEN       ->       http://modulesgarden.com
*  CONTACT                        ->       contact@modulesgarden.com
*
*
* This software is furnished under a license and may be used and copied
* only  in  accordance  with  the  terms  of such  license and with the
* inclusion of the above copyright notice.  This software  or any other
* copies thereof may not be provided or otherwise made available to any
* other person.  No title to and  ownership of the  software is  hereby
* transferred.
*
*
**********************************************************************}

{**
* @author Paweł Kopeć <pawelk@modulesgarden.com>
* @params $_LANG, $prod_permissions, $mainURL
*}

<div id="mg-error-container">
    {if $errors}
        <div class="alert alert-danger" role="alert">
            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                {foreach from=$errors item=error}
                <p>{$error}</p>
            {/foreach}
        </div>
    {elseif $infos}
        <div class="alert alert-success">
            <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                {foreach from=$infos item=info}
                <p>{$info}</p>
            {/foreach}
        </div>
    {/if}
</div>

<div class="module-header">
       <i class="icon-header icon-vps-details"></i>
        <h1 style="text-align: left">{$MGLANG->T('details')}</h1>
        <p style="text-align: left">{$_LANG.home.description}</p>
</div>
<div class="module-body">
    <div class="section">

        <table class="table pm-stats" style="width:100%;">
            {if $prod_permissions.so_vstatus}
                <tr>
                    <td style="width:25%;">{$_LANG.vps.status}</td>
                    <td>
                        <span id="solus_status" style="text-transform: capitalize;">
                            {if $infoall.state == "online"}
                                <strong class="green">{$infoall.state}</strong>
                            {else}
                                <strong class="red">{$infoall.state}</strong>
                            {/if}
                        </span>
                        <span id="pm-vps-details-loader" style="display: none;"><i class="loader-small"></i></span>
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.so_virtualizationtype}
                <tr>
                    <td>{$_LANG.vps.type}</td>
                    <td>{$infoall.type}</td>
                </tr>
            {/if}
            {if $stats_templat}
            <tr>
                <td>{$_LANG.vps.template}</td>
                <td>{$stats_template}</td>
            </tr>
            {/if}
            {if $prod_permissions.so_nodename}
                <tr>
                    <td>{$_LANG.vps.nodename}</td>
                    <td>{$infoall.node}</td>
                </tr>
            {/if}
            {if $prod_permissions.so_hostname}
                <tr>
                    <td>{$_LANG.vps.hostname}</td>
                    <td>
                        <span id="solus-hostname">{$info.hostname}</span>
                        <a href="#" class="btn btn-icon" data-toggle="modal" data-target="#solus-modal-hostname"  title="{$_LANG.vps.change_host_btn}" >
                                <i class="fa fa-pencil"></i>
                        </a>
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.so_iplist}
                <tr>
                    <td>{$_LANG.vps.main_ip}</td>
                    <td>{$infoall.mainipaddress}</td>
                </tr>
                <tr>
                    <td>{$_LANG.vps.ip_addresses}</td>
                    <td>
                        {$assignedIP}{if $infoall.ipaddresses}<span style="display: none;">, {$infoall.ipaddresses}</span>
                            <a title="{$MGLANG->T('Show more')}"  id="so-ip-addresses-show" class="btn btn-icon" href="#">
                                    <i class="fa fa-arrow-circle-o-down"></i>
                            </a>
                            <a title="{$MGLANG->T('Hide')}" style="display: none;" id="so-ip-addresses-hide" class="btn btn-icon" href="#">
                                    <i class="fa fa-arrow-circle-o-up"></i>
                            </a>
                        {/if}
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.so_rootpassword}
                <tr>
                    <td>{$_LANG.vps.root_password}</td>
                    <td>
                        
                        {if $root_pass}
                            <input type="password"  id="so-root-pass" value="{$root_pass}" />
 
                            <a href="#" class="btn btn-icon" id="so-show-root-pass" data-target="#so-root-pass" data-hide="{$MGLANG->T("Hide")}" data-show="{$_LANG.vps.root_pass_show}"   title="{$_LANG.vps.root_pass_show}" >
                                <i class="fa fa-info-circle"></i>
                            </a>
                       
                        {/if}
                        
                        {if $prod_permissions.so_rootpassword_change}
                            <a href="#" class="btn btn-icon" data-toggle="modal" {if $type=="kvm" || $type=="xen hvm"} data-target="#solus-modal-passwordkvm" {else} data-target="#solus-modal-password"  {/if}   title="{$_LANG.vps.root_change_password}" style="margin-left: -2px;">
                                <i class="fa fa-pencil"></i>
                            </a>
                        {/if}
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.so_bootorder && ( $type=="kvm" || $type=="xen hvm")}
                <tr>
                    <td>{$_LANG.vps.boot_order}</td>
                    <td>
                        
                        <a href="#" class="btn btn-icon" data-toggle="modal" data-target="#solus-modal-boot"  title="{$_LANG.vps.btn_boot_order}" >
                                <i class="fa fa-pencil"></i>
                        </a>
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.so_mountiso && ( $type=="kvm" || $type=="xen hvm") }
                <tr>
                    <td>{$MGLANG->T('ISO')}</td>
                    <td>
                        <a href="#" class="btn btn-icon" data-toggle="modal" data-target="#solus-modal-iso"  title="{$MGLANG->T('ISO Options')}" >
                                <i class="fa fa-pencil"></i>
                        </a>
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.rescueMode && ( $type=="kvm") }
                <tr>
                    <td>{$MGLANG->T('Rescue Mode')}</td>
                    <td>
                        <span style="color:red; {if !$infoall.rescuemode} display: none;{/if}" id="soRescueModeStatusEnable">{$MGLANG->T('On')}</span> <span style="color:green;  {if $infoall.rescuemode} display: none;{/if}" id="soRescueModeStatusDisable">{$MGLANG->T('Off')}</span> 
                        <a href="#" class="btn btn-icon" data-toggle="modal" data-target="#solus-modal-rescueMode"  title="{$MGLANG->T('Edit')}" >
                                <i class="fa fa-pencil"></i>
                        </a>
                    </td>
                </tr>
            {/if}
            {if $prod_permissions.so_bwusage}
                <tr>
                    <td>{$_LANG.vps.bandwidth}</td>
                    <td> 
                        {$bandwidth.used} {$_LANG.general.graph_of} <strong>{$bandwidth.max}</strong> {$_LANG.general.graph_used} / {$bandwidth.free} {$_LANG.general.graph_free}
                        <div class="progress pm-resource-usege">
                            <div class="progress-bar {if $bandwidth.percent >=90}progress-bar-danger{elseif $bandwidth.percent <=90 && $bandwidth.percent >=70}progress-bar-warning{elseif $bandwidth.percent <=70}progress-bar-success{/if}" 
                                 role="progressbar" aria-valuenow="{$bandwidth.percent}" aria-valuemin="1" aria-valuemax="100" style="width: {$bandwidth.percent}%;">
                                {$bandwidth.percent}%
                            </div>
                        </div>
                    </td>
                </tr>
            {/if}
            {if $type=="kvm" || $type=="xen hvm"}
                {if $prod_permissions.so_memusage}
                    <tr>
                        <td>{$_LANG.vps.memory}</td>
                        <td>
                            <div> <strong>{$info.memory|solusvmExtendedVPS_formatBytes} </strong> </div>
                        </td>
                    </tr>
                {/if}
                {if $prod_permissions.so_diskusage}
                    <tr>
                        <td>{$_LANG.vps.hdd}</td>
                        <td>
                            <div> <strong>{$info.hdd|solusvmExtendedVPS_formatBytes} </strong> </div>
                        </td>
                    </tr>
                {/if} 
            {else} 
                {if $prod_permissions.so_memusage}
                    <tr>
                        <td>{$_LANG.vps.memory}</td>
                        <td>
                            {if $isMemoryStat}
                                {$memory.used} {$_LANG.general.graph_of} <strong>{$memory.max}</strong> {$_LANG.general.graph_used} / {$memory.free} {$_LANG.general.graph_free}
                                <div class="progress pm-resource-usege">
                                    <div class="progress-bar {if $memory.percent >=90}progress-bar-danger{elseif $memory.percent <=90 && $memory.percent >=70}progress-bar-warning{elseif $memory.percent <=70}progress-bar-success{/if}" 
                                         role="progressbar" aria-valuenow="{$memory.percent}" aria-valuemin="1" aria-valuemax="100" style="width: {$memory.percent}%;">
                                        {$memory.percent}%
                                    </div>
                                </div>
                            {else}
                                <div> <strong>{$info.memory|solusvmExtendedVPS_formatBytes} </strong> </div>
                            {/if}
                        </td>
                    </tr>
                {/if}
                {if $prod_permissions.so_diskusage}
                    <tr>
                        <td>{$_LANG.vps.hdd}</td>
                        <td>
                            {$hdd.used} {$_LANG.general.graph_of} <strong>{$hdd.max}</strong> {$_LANG.general.graph_used} / {$hdd.free} {$_LANG.general.graph_free}
                            <div class="progress pm-resource-usege">
                                <div class="progress-bar {if $hdd.percent >=90}progress-bar-danger{elseif $hdd.percent <=90 && $hdd.percent >=70}progress-bar-warning{elseif $hdd.percent <=70}progress-bar-success{/if}" 
                                     role="progressbar" aria-valuenow="{$hdd.percent}" aria-valuemin="1" aria-valuemax="100" style="width: {$hdd.percent}%;">
                                    {$hdd.percent}%
                                </div>
                            </div>

                        </td>
                    </tr>
                {/if}
            {/if}
        </table>
        {if $displayButtons }
            <div class="well buttons-content">
                <h4 class="text-center mb-20">{$MGLANG->T('Control Panel')}</h4>
            <div class="row">
                {if $prod_permissions.so_boot}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button solus-vm-action" href="#" data-subaction="bootVM">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-boot"></i>
                                <span>{$_LANG.vps.boot}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $prod_permissions.so_reboot}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button solus-vm-action" href="#" data-subaction="rebootVM">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-reboot"></i>
                                <span>{$_LANG.vps.reboot}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $prod_permissions.so_shutdown}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button solus-vm-action" href="#" id="btn_stop" data-subaction="shutdownVM">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-shutdown"></i>
                                <span> {$_LANG.vps.shutdown}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $prod_permissions.so_console}
                    <div class="col-lg-4 col-xs-6" >
                        <a class="big-button" href="#" onclick="window.open('{$homeURL}&mg-action=vnc', '', 'width=900,height=700'); return false;">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-vnc"></i>
                                <span>{$_LANG.vps.console}</span>
                            </div>
                        </a>
                    </div>
                {/if} 
                {if $prod_permissions.so_novnc &&( $type=="kvm" || $type=="xen hvm")}
                    <div class="col-lg-4 col-xs-6" >
                        <a class="big-button" href="#" onclick="window.open('{$homeURL}&mg-action=novnc', '', 'width=900,height=700');        return false;">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-novnc"></i>
                                <span>{$_LANG.vps.consolenovnc}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $prod_permissions.so_serialConsole &&( $type=="openvz" || $type=="xen")}
                    <div class="col-lg-4 col-xs-6" >
                        <a class="big-button" href="#" onclick="window.open('{$homeURL}&mg-action=serialConsole', '', 'width=820,height=555');        return false;">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-html"></i>
                                <span>{$MGLANG->absoluteT('HTML 5 Serial Console')}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $prod_permissions.so_tuntap && ( $type=="openvz")}
              
                   <div class="col-lg-4 col-xs-6 btn-group" role="group" >
                        <a class="big-button big-button-dropdown-toggle" href="#" aria-expanded="true" aria-haspopup="true"  id="solus-button-group-tun">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-tun-tap-on"></i>
                                <span> {$MGLANG->absoluteT('TUN/TAP')}</span>
                                <span class="caret"></span>
                            </div>
                        </a>
                        <ul aria-labelledby="solus-button-group-tun" class="dropdown-menu" style="margin-top: -15px; margin-left:15px;  width: 88%;">
                              <li><a href="#" class="solus-vm-action solus-btn-group" data-subaction="tuntapOnVM">{$MGLANG->absoluteT('ON')}</a></li>
                              <li><a href="#" class="solus-vm-action solus-btn-group"   data-subaction="tuntapOffVM">{$MGLANG->absoluteT('OFF')}</a></li>
                        </ul>
                    </div>
                {/if}
                {if $prod_permissions.so_pae && ( $type=="kvm" || $type=="xen hvm")}
                   <div class="col-lg-4 col-xs-6 btn-group" role="group" >
                        <a class="big-button big-button-dropdown-toggle" href="#" aria-expanded="true" aria-haspopup="true"  id="solus-button-group-pae">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-pae-on"></i>
                                <span> {$MGLANG->absoluteT('PAE')}</span>
                                <span class="caret"></span>
                            </div>
                        </a>
                        <ul aria-labelledby="solus-button-group-pae" class="dropdown-menu" style="margin-top: -15px; margin-left:15px;  width: 88%;">
                              <li><a href="#" class="solus-vm-action solus-btn-group" data-subaction="paeOnVM">{$MGLANG->absoluteT('ON')}</a></li>
                              <li><a href="#" class="solus-vm-action solus-btn-group"   data-subaction="paeOffVM">{$MGLANG->absoluteT('OFF')}</a></li>
                        </ul>
                    </div>
                {/if}
                {if $prod_permissions.so_pxe}
              
                   <div class="col-lg-4 col-xs-6 btn-group" role="group" >
                        <a class="big-button big-button-dropdown-toggle" href="#" aria-expanded="true" aria-haspopup="true"  id="solus-button-group-tun">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-pxe"></i>
                                <span> {$MGLANG->absoluteT('PXE')}</span>
                                <span class="caret"></span>
                            </div>
                        </a>
                        <ul aria-labelledby="solus-button-group-tun" class="dropdown-menu" style="margin-top: -15px; margin-left:15px;  width: 88%;">
                              <li><a href="#" class="solus-vm-action solus-btn-group" data-subaction="enablePxe">{$MGLANG->absoluteT('ON')}</a></li>
                              <li><a href="#" class="solus-vm-action solus-btn-group"   data-subaction="disablePxe">{$MGLANG->absoluteT('OFF')}</a></li>
                        </ul>
                    </div>
                {/if}
            </div>
        </div>


        <div class="well buttons-content">
            <h4 class="text-center mb-20">{$MGLANG->T('Additional Tools')}</h4>
            <div class="row">
                {if $prod_permissions.so_controlpanelbutton}
                    {if $prod_permissions.so_clientkeylogin}
                        <div class="col-lg-4 col-xs-6"  onclick="window.open('{$homeURL}&mg-action=controlPanel')" >
                            <a class="big-button" href="#">
                                <div class="button-wrapper">
                                    <i class="icon-btn icon-control-panel"></i>
                                    <span>{$_LANG.vps.control_panel}</span>
                                </div>
                            </a>
                        </div>

                    {else}
                        <div class="col-lg-4 col-xs-6"  id="so_control_panel" >
                            <a class="big-button" href="#">
                                <div class="button-wrapper">
                                    <i class="icon-btn icon-control-panel"></i>
                                    <span>{$_LANG.vps.control_panel}</span>
                                </div>
                            </a>
                        </div>
                        <form action="{$login_server}/login.php" method="post" target="_blank">
                            <input type="hidden" name="username" value="{$login_username}" />
                            <input type="hidden" name="password" value="{$login_password}" />
                            <input type="hidden" name="Submit" value="Login" />
                        </form>
                    {/if}
                {/if}
                {if $prod_permissions.so_rebuild}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button" href="{$managementURL}&mg-page=rebuild">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-reinstall"></i>
                                <span>{$_LANG.vps.rebuild}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $prod_permissions.so_graphs}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button" href="{$managementURL}&mg-page=graph">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-graphs"></i>
                                <span>{$_LANG.vps.graphs}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $isDNSManagerEnabled && $isDNSManagerInstalled}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button" href="index.php?m=DNSManager2&serviceId={$serviceID}">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-subdomains"></i>
                                <span>{$_LANG.vps.dns_manager_manage}</span>
                            </div>
                        </a>
                    </div>
                {/if}
                {if $isDNSManagerEnabled && $isDNSManagerInstalled && $isDNSManagerRDNSenabled}
                    <div class="col-lg-4 col-xs-6">
                        <a class="big-button" href="index.php?m=DNSManager2&mg-action=manageRDNS&serviceId={$serviceID}">
                            <div class="button-wrapper">
                                <i class="icon-btn icon-managedns"></i> 
                                <span>{$_LANG.vps.dns_manager_reverse}</span>
                            </div>
                        </a>
                    </div>
                {/if}
            </div>
        </div>
    {/if}

</div>
</div>
<div class="modal fade" id="solus-modal-hostname" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-left">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                    <h4 class="modal-title">{$MGLANG->T('Change Hostname')}</h4>
                </div>
                <div class="modal-body"  style="min-height:100px;">
                    <div class="modal-alerts">
                        <div style="display:none;" data-prototype="error">
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                                <a style="display:none;" class="errorID" href=""></a>
                            </div>
                        </div>
                        <div style="display:none;" data-prototype="success">
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                            </div>
                        </div>
                    </div>
                    <form class="form-horizontal" style="min-height:75px; margin-top: 25px;">
                      <div class="form-group">
                        <label for="so-modal-hostname" class="col-sm-2 control-label">{$MGLANG->T('Hostname')}</label>
                        <div class="col-sm-9">
                          <input type="text" class="form-control" id="so-modal-hostname" value="">
                        </div>
                      </div>
                       <div class="modal-loader" style="display:none;"></div>
                    </form>


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="so-modal-hostname-save"   >{$MGLANG->T('Save')}</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('Close')}</button>
                </div>
            </div>
        </div>
</div>
 <div class="modal fade" id="solus-modal-password" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-left">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                    <h4 class="modal-title">{$MGLANG->T('Change Password')}</h4>
                </div>
                <div class="modal-body"  style="min-height:100px;">
                    <div class="modal-alerts">
                        <div style="display:none;" data-prototype="error">
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                                <a style="display:none;" class="errorID" href=""></a>
                            </div>
                        </div>
                        <div style="display:none;" data-prototype="success">
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                            </div>
                        </div>
                    </div>
                    <form class="form-horizontal" style="min-height:75px; margin-top: 25px;">
                      <div class="form-group">
                        <label for="so-modal-password" class="col-sm-3 control-label">{$MGLANG->T('New Password')}</label>
                        <div class="form-inline row">
                            <div class="col-sm-8">
                              <input type="text" class="form-control" id="so-modal-password" value="" style="width:80%">
                              <button class="btn" id="mg-generate-password" title="{$MGLANG->T('Generate Password')}"><i class="glyphicon glyphicon-repeat"></i></button>
                            </div>
                        </div>
                      </div>
                       <div class="modal-loader" style="display:none;"></div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="so-modal-password-save"   >{$MGLANG->T('Change')}</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('Close')}</button>
                </div>
            </div>
        </div>
</div>
                
<div class="modal fade" id="solus-modal-passwordkvm" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-left">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                    <h4 class="modal-title">{$MGLANG->T('Change Password')}</h4>
                </div>
                <div class="modal-body"  style="min-height:100px;">
                    <div class="modal-alerts">
                        <div style="display:none;" data-prototype="error">
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                                <a style="display:none;" class="errorID" href=""></a>
                            </div>
                        </div>
                        <div style="display:none;" data-prototype="success">
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                            </div>
                        </div>
                    </div>
                    
                        <div style="min-height:75px; margin-top: 25px;">
                            <div class="text-center"  >
                                <p>{$MGLANG->T('Are you sure you want to change password?')}</p>
                            </div>
                            <div class="modal-loader" style="display:none;"></div>
                         </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="so-modal-password-save-kvm"   >{$MGLANG->absoluteT('Yes')}</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->absoluteT('No')}</button>
                </div>
            </div>
        </div>
</div>
                
 <div class="modal fade" id="solus-modal-boot" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-left">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                    <h4 class="modal-title">{$MGLANG->T('Change Boot Order')}</h4>
                </div>
                <div class="modal-body"  style="min-height:100px;">
                    <div class="modal-alerts">
                        <div style="display:none;" data-prototype="error">
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                                <a style="display:none;" class="errorID" href=""></a>
                            </div>
                        </div>
                        <div style="display:none;" data-prototype="success">
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                            </div>
                        </div>
                    </div>
                    <form class="form-horizontal" style="min-height:75px; margin-top: 25px;">
                      <div class="form-group">
                        <label for="so-modal-bootOrder" class="col-sm-2 control-label">{$MGLANG->T('Boot Order')}</label>
                        <div class="col-sm-9">
                            <select name="so-modal-bootOrder" id="so-modal-bootOrder" class="form-control" >
                                <option value=""></option>
                                <option value="cd">{$_LANG.vps.boot_order_cd}</option>
                                <option value="dc">{$_LANG.vps.boot_order_dc}</option>
                                <option value="c">{$_LANG.vps.boot_order_c}</option>
                                <option value="d">{$_LANG.vps.boot_order_d}</option>
                            </select>
                        </div>
                      </div>
                       <div class="modal-loader" style="display:none;"></div>
                    </form>


                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary" id="so-modal-boot-save"   >{$MGLANG->T('Change')}</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('Close')}</button>
                </div>
            </div>
        </div>
</div>
                
 <div class="modal fade" id="solus-modal-iso" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-left">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                    <h4 class="modal-title">{$MGLANG->T('Change ISO')}</h4>
                </div>
                <div class="modal-body"  style="min-height:100px;">
                    <div class="modal-alerts">
                        <div style="display:none;" data-prototype="error">
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                                <a style="display:none;" class="errorID" href=""></a>
                            </div>
                        </div>
                        <div style="display:none;" data-prototype="success">
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                            </div>
                        </div>
                    </div>
                    <form class="form-horizontal" style="min-height:75px; margin-top: 25px;">
                      <div class="form-group">
                        <label for="so-modal-iso" class="col-sm-2 control-label">{$MGLANG->T('ISO')}</label>
                        <div class="col-sm-9">
                            <select name="so-modal-iso" id="so-modal-iso" class="form-control" >
                                {foreach from=$isos item=isoName key="iso"}
                                    <option value="{$iso}">{$isoName}</option>
                                {/foreach}
                            </select>
                        </div>
                      </div>
                       <div class="modal-loader" style="display:none;"></div>
                    </form>
                </div>
                <div class="modal-footer">
                    {if $prod_permissions.so_unmountiso &&( $type=="kvm" || $type=="xen hvm")}
                        <button type="submit" class="btn btn-warning" id="so-modal-iso-unmount"   >{$MGLANG->T('Unmount')}</button>
                    {/if}
                    <button type="submit" class="btn btn-primary" id="so-modal-iso-mount"   >{$MGLANG->T('Mount')}</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('Close')}</button>
                </div>
            </div>
        </div>
</div>
{if $rescueMode}
 <div class="modal fade" id="solus-modal-rescueMode" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header text-left">
                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                    <h4 class="modal-title">{$MGLANG->T('Rescue Mode')}</h4>
                </div>
                <div class="modal-body"  style="min-height:100px;">
                    <div class="modal-alerts">
                        <div style="display:none;" data-prototype="error">
                            <div class="alert alert-danger">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                                <a style="display:none;" class="errorID" href=""></a>
                            </div>
                        </div>
                        <div style="display:none;" data-prototype="success">
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">{$closeChar}</span><span class="sr-only"></span></button>
                                <strong></strong>
                            </div>
                        </div>
                    </div>
                    <form class="form-horizontal" style="min-height:75px; margin-top: 25px;">
                      <div class="form-group">
                        <label for="so-modal-iso" class="col-sm-2 control-label">{$MGLANG->T('Kernel')}</label>
                        <div class="col-sm-9">
                            <select name="rescueMode" id="so-rescueMode" class="form-control" >
                                {foreach from=$rescueMode item=item}
                                    <option value="{$item}">{$MGLANG->t('rescueMode',$item)}</option>
                                {/foreach}
                            </select>
                            <small  class="help-block text-left">{$MGLANG->t('Select a kernel from the list below. A small appliance will be created and attached to the virtual server that can be accessed over the network.')}</small>
                        </div>
                      </div>
                        <div  class="text-left"{if !$infoall.rescuemode}style="display:none"{/if} id="so-rescueMode-html">
                            {include file='rescueMode.tpl' rescue=$rescue}
                        </div>
                       <div class="modal-loader" style="display:none;"></div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-warning" id="so-modal-rescueMode-disable" {if !$infoall.rescuemode}disabled=""{/if}>{$MGLANG->T('Disable')}</button>
                    <button type="submit" class="btn btn-primary" id="so-modal-rescueMode-enable" {if $infoall.rescuemode}disabled=""{/if} >{$MGLANG->T('Enable')}</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$MGLANG->T('Close')}</button>
                </div>
            </div>
        </div>
</div>
{/if}
{literal}
    <style type="text/css">
        .green {font-weight:bold;color:green;}
        .red {font-weight:bold;color:red}

        .pm-stats td{ text-align: left;}
        .pm-resource-usege{
            clear:both; 
            width:40% !important;
            margin-bottom: 2px !important;
        }
        #so-rescueMode-html{
            margin-top: 2px ;
            margin-left: 50px !important;
            
        }
    </style>
    <script type="text/javascript">
        jQuery(document).ready(function () {
            var mgsolusRefreshLock = false;
            function solusvmDetailsVM() {
                if(mgsolusRefreshLock){
                    return;
                }
                mgsolusRefreshLock = true;
                JSONParser.request(
                        "detailsVM"
                        , {}
                , function (data) {
                    mgsolusRefreshLock = false;
                    if (data.state == "online")
                        jQuery("#solus_status").html('<span class="green">' + data.state+ '</span>');
                    else
                        jQuery("#solus_status").html('<span class="red">' + data.state + '</span>');

                },
                        "#pm-vps-details-loader");
            }
            setInterval(solusvmDetailsVM, 1000*60);  //60 seconds
            $("#so_control_panel").click(function(){
                $(this).next().submit();
                    return false;
            });
            //hostname
            $('#solus-modal-hostname').on('show.bs.modal', function (e) {
                $("#so-modal-hostname").val('').val($("#solus-hostname").text());
            });
            $("#so-modal-hostname-save").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "saveHostname"
                        , {
                            "hostname": $("#so-modal-hostname").val()
                        }
                , function (data) { //success
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    $('#solus-modal-hostname').modal("hide");
                    $("#solus-hostname").text($("#so-modal-hostname").val())
                },"#solus-modal-hostname .modal-loader");
            });
            //password
            $("#so-show-root-pass").click(function (e) {
                e.preventDefault();
                //Show
                if($("#so-root-pass").prop("type") == "password" ){
                    $("#so-root-pass").prop("type","text") 
                    $(this).attr("title",$(this).attr('data-hide') );
                }else{
                    $("#so-root-pass").prop("type","password");
                    $(this).attr("title",$(this).attr('data-show') );
                }
            });
            $('#solus-modal-password').on('show.bs.modal', function (e) {
                $("#so-modal-password").val('').val($("#so-root-pass").val());
            });
            $("#so-modal-password-save").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "savePassword"
                        , {
                            "newPassword":  $("#so-modal-password").val()
                        }
                , function (data) { //success
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    $('#solus-modal-password').modal("hide");
                    $("#so-root-pass").val($("#so-modal-password").val())
                },"#solus-modal-password .modal-loader");
            });
            $("#so-modal-password-save-kvm").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "savePassword"
                        , {
                            "newPassword":  $("#so-modal-password").val()
                        }
                , function (data) { //success
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    $('#solus-modal-passwordkvm').modal("hide");
                    if(data.rootpassword!="")
                        $("#so-root-pass").val(data.rootpassword);
                    else
                        $("#so-root-pass").val($("#so-modal-password").val())
                },"#solus-modal-passwordkvm .modal-loader");
            });
            
            //Boot order
            $("#so-modal-boot-save").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "changeBootOrder"
                        , {
                            "bootOrder":  $("#so-modal-bootOrder").val()
                        }
                , function (data) { //success
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    $('#solus-modal-boot').modal("hide");
                },"#solus-modal-boot .modal-loader");
            });
            
            //iso
            $("#so-modal-iso-mount").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "mountISO"
                        , {
                            "iso":  $("#so-modal-iso").val()
                        }
                , function (data) { //success
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    if(data.modalSuccess){
                        jQuery('.modal.in .modal-alerts').alerts('success',data.modalSuccess);
                        return;
                    }
                },"#solus-modal-iso .modal-loader");
            });
            
            $("#so-modal-iso-unmount").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "unmountISO"
                        , {
                            "iso":  $("#so-modal-iso").val()
                        }
                , function (data) { //success
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    if(data.modalSuccess){
                        jQuery('.modal.in .modal-alerts').alerts('success',data.modalSuccess);
                        return;
                    }
                },"#solus-modal-iso .modal-loader");
            });
           
            $("#so-ip-addresses-show").click(function(e){
                 e.preventDefault();
                 $(this).parent('td').find('span').show();
                 $(this).hide();
                 $("#so-ip-addresses-hide").show();
            });
            
            $("#so-ip-addresses-hide").click(function(e){
                e.preventDefault();
                $(this).parent('td').find('span').hide();
                $(this).hide();
                $("#so-ip-addresses-show").show();
            });
            
            $("#mg-generate-password").click(function(e){
                e.preventDefault();
                var chars = "ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
                var string_length = 8;
                var randomstring = '';
                var charCount = 0;
                var numCount = 0;

                for (var i=0; i<string_length; i++) {
                    // If random bit is 0, there are less than 3 digits already saved, and there are not already 5 characters saved, generate a numeric value. 
                    if((Math.floor(Math.random() * 2) == 0) && numCount < 3 || charCount >= 5) {
                        var rnum = Math.floor(Math.random() * 10);
                        randomstring += rnum;
                        numCount += 1;
                    } else {
                        // If any of the above criteria fail, go ahead and generate an alpha character from the chars string
                        var rnum = Math.floor(Math.random() * chars.length);
                        randomstring += chars.substring(rnum,rnum+1);
                        charCount += 1;
                    }
                }

                $("#so-modal-password").val(randomstring);
            });
            //Rescue Mode enable
            $("#so-modal-rescueMode-enable").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "rescueModeEnable"
                        , {
                            "rescueMode":  $("#so-rescueMode").val()
                        }
                , function (data) { 
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    $("#soRescueModeStatusEnable").show();
                    $("#soRescueModeStatusDisable").hide();
                    $("#so-modal-rescueMode-enable").prop("disabled",true);
                    $("#so-modal-rescueMode-disable").prop("disabled",false);
                    if(data.html){
                        $("#so-rescueMode-html").html(data.html).show();
                    }
                    if(data.modalSuccess){
                        jQuery('.modal.in .modal-alerts').alerts('success',data.modalSuccess);
                    }
                },"#solus-modal-rescueMode .modal-loader");
            });
            //off
             $("#so-modal-rescueMode-disable").click(function (e) {
                e.preventDefault();
                JSONParser.request(
                        "rescueModeDisable"
                        , {
                            "rescueMode":  $("#so-rescueMode").val()
                        }
                , function (data) { 
                    if(data.modalError){
                        jQuery('.modal.in .modal-alerts').alerts('error',data.modalError);
                        return;
                    }
                    $("#soRescueModeStatusEnable").hide();
                    $("#soRescueModeStatusDisable").show();
                    $("#so-modal-rescueMode-enable").prop("disabled",false);
                    $("#so-modal-rescueMode-disable").prop("disabled",true);
                    $("#so-rescueMode-html").html('').hide();
                    if(data.modalSuccess){
                        jQuery('.modal.in .modal-alerts').alerts('success',data.modalSuccess);
                    }
                },"#solus-modal-rescueMode .modal-loader");
            });

            $("#mg-wrapper .modal").on("hide.bs.modal", function (e) {
                 $(this).find('div[data-time]').remove();
            });
        });

    </script>
{/literal}