<?php
/**
 * Template Name: Login Designer
 *
 * Template to display the WordPress login form in the Customizer.
 * This is essentially a stripped down version of wp-login.php, though not accessible from outside the Customizer.
 *
 * @package   Login Designer
 * @author    Rich Tabor from ThatPluginCompany
 * @license   GPL-3.0
 */

// Redirect if viewed from outside the Customizer.
if ( ! is_customize_preview() ) {

	// Pull the Login Designer page from options.
	$page = get_permalink( Login_Designer()->get_login_designer_page() );

	// Generate the redirect url.
	$url = add_query_arg(
		array(
			'autofocus[section]' => 'login_designer__section--templates',
			'return'             => admin_url( 'index.php' ),
			'url'                => rawurlencode( $page ),
		),
		admin_url( 'customize.php' )
	);

	wp_safe_redirect( $url );
}

/**
 * Output the login page header.
 *
 * @param string   $title    Optional. WordPress login Page title to display in the `<title>` element.
 *                           Default 'Log In'.
 * @param string   $message  Optional. Message to display in header. Default empty.
 * @param WP_Error $wp_error Optional. The error to pass. Default empty.
 */
function logindesigner_login_header( $title = 'Log In', $message = '', $wp_error = '' ) {

	global $error, $action;

	// Don't index any of these forms.
	add_action( 'login_head', 'wp_no_robots' );

	if ( empty( $wp_error ) ) {
		$wp_error = new WP_Error();
	}

	$login_title = get_bloginfo( 'name', 'display' );

	/* translators: Login screen title. 1: Login screen name, 2: Network or site name */
	$login_title = sprintf( __( '%1$s &lsaquo; %2$s &#8212; WordPress' ), $title, $login_title );
	/**
	 * Filters the title tag content for login page.
	 *
	 * @since 4.9.0
	 *
	 * @param string $login_title The page title, with extra context added.
	 * @param string $title       The original page title.
	 */
	$login_title = apply_filters( 'login_title', $login_title, $title );
	?><!DOCTYPE html>
	<head>
	<title><?php echo esc_attr( $login_title ); ?></title>
	<?php
	wp_enqueue_style( 'login' );

	/**
	 * Enqueue scripts and styles for the login page.
	 *
	 * @since 3.1.0
	 */
	do_action( 'login_enqueue_scripts' );

	/**
	 * Fires in the login page header after scripts are enqueued.
	 *
	 * @since 2.1.0
	 */
	do_action( 'login_head' );
	?>
	</head>

	<?php
}

/**
 * Fires before a specified login form action.
 */
do_action( 'login_form_login' );

/**
 * Filters the separator used between login form navigation links.
 */
$login_link_separator = apply_filters( 'login_link_separator', ' | ' );

/**
 * Filters the login page errors.
 *
 * @since 3.6.0
 *
 * @param object $errors      WP Error object.
 * @param string $redirect_to Redirect destination URL.
 */
logindesigner_login_header( __( 'Log In' ), '', '' );

$login_header_url   = __( 'https://wordpress.org/' );
$login_header_title = __( 'Powered by WordPress' );

/**
 * Filters link URL of the header logo above login form.
 *
 * @since 2.1.0
 *
 * @param string $login_header_url Login header logo URL.
 */
$login_header_url = apply_filters( 'login_headerurl', $login_header_url );

/**
 * Filters the title attribute of the header logo above login form.
 *
 * @since 2.1.0
 *
 * @param string $login_header_title Login header logo title attribute.
 */
$login_header_title = apply_filters( 'login_headertitle', $login_header_title );

unset( $login_header_url, $login_header_title );

/**
 * Filters the login page body classes.
 *
 * @since 3.5.0
 *
 * @param array  $classes An array of body classes.
 * @param string $action  The action that brought the visitor to the login page.
 */
$classes   = array( 'login-action-login', 'wp-core-ui' );
$classes[] = ' locale-' . sanitize_html_class( strtolower( str_replace( '_', '-', get_locale() ) ) );
$classes   = apply_filters( 'login_body_class', $classes, 'login' );
?>

	<body class="login <?php echo esc_attr( implode( ' ', $classes ) ); ?>">

		<?php
		/**
		 * Fires in the login page header after the body tag is opened.
		 *
		 * @since 4.6.0
		 */
		do_action( 'login_header' );
		?>

		<div id="login-designer--background-hint" data-hint="<?php echo esc_attr__( 'Click here to upload a background image, choose from the gallery and set a background color.', 'login-designer' ); ?>" data-hintPosition="middle-right" data-position="bottom-right-aligned"></div>

		<div id="login-designer--templates-hint" data-hint="<?php echo esc_attr__( 'Click here to select a display template for your login page.', 'login-designer' ); ?>" data-hintPosition="middle-right" data-position="bottom"></div>

		<div id="login">

			<h1 id="login-designer-logo-h1" data-hint="<?php echo esc_attr__( 'Click on the logo below to upload your own and set the image\'s height and width.', 'login-designer' ); ?>" data-hintPosition="top-middle" data-position="right">
				<a id="login-designer-logo" class="customize-unpreviewable" href="#" title="" tabindex="-1"><?php bloginfo( 'name' ); ?></a>
			</h1>

			<?php
			$options    = new Login_Designer_Customizer_Output();
			$option     = $options->option_wrapper( 'username_label' );
			$visibility = ( '' !== $option ) ? null : 'no-label';
			?>

			<form name="loginform" id="loginform" class="<?php echo esc_attr( $visibility ); ?>"  action="<?php echo esc_url( site_url( 'wp-login.php', 'login_post' ) ); ?>" method="post">

				<p>
					<label id="login-designer--username-label" for="user_login">
						<span id="login-designer--username-label-text"><?php echo esc_html__( 'Username or Email Address', 'login-designer' ); ?></span>
						<div id="login-designer--username">
							<input autocomplete="off" type="text" name="log" id="user_login" class="input" value="email@address.com" size="20" />
						</div>
					</label>
				</p>

				<p>
					<label id="login-designer--password-label" for="user_pass">
						<span id="login-designer--password-label-text"><?php echo esc_html__( 'Password', 'login-designer' ); ?></span>
						<div id="login-designer--password">
							<input autocomplete="off" type="password" name="pwd" id="user_pass" class="input" value="password" size="20" />
						</div>
					</label>
				</p>

				<?php do_action( 'login_form' ); ?>

				<div class="login-designer--form-footer">
					<p class="forgetmenot">
						<label for="rememberme">
							<input name="rememberme" type="checkbox" id="rememberme" value="forever" />
							<?php esc_html_e( 'Remember Me' ); ?>
						</label>
					</p>

					<p class="submit">
						<span id="login-designer--button">
							<input type="submit" name="wp-submit" id="wp-submit" class="button button-primary button-large" value="<?php echo esc_html__( 'Log In', 'login-designer' ); ?>" />
						</span>
					</p>
				</div>
			</form>

			<div id="login-designer--below-form" data-hint="<?php echo esc_attr__( 'Click on the elements below the form to modify each one.', 'login-designer' ); ?>" data-hintPosition="middle-right" data-position="bottom-right-aligned">

				<p id="nav">
					<?php
					if ( get_option( 'users_can_register' ) ) :
						$registration_url = sprintf( '<a href="%s">%s</a>', esc_url( wp_registration_url() ), __( 'Register' ) );
						/** This filter is documented in wp-includes/general-template.php */
						echo apply_filters( 'register', $registration_url );
						echo esc_html( $login_link_separator );
					endif;
					?>
					<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php _e( 'Lost your password?' ); ?></a>

				</p>

				<p id="backtoblog">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
						<?php
						/* translators: %s: site title */
						printf( _x( '&larr; Back to %s', 'site' ), esc_html( get_bloginfo( 'title', 'display' ) ) );
						?>
					</a>
				</p>

			</div>

		</div>

		<?php do_action( 'login_footer' ); ?>

		<div class="clear"></div>
		<div id="login-designer-background"></div>

	</body>

</html>

<?php
wp_footer();
