<?php if ( ! defined( 'ABSPATH' ) ) { die; } // 不能直接访问网页.
// ===============================================================================================
// -----------------------------------------------------------------------------------------------
// 主题框架设置
// -----------------------------------------------------------------------------------------------
// ===============================================================================================

$settings = array(
    'menu_title'      => THE4_THEME_NAME,
    'menu_type'       => 'menu', // menu, submenu, options, theme, etc.
    'menu_slug'       => 'the4-theme'.'-'.wp_get_theme()->display('Name'),
    'menu_position'   => 59,
    'ajax_save'       => true,
    'show_reset_all'  => false,
    'menu_icon' => CS_URI.'/assets/images/setting.png',
    'framework_title' => wp_get_theme()->display('Name') .'<small class="oldVer" data-vs="'. THE4_THEME_VERSION . '" style="color:#979797;margin-left:10px">Release ' . THE4_THEME_VERSION .'</small>',
);
// ------------------------------
// SEO                      -
// ------------------------------

$options[] = array(
    'name'  => 'speed',
    'title' => 'SEO设置',
    'icon'  => 'fa fa-magic',

    'fields' => array(

        array(
            'type'    => 'subheading',
            'content' => 'SEO',
        ),

        array(
            'id'      => 'site_seo_switch',
            'type'    => 'switcher',
            'title'   => '主题自带SEO',
            'help'    => '开启后将使用主题自带SEO设置',
            'default' => true
        ),

        array(
            'type'    => 'subheading',
            'content' => '全局SEO功能设定',
        ),

        array(
            'id'      => 'seo_auto_des',
            'type'    => 'switcher',
            'title'   => '文章页描述',
            'help'    => '开启后将自动截取文章内容作为文章description标签',
            'default' => true
        ),

        array(
            'id'    => 'seo_auto_des_num', // this is must be unique
            'type'  => 'text',
            'title' => '自动截取字节数',
            'default' => '120',
            'dependency'   => array( 'seo_auto_des', '==', true ),
        ),



        array(
            'id'      => 'seo_sep', // this is must be unique
            'type'    => 'text',
            'title'   => 'Title后缀分隔符',
            'default' => ' - ',
        ),

        array(
            'type'    => 'subheading',
            'content' => '首页SEO设置',
        ),

        array(
            'id'    => 'seo_home_title', // this is must be unique
            'type'  => 'text',
            'title' => '首页标题',
            'help'  => '关键词使用英文逗号隔开',
        ),

        array(
            'id'    => 'seo_home_keywords', // this is must be unique
            'type'  => 'text',
            'title' => '首页关键词',
        ),

        array(
            'id'    => 'seo_home_desc', // this is must be unique
            'type'  => 'textarea',
            'title' => '首页描述',
        ),


    ),
);

// ------------------------------
// 优化加速                      -
// ------------------------------

$options[] = array(
    'name'  => 'optimize',
    'title' => '优化加速',
    'icon'  => 'fa fa-magic',

    'fields' => array(

        array(
            'type'    => 'subheading',
            'content' => '常规优化',
        ),

        array(
            'id'      => 'emoji_switcher',
            'type'    => 'switcher',
            'title'   => '禁用emoji表情',
            'default' => true
        ),
        array(
            'id'      => 'rest_switcher',
            'type'    => 'switcher',
            'title'   => '禁用REST API',
            'default' => true
        ),

        array(
            'type'    => 'subheading',
            'content' => '文章优化',
        ),
        array(
            'id'      => 'remove_p_switcher',
            'type'    => 'switcher',
            'title'   => '删除图片两边的&lt;p>标签',
            'default' => true
        ),
        array(
            'id'      => 'auto_thumbnail_switcher',
            'type'    => 'switcher',
            'title'   => '是否开启自动特色图片',
            'default' => true
        ),




    ),
);

// ------------------------------
// 备份                       -
// ------------------------------
$options[]   = array(
    'name'     => 'advanced',
    'title'    => '备份',
    'icon'     => 'fa fa-shield',
    'fields'   => array(

        array(
            'type'    => 'notice',
            'class'   => 'warning',
            'content' => '您可以保存当前的选项，下载一个备份和导入.',
        ),

        // 备份
        array(
            'type'    => 'backup',
        ),

    )
);


CSFramework::instance( $settings, $options );
