/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.TextureMapView;
import com.baidu.mapapi.map.TileOverlay;
import com.baidu.mapapi.map.TileOverlayOptions;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.map.d;
import com.baidu.mapapi.model.CoordUtil;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.model.ParcelItem;
import com.baidu.mapapi.model.inner.GeoPoint;
import com.baidu.platform.comapi.map.A;
import com.baidu.platform.comapi.map.B;
import com.baidu.platform.comapi.map.C;
import com.baidu.platform.comapi.map.f;
import com.baidu.platform.comapi.map.g;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    private static final String d = BaiduMap.class.getSimpleName();
    private Projection e;
    private UiSettings f;
    private g g;
    private com.baidu.platform.comapi.map.c h;
    private C i;
    private List<Overlay> j;
    private List<Marker> k;
    private Overlay.a l;
    private OnMapStatusChangeListener m;
    private OnMapTouchListener n;
    private OnMapClickListener o;
    private OnMapLoadedCallback p;
    private OnMapDoubleClickListener q;
    private OnMapLongClickListener r;
    private CopyOnWriteArrayList<OnMarkerClickListener> s = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<OnPolylineClickListener> t = new CopyOnWriteArrayList();
    private OnMarkerDragListener u;
    private OnMyLocationClickListener v;
    private SnapshotReadyCallback w;
    private OnMapDrawFrameCallback x;
    private TileOverlay y;
    private HeatMap z;
    private Lock A = new ReentrantLock();
    private Lock B = new ReentrantLock();
    private InfoWindow C;
    private Marker D;
    private View E;
    private Marker F;
    private MyLocationData G;
    private MyLocationConfiguration H;
    MapView a;
    TextureMapView b;
    A c;
    private boolean I;

    private void c() {
        this.j = new CopyOnWriteArrayList<Overlay>();
        this.k = new CopyOnWriteArrayList<Marker>();
        this.f = new UiSettings(this.h);
        this.l = new a(this);
        b b2 = new b(this);
        this.h.a(b2);
        c c2 = new c(this);
        this.h.a(c2);
        d d2 = new d(this);
        this.h.a(d2);
    }

    BaiduMap(C c2) {
        this.i = c2;
        this.h = this.i.b();
        this.c = com.baidu.platform.comapi.map.A.b;
        this.c();
    }

    BaiduMap(g g2) {
        this.g = g2;
        this.h = this.g.a();
        this.c = com.baidu.platform.comapi.map.A.a;
        this.c();
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Marker marker;
        if (overlayOptions == null) {
            return null;
        }
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.l;
        if (overlay instanceof Marker) {
            marker = (Marker)overlay;
            if (marker.n != null && marker.n.size() != 0) {
                this.k.add(marker);
                if (this.h != null) {
                    this.h.b(true);
                }
            }
        }
        marker = new Bundle();
        overlay.a((Bundle)marker);
        if (this.h != null) {
            this.h.b((Bundle)marker);
        }
        this.j.add(overlay);
        return overlay;
    }

    public final void clear() {
        this.j.clear();
        this.k.clear();
        if (this.h != null) {
            this.h.b(false);
            this.h.k();
        }
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        B b2 = this.a(mapStatusUpdate);
        if (this.h == null) {
            return;
        }
        this.h.a(b2);
        if (this.m != null) {
            this.m.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        if (this.h == null) {
            return null;
        }
        B b2 = this.h.v();
        return MapStatus.a(b2);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        B b2 = this.a(mapStatusUpdate);
        if (this.h == null) {
            return;
        }
        if (!this.I) {
            this.h.a(b2);
        } else {
            this.h.a(b2, n2);
        }
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private B a(MapStatusUpdate mapStatusUpdate) {
        B b2 = this.h.v();
        MapStatus mapStatus = mapStatusUpdate.a(this.h, this.getMapStatus());
        B b3 = mapStatus.b(b2);
        return b3;
    }

    public final void setMapType(int n2) {
        if (this.h == null) {
            return;
        }
        if (n2 == 1) {
            this.h.a(false);
        } else if (n2 == 2) {
            this.h.a(true);
        }
    }

    public final int getMapType() {
        if (this.h == null) {
            return 1;
        }
        return this.h.i() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        if (this.h == null) {
            return 0.0f;
        }
        return this.h.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 20.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        if (this.h != null) {
            this.h.a = f2;
            this.h.b = f3;
        }
    }

    public final float getMinZoomLevel() {
        if (this.h == null) {
            return 0.0f;
        }
        return this.h.b;
    }

    public final Projection getProjection() {
        return this.e;
    }

    public final UiSettings getUiSettings() {
        return this.f;
    }

    public final void setBuildingsEnabled(boolean bl) {
        if (this.h != null) {
            this.h.f(bl);
        }
    }

    public final boolean isBuildingsEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.j();
    }

    public final void setMyLocationEnabled(boolean bl) {
        if (this.h != null) {
            this.h.h(bl);
        }
    }

    public final boolean isMyLocationEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.n();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.G = myLocationData;
        if (this.H == null) {
            this.H = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.H);
    }

    public final MyLocationData getLocationData() {
        return this.G;
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.H = myLocationConfiguration;
        this.a(this.G, this.H);
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.H;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        GeoPoint geoPoint = CoordUtil.ll2mc((LatLng)latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", geoPoint.getLongitudeE6());
            jSONObject2.put("pty", geoPoint.getLatitudeE6());
            float f2 = CoordUtil.getMCDistanceByOneLatLngAndRadius((LatLng)latLng, (int)((int)myLocationData.accuracy));
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", geoPoint.getLongitudeE6());
                jSONObject3.put("pty", geoPoint.getLatitudeE6());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                ParcelItem[] parcelItemArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelItemArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", (Parcelable[])parcelItemArray);
            }
        }
        if (this.h != null) {
            this.h.a(jSONObject.toString(), bundle);
        }
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.A.lock();
        try {
            if (heatMap == this.z) {
                return;
            }
            if (this.z != null) {
                this.z.b();
                this.z.c();
                this.z.a = null;
                this.h.l();
            }
            this.z = heatMap;
            this.z.a = this;
            this.h.i(true);
        }
        finally {
            this.A.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(HeatMap heatMap) {
        this.A.lock();
        try {
            if (this.z != null && heatMap == this.z) {
                this.z.b();
                this.z.c();
                this.z.a = null;
                this.h.l();
                this.z = null;
                this.h.i(false);
            }
        }
        finally {
            this.A.unlock();
        }
    }

    void a() {
        this.h.o();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        if (this.h != null) {
            this.h.d(bl);
        }
    }

    public final boolean isBaiduHeatMapEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.g();
    }

    public final boolean isSupportBaiduHeatMap() {
        if (this.h == null) {
            return false;
        }
        return this.h.h();
    }

    public final void setTrafficEnabled(boolean bl) {
        if (this.h != null) {
            this.h.e(bl);
        }
    }

    public final boolean isTrafficEnabled() {
        if (this.h == null) {
            return false;
        }
        return this.h.f();
    }

    public final void showMapPoi(boolean bl) {
        if (this.h != null) {
            this.h.n(bl);
        }
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.w = snapshotReadyCallback;
        switch (this.c) {
            case b: {
                if (this.i == null) break;
                this.i.a("anything", null);
                break;
            }
            case a: {
                if (this.g == null) break;
                this.g.a("anything", null);
                break;
            }
        }
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback snapshotReadyCallback) {
        this.w = snapshotReadyCallback;
        switch (this.c) {
            case b: {
                if (this.i == null) break;
                this.i.a("anything", rect);
                break;
            }
            case a: {
                if (this.g == null) break;
                this.g.a("anything", rect);
                break;
            }
        }
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            Object object;
            Object object2;
            this.hideInfoWindow();
            if (infoWindow.b != null) {
                this.E = infoWindow.b;
                this.E.destroyDrawingCache();
                object2 = new MapViewLayoutParams.Builder();
                object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.e).build();
                if (this.a != null) {
                    this.a.addView(this.E, (ViewGroup.LayoutParams)object);
                }
            }
            this.C = infoWindow;
            object2 = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            object = new MarkerOptions().perspective(false).icon((BitmapDescriptor)object2).position(infoWindow.c).zIndex(Integer.MAX_VALUE).a(infoWindow.e);
            Overlay overlay = ((MarkerOptions)object).a();
            overlay.listener = this.l;
            overlay.q = com.baidu.platform.comapi.map.f.b;
            Bundle bundle = new Bundle();
            overlay.a(bundle);
            if (this.h != null) {
                this.h.b(bundle);
            }
            this.j.add(overlay);
            this.D = (Marker)overlay;
        }
    }

    public void hideInfoWindow() {
        if (this.C != null) {
            if (this.C.b != null) {
                if (this.a != null) {
                    this.a.removeView(this.E);
                }
                this.E = null;
            }
            this.C = null;
            this.D.remove();
            this.D = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.m = onMapStatusChangeListener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        this.n = onMapTouchListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.o = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.p = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.q = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.r = onMapLongClickListener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        if (onPolylineClickListener != null) {
            this.t.add(onPolylineClickListener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (onMarkerClickListener != null && !this.s.contains(onMarkerClickListener)) {
            this.s.add(onMarkerClickListener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.u = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.v = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.x = onMapDrawFrameCallback;
    }

    public final void removeMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (this.s.contains(onMarkerClickListener)) {
            this.s.remove(onMarkerClickListener);
        }
    }

    public TileOverlay addTileLayer(TileOverlayOptions tileOverlayOptions) {
        if (tileOverlayOptions == null) {
            return null;
        }
        if (this.y != null) {
            this.y.b();
            this.y.clearTileCache();
            this.y.a = null;
        }
        if (this.h != null && this.h.a(tileOverlayOptions.a())) {
            TileOverlay tileOverlay;
            this.y = tileOverlay = tileOverlayOptions.a(this);
            return tileOverlay;
        }
        return null;
    }

    boolean b() {
        if (this.h == null) {
            return false;
        }
        return this.h.d();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(TileOverlay tileOverlay) {
        this.B.lock();
        try {
            if (tileOverlay != null && this.y == tileOverlay) {
                tileOverlay.clearTileCache();
                tileOverlay.b();
                tileOverlay.a = null;
                tileOverlay = null;
                if (this.h != null) {
                    this.h.c(false);
                }
            }
        }
        finally {
            this.y = null;
            this.B.unlock();
        }
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.j;
    }

    static /* synthetic */ com.baidu.platform.comapi.map.c b(BaiduMap baiduMap) {
        return baiduMap.h;
    }

    static /* synthetic */ List c(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ View d(BaiduMap baiduMap) {
        return baiduMap.E;
    }

    static /* synthetic */ OnMapStatusChangeListener e(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ OnMapTouchListener f(BaiduMap baiduMap) {
        return baiduMap.n;
    }

    static /* synthetic */ OnMapClickListener g(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ OnMapDoubleClickListener h(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ OnMapLongClickListener i(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.e = projection;
        return baiduMap.e;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.I = bl;
        return baiduMap.I;
    }

    static /* synthetic */ OnMapLoadedCallback j(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ SnapshotReadyCallback k(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ OnMyLocationClickListener l(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ InfoWindow m(BaiduMap baiduMap) {
        return baiduMap.C;
    }

    static /* synthetic */ Marker n(BaiduMap baiduMap) {
        return baiduMap.D;
    }

    static /* synthetic */ CopyOnWriteArrayList o(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ CopyOnWriteArrayList p(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    static /* synthetic */ Marker q(BaiduMap baiduMap) {
        return baiduMap.F;
    }

    static /* synthetic */ Projection r(BaiduMap baiduMap) {
        return baiduMap.e;
    }

    static /* synthetic */ OnMarkerDragListener s(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.F = marker;
        return baiduMap.F;
    }

    static /* synthetic */ Lock t(BaiduMap baiduMap) {
        return baiduMap.A;
    }

    static /* synthetic */ HeatMap u(BaiduMap baiduMap) {
        return baiduMap.z;
    }

    static /* synthetic */ OnMapDrawFrameCallback v(BaiduMap baiduMap) {
        return baiduMap.x;
    }

    static /* synthetic */ Lock w(BaiduMap baiduMap) {
        return baiduMap.B;
    }

    static /* synthetic */ TileOverlay x(BaiduMap baiduMap) {
        return baiduMap.y;
    }

    public static interface OnMapDrawFrameCallback {
        public void onMapDrawFrame(GL10 var1, MapStatus var2);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

