/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.support.v4.util.LongSparseArray;
import android.util.SparseIntArray;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.Gradient;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.Tile;
import com.baidu.mapapi.map.WeightedLatLng;
import com.baidu.mapapi.map.e;
import com.baidu.mapapi.map.f;
import com.baidu.mapapi.map.j;
import com.baidu.mapapi.model.LatLng;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;

public class HeatMap {
    private static final String b = HeatMap.class.getSimpleName();
    private static final SparseIntArray c = new SparseIntArray();
    private static final int[] d;
    private static final float[] e;
    private j<WeightedLatLng> f;
    private Collection<WeightedLatLng> g;
    private int h;
    private Gradient i;
    private double j;
    private e k;
    private int[] l;
    private double[] m;
    private double[] n;
    private HashMap<String, Tile> o = new HashMap();
    private ExecutorService p = Executors.newFixedThreadPool(1);
    private HashSet<String> q = new HashSet();
    BaiduMap a;
    public static final int DEFAULT_RADIUS = 12;
    public static final double DEFAULT_OPACITY = 0.6;
    public static final Gradient DEFAULT_GRADIENT;
    private static int r;

    private HeatMap(Builder builder) {
        this.g = builder.a;
        this.h = builder.b;
        this.i = builder.c;
        this.j = builder.d;
        this.m = HeatMap.a(this.h, (double)this.h / 3.0);
        this.a(this.i);
        this.b(this.g);
    }

    public void removeHeatMap() {
        if (this.a != null) {
            this.a.a(this);
        }
    }

    private void b(Collection<WeightedLatLng> collection) {
        this.g = collection;
        if (this.g.isEmpty()) {
            throw new IllegalArgumentException("No input points.");
        }
        this.k = HeatMap.d(this.g);
        this.f = new j(this.k);
        for (WeightedLatLng weightedLatLng : this.g) {
            this.f.a(weightedLatLng);
        }
        this.n = this.a(this.h);
    }

    private static Collection<WeightedLatLng> c(Collection<LatLng> collection) {
        ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
        for (LatLng latLng : collection) {
            arrayList.add(new WeightedLatLng(latLng));
        }
        return arrayList;
    }

    Tile a(int n2, int n3, int n4) {
        String string = n2 + "_" + n3 + "_" + n4;
        Tile tile = this.c(string);
        if (tile != null) {
            return tile;
        }
        if (!this.a(string)) {
            if (this.a != null && r == 0) {
                MapStatus mapStatus = this.a.getMapStatus();
                int n5 = (mapStatus.a.j.b - mapStatus.a.j.a) / 256 + 2;
                int n6 = (mapStatus.a.j.d - mapStatus.a.j.c) / 256 + 2;
                r = n5 * n6 * 4;
            }
            if (this.o.size() > r) {
                this.a();
            }
            if (!this.p.isShutdown()) {
                try {
                    this.p.execute(new f(this, n2, n3, n4));
                    this.b(string);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    rejectedExecutionException.printStackTrace();
                }
            }
        }
        return null;
    }

    private synchronized boolean a(String string) {
        return this.q.contains(string);
    }

    private synchronized void b(String string) {
        this.q.add(string);
    }

    synchronized void a() {
        this.q.clear();
        this.o.clear();
    }

    private synchronized Tile c(String string) {
        if (this.o.containsKey(string)) {
            Tile tile = this.o.get(string);
            this.o.remove(string);
            return tile;
        }
        return null;
    }

    private synchronized void a(String string, Tile tile) {
        this.o.put(string, tile);
    }

    private synchronized void d() {
        this.o.clear();
    }

    void b() {
        this.d();
    }

    void c() {
        this.p.shutdownNow();
    }

    private void b(int n2, int n3, int n4) {
        Object object;
        WeightedLatLng weightedLatLng2;
        double d2 = c.get(n4);
        double d3 = d2 * (double)this.h / 256.0;
        double d4 = d2 + 2.0 * d3;
        double d5 = d4 / (double)(256 + this.h * 2);
        if (n2 < 0 || n3 < 0) {
            return;
        }
        double d6 = (double)n2 * d2 - d3;
        double d7 = (double)(n2 + 1) * d2 + d3;
        double d8 = (double)n3 * d2 - d3;
        double d9 = (double)(n3 + 1) * d2 + d3;
        e e2 = new e(d6, d7, d8, d9);
        e e3 = new e(this.k.a - d3, this.k.c + d3, this.k.b - d3, this.k.d + d3);
        if (!e2.a(e3)) {
            return;
        }
        Collection<WeightedLatLng> collection = this.f.a(e2);
        if (collection.isEmpty()) {
            return;
        }
        double[][] dArray = new double[256 + this.h * 2][256 + this.h * 2];
        for (WeightedLatLng weightedLatLng2 : collection) {
            object = weightedLatLng2.a();
            int n5 = (int)(((double)object.x - d6) / d5);
            int n6 = (int)((d9 - (double)object.y) / d5);
            if (n5 >= 256 + this.h * 2) {
                n5 = 256 + this.h * 2 - 1;
            }
            if (n6 >= 256 + this.h * 2) {
                n6 = 256 + this.h * 2 - 1;
            }
            double[] dArray2 = dArray[n5];
            int n7 = n6;
            dArray2[n7] = dArray2[n7] + weightedLatLng2.intensity;
        }
        Object object2 = HeatMap.a(dArray, this.m);
        weightedLatLng2 = HeatMap.a((double[][])object2, this.l, this.n[n4 - 1]);
        object = HeatMap.a((Bitmap)weightedLatLng2);
        weightedLatLng2.recycle();
        weightedLatLng2 = null;
        String string = n2 + "_" + n3 + "_" + n4;
        this.a(string, (Tile)object);
        if (this.o.size() > r) {
            this.a();
        }
        if (this.a != null) {
            this.a.a();
        }
    }

    private void a(Gradient gradient) {
        this.i = gradient;
        this.l = gradient.a(this.j);
    }

    private double[] a(int n2) {
        int n3;
        double[] dArray = new double[20];
        for (n3 = 5; n3 < 11; ++n3) {
            dArray[n3] = HeatMap.a(this.g, this.k, n2, (int)(1280.0 * Math.pow(2.0, n3 - 3)));
            if (n3 != 5) continue;
            for (int i2 = 0; i2 < n3; ++i2) {
                dArray[i2] = dArray[n3];
            }
        }
        for (n3 = 11; n3 < 20; ++n3) {
            dArray[n3] = dArray[10];
        }
        return dArray;
    }

    private static Tile a(Bitmap bitmap) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
        bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
        byte[] byArray = byteBuffer.array();
        return new Tile(256, 256, byArray);
    }

    private static e d(Collection<WeightedLatLng> collection) {
        Iterator<WeightedLatLng> iterator = collection.iterator();
        WeightedLatLng weightedLatLng = iterator.next();
        double d2 = weightedLatLng.a().x;
        double d3 = weightedLatLng.a().x;
        double d4 = weightedLatLng.a().y;
        double d5 = weightedLatLng.a().y;
        while (iterator.hasNext()) {
            WeightedLatLng weightedLatLng2 = iterator.next();
            double d6 = weightedLatLng2.a().x;
            double d7 = weightedLatLng2.a().y;
            if (d6 < d2) {
                d2 = d6;
            }
            if (d6 > d3) {
                d3 = d6;
            }
            if (d7 < d4) {
                d4 = d7;
            }
            if (!(d7 > d5)) continue;
            d5 = d7;
        }
        return new e(d2, d3, d4, d5);
    }

    private static double[] a(int n2, double d2) {
        double[] dArray = new double[n2 * 2 + 1];
        for (int i2 = -n2; i2 <= n2; ++i2) {
            dArray[i2 + n2] = Math.exp((double)(-i2 * i2) / (2.0 * d2 * d2));
        }
        return dArray;
    }

    private static double[][] a(double[][] dArray, double[] dArray2) {
        int n2;
        double d2;
        int n3;
        int n4;
        int n5 = (int)Math.floor((double)dArray2.length / 2.0);
        int n6 = dArray.length;
        int n7 = n6 - 2 * n5;
        int n8 = n5;
        int n9 = n5 + n7 - 1;
        double[][] dArray3 = new double[n6][n6];
        for (n4 = 0; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray[n4][n3];
                if (d2 == 0.0) continue;
                int n10 = (n9 < n4 + n5 ? n9 : n4 + n5) + 1;
                for (int i2 = n2 = n8 > n4 - n5 ? n8 : n4 - n5; i2 < n10; ++i2) {
                    double[] dArray4 = dArray3[i2];
                    int n11 = n3;
                    dArray4[n11] = dArray4[n11] + d2 * dArray2[i2 - (n4 - n5)];
                }
            }
        }
        double[][] dArray5 = new double[n7][n7];
        for (n4 = n8; n4 < n9 + 1; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                d2 = dArray3[n4][n3];
                if (d2 == 0.0) continue;
                int n12 = (n9 < n3 + n5 ? n9 : n3 + n5) + 1;
                for (int i3 = n2 = n8 > n3 - n5 ? n8 : n3 - n5; i3 < n12; ++i3) {
                    double[] dArray6 = dArray5[n4 - n5];
                    int n13 = i3 - n5;
                    dArray6[n13] = dArray6[n13] + d2 * dArray2[i3 - (n3 - n5)];
                }
            }
        }
        return dArray5;
    }

    private static Bitmap a(double[][] dArray, int[] nArray, double d2) {
        int n2 = nArray[nArray.length - 1];
        double d3 = (double)(nArray.length - 1) / d2;
        int n3 = dArray.length;
        int[] nArray2 = new int[n3 * n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = dArray[i3][i2];
                int n4 = i2 * n3 + i3;
                int n5 = (int)(d4 * d3);
                if (d4 != 0.0) {
                    if (n5 < nArray.length) {
                        nArray2[n4] = nArray[n5];
                        continue;
                    }
                    nArray2[n4] = n2;
                    continue;
                }
                nArray2[n4] = 0;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n3, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(nArray2, 0, n3, 0, 0, n3, n3);
        return bitmap;
    }

    private static double a(Collection<WeightedLatLng> collection, e e2, int n2, int n3) {
        double d2 = e2.c;
        double d3 = e2.a;
        double d4 = e2.d;
        double d5 = e2.b;
        double d6 = d2 - d3 > d4 - d5 ? d2 - d3 : d4 - d5;
        int n4 = (int)((double)(n3 / (2 * n2)) + 0.5);
        double d7 = (double)n4 / d6;
        LongSparseArray longSparseArray = new LongSparseArray();
        double d8 = 0.0;
        for (WeightedLatLng weightedLatLng : collection) {
            Double d9;
            double d10 = weightedLatLng.a().x;
            double d11 = weightedLatLng.a().y;
            int n5 = (int)((d10 - d3) * d7);
            int n6 = (int)((d11 - d5) * d7);
            LongSparseArray longSparseArray2 = (LongSparseArray)longSparseArray.get((long)n5);
            if (longSparseArray2 == null) {
                longSparseArray2 = new LongSparseArray();
                longSparseArray.put((long)n5, (Object)longSparseArray2);
            }
            if ((d9 = (Double)longSparseArray2.get((long)n6)) == null) {
                d9 = 0.0;
            }
            d9 = d9 + weightedLatLng.intensity;
            longSparseArray2.put((long)n6, (Object)d9);
            if (!(d9 > d8)) continue;
            d8 = d9;
        }
        return d8;
    }

    /* synthetic */ HeatMap(Builder builder, f f2) {
        this(builder);
    }

    static /* synthetic */ void a(HeatMap heatMap, int n2, int n3, int n4) {
        heatMap.b(n2, n3, n4);
    }

    static {
        c.put(3, 0x800000);
        c.put(4, 0x400000);
        c.put(5, 0x200000);
        c.put(6, 0x100000);
        c.put(7, 524288);
        c.put(8, 262144);
        c.put(9, 131072);
        c.put(10, 65536);
        c.put(11, 32768);
        c.put(12, 16384);
        c.put(13, 8192);
        c.put(14, 4096);
        c.put(15, 2048);
        c.put(16, 1024);
        c.put(17, 512);
        c.put(18, 256);
        c.put(19, 128);
        c.put(20, 64);
        d = new int[]{Color.rgb((int)0, (int)0, (int)200), Color.rgb((int)0, (int)225, (int)0), Color.rgb((int)255, (int)0, (int)0)};
        e = new float[]{0.08f, 0.4f, 1.0f};
        DEFAULT_GRADIENT = new Gradient(d, e);
        r = 0;
    }

    public static class Builder {
        private Collection<WeightedLatLng> a;
        private int b = 12;
        private Gradient c = DEFAULT_GRADIENT;
        private double d = 0.6;

        public Builder data(Collection<LatLng> collection) {
            if (collection == null || collection.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            if (collection.contains(null)) {
                throw new IllegalArgumentException("input points can not contain null.");
            }
            return this.weightedData(HeatMap.c(collection));
        }

        public Builder weightedData(Collection<WeightedLatLng> collection) {
            if (collection == null || collection.isEmpty()) {
                throw new IllegalArgumentException("No input points.");
            }
            if (collection.contains(null)) {
                throw new IllegalArgumentException("input points can not contain null.");
            }
            ArrayList<WeightedLatLng> arrayList = new ArrayList<WeightedLatLng>();
            for (WeightedLatLng weightedLatLng : collection) {
                LatLng latLng = weightedLatLng.latLng;
                if (!(latLng.latitude < 0.37532 || latLng.latitude > 54.562495 || latLng.longitude < 72.508319) && !(latLng.longitude > 135.942198)) continue;
                arrayList.add(weightedLatLng);
            }
            collection.removeAll(arrayList);
            this.a = collection;
            return this;
        }

        public Builder radius(int n2) {
            this.b = n2;
            if (this.b < 10 || this.b > 50) {
                throw new IllegalArgumentException("Radius not within bounds.");
            }
            return this;
        }

        public Builder gradient(Gradient gradient) {
            if (gradient == null) {
                throw new IllegalArgumentException("gradient can not be null");
            }
            this.c = gradient;
            return this;
        }

        public Builder opacity(double d2) {
            this.d = d2;
            if (this.d < 0.0 || this.d > 1.0) {
                throw new IllegalArgumentException("Opacity must be in range [0, 1]");
            }
            return this;
        }

        public HeatMap build() {
            if (this.a == null) {
                throw new IllegalStateException("No input data: you must use either .data or .weightedData before building");
            }
            return new HeatMap(this, null);
        }
    }
}

