/*
 * Decompiled with CFR 0.152.
 */
package com.sensoro.cloud;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import java.util.List;

class LocationService {
    public static final String TAG = LocationService.class.getSimpleName();
    private Context context;
    private LocationManager ev = null;
    private GPSLocationListener ew = null;
    private NetworkLocationListener ex = null;
    private Location ey = null;

    public LocationService(Context context) {
        this.context = context;
    }

    public void init() {
        Log.d((String)TAG, (String)"init location service");
        if (this.ev == null) {
            this.ev = (LocationManager)this.context.getSystemService("location");
        }
        this.ex = new NetworkLocationListener();
        this.ew = new GPSLocationListener();
        List list = this.ev.getAllProviders();
        try {
            if (list.contains("gps")) {
                this.ev.requestLocationUpdates("gps", 2000L, 50.0f, (LocationListener)this.ew);
            }
            if (list.contains("network")) {
                this.ev.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)this.ex);
            }
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)exception.toString());
        }
        this.ey = this.ev.getLastKnownLocation("network");
        if (this.ey == null) {
            this.ey = this.ev.getLastKnownLocation("gps");
        }
    }

    public Location Y() {
        return this.ey;
    }

    protected boolean a(Location location, Location location2) {
        boolean bl;
        if (location2 == null) {
            return true;
        }
        long l = location.getTime() - location2.getTime();
        boolean bl2 = l > 120000L;
        boolean bl3 = l < -120000L;
        boolean bl4 = bl = l > 0L;
        if (bl2) {
            return true;
        }
        if (bl3) {
            return false;
        }
        int n = (int)(location.getAccuracy() - location2.getAccuracy());
        boolean bl5 = n > 0;
        boolean bl6 = n < 0;
        boolean bl7 = n > 200;
        boolean bl8 = this.d(location.getProvider(), location2.getProvider());
        if (bl6) {
            return true;
        }
        if (bl && !bl5) {
            return true;
        }
        return bl && !bl7 && bl8;
    }

    private boolean d(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public class NetworkLocationListener
    implements LocationListener {
        public void onLocationChanged(Location location) {
            if (LocationService.this.a(location, LocationService.this.ey)) {
                LocationService.this.ey = location;
            }
        }

        public void onStatusChanged(String string, int n, Bundle bundle) {
        }

        public void onProviderEnabled(String string) {
        }

        public void onProviderDisabled(String string) {
        }
    }

    public class GPSLocationListener
    implements LocationListener {
        private boolean ez = false;

        public void onLocationChanged(Location location) {
            if (LocationService.this.a(location, LocationService.this.ey)) {
                LocationService.this.ey = location;
            }
            if (location != null && !this.ez) {
                LocationService.this.ev.removeUpdates((LocationListener)LocationService.this.ex);
                this.ez = true;
            }
        }

        public void onStatusChanged(String string, int n, Bundle bundle) {
            if (0 == n) {
                LocationService.this.ev.requestLocationUpdates("network", 0L, 0.0f, (LocationListener)LocationService.this.ex);
            }
        }

        public void onProviderEnabled(String string) {
        }

        public void onProviderDisabled(String string) {
        }
    }
}

