/*
 * Decompiled with CFR 0.152.
 */
package com.sensoro.cloud;

import android.content.Context;
import android.util.Log;
import com.google.gson.Gson;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.ResponseHandlerInterface;
import com.sensoro.cloud.BeaconDBDao;
import com.sensoro.cloud.Beacons;
import com.sensoro.cloud.Location;
import com.sensoro.cloud.SensorData;
import com.sensoro.cloud.SettingData;
import com.sensoro.cloud.UploadBeacon;
import com.sensoro.cloud.a;
import com.sensoro.cloud.b;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;

class NetUtils {
    public static final String TAG = NetUtils.class.getSimpleName();
    private static final String URL = "http://cloud-api.sensoro.com";
    private static final String UPLOAD_BEACONS = "/beacons/";
    private static final String UPLOAD_BEACONS_END = "?type=multi";
    private static final String X_ACCESS_KEY = "x-access-key";
    private static final String X_ACCESS_NONCE = "x-access-nonce";
    private static final String X_ACCESS_SIGNATURE = "x-access-signature";
    private String X_ACCESS_KEY_VALUE = null;
    private String X_ACCESS_SECTET = null;
    private String X_ACCESS_NONCE_VALUE = null;
    private String X_ACCESS_SIGNATURE_VALUE = null;
    private AsyncHttpClient client;
    private Context context;

    NetUtils(Context context, String string, String string2) {
        this.context = context;
        this.X_ACCESS_KEY_VALUE = string;
        this.X_ACCESS_SECTET = string2;
        this.client = new AsyncHttpClient();
    }

    public void uploadBeacons(final BeaconDBDao beaconDBDao, final ArrayList<a> arrayList) {
        Log.d((String)TAG, (String)"upload beacons");
        String[] stringArray = new String[2];
        this.createURLAndBody(stringArray, arrayList);
        String string = stringArray[0];
        String string2 = stringArray[1];
        Log.d((String)TAG, (String)string2);
        StringEntity stringEntity = null;
        try {
            stringEntity = new StringEntity(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        this.client.setURLEncodingEnabled(false);
        this.createSignature(string, string2, "PUT");
        ArrayList<Header> arrayList2 = new ArrayList<Header>();
        BasicHeader basicHeader = new BasicHeader("Content-Type", "application/json");
        arrayList2.add((Header)basicHeader);
        this.addSignatureHeader(arrayList2);
        Header[] headerArray = arrayList2.toArray(new Header[arrayList2.size()]);
        this.client.put(this.context, string, headerArray, (HttpEntity)stringEntity, null, (ResponseHandlerInterface)new AsyncHttpResponseHandler(){

            public void onFailure(int n, Header[] headerArray, byte[] byArray, Throwable throwable) {
                Log.d((String)TAG, (String)"upload failed");
                String string = null;
                try {
                    if (byArray != null) {
                        string = new String(byArray, "UTF-8");
                        Log.d((String)TAG, (String)string);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }

            public void onSuccess(int n, Header[] headerArray, byte[] byArray) {
                if (n == 206) {
                    Log.d((String)TAG, (String)"upload part success");
                    Object object = null;
                    try {
                        if (byArray != null) {
                            object = new String(byArray, "UTF-8");
                            Log.d((String)TAG, (String)object);
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        unsupportedEncodingException.printStackTrace();
                    }
                }
                Log.d((String)TAG, (String)"update db");
                for (a a2 : arrayList) {
                    a2.c(System.currentTimeMillis());
                    beaconDBDao.update(a2);
                }
            }
        });
    }

    private void createURLAndBody(String[] stringArray, ArrayList<a> arrayList) {
        a a22;
        StringBuilder stringBuilder = new StringBuilder("http://cloud-api.sensoro.com/beacons/");
        ArrayList<Beacons> arrayList2 = new ArrayList<Beacons>();
        for (a a22 : arrayList) {
            String string;
            stringBuilder.append(a22.J() + ",");
            Beacons beacons = new Beacons();
            beacons.mac = string = a22.J();
            SensorData sensorData = new SensorData();
            sensorData.light = a22.getLight();
            sensorData.power = a22.N();
            sensorData.temperature = a22.getTemperature();
            sensorData.accelerometer = a22.O();
            beacons.sensorData = sensorData;
            SettingData settingData = new SettingData();
            settingData.firmwareVersion = a22.getFirmwareVersion();
            settingData.workMode = a22.P();
            settingData.transmitPower = a22.Q();
            settingData.advertisingInterval = a22.S();
            settingData.hasPassword = a22.T();
            settingData.isEncrypt = a22.U();
            settingData.antennaType = a22.R();
            beacons.settingData = settingData;
            Location location = new Location();
            location.lat = a22.V();
            location.lon = a22.W();
            beacons.location = location;
            beacons.UMM = a22.X();
            arrayList2.add(beacons);
        }
        UploadBeacon uploadBeacon = new UploadBeacon();
        uploadBeacon.beacons = arrayList2;
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringArray[0] = stringBuilder.append(UPLOAD_BEACONS_END).toString();
        a22 = new Gson();
        stringArray[1] = a22.toJson(uploadBeacon);
    }

    private void createSignature(String string, String string2, String string3) {
        this.X_ACCESS_NONCE_VALUE = String.valueOf(new Date().getTime());
        this.X_ACCESS_SIGNATURE_VALUE = string2 == null ? this.X_ACCESS_NONCE_VALUE + string3 + string : this.X_ACCESS_NONCE_VALUE + string3 + string + string2;
        byte[] byArray = this.X_ACCESS_SIGNATURE_VALUE.getBytes();
        byte[] byArray2 = b.a(byArray, this.X_ACCESS_SECTET.getBytes());
        this.X_ACCESS_SIGNATURE_VALUE = this.bytesToHexString(byArray2);
    }

    private void addSignatureHeader(ArrayList<Header> arrayList) {
        arrayList.add((Header)new BasicHeader(X_ACCESS_KEY, this.X_ACCESS_KEY_VALUE));
        arrayList.add((Header)new BasicHeader(X_ACCESS_NONCE, this.X_ACCESS_NONCE_VALUE));
        arrayList.add((Header)new BasicHeader(X_ACCESS_SIGNATURE, this.X_ACCESS_SIGNATURE_VALUE));
    }

    public String bytesToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            String string = Integer.toHexString(n);
            if (string.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }
}

