/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

public final class LocationClientOption {
    public static final int MIN_SCAN_SPAN = 1000;
    public static final int GpsFirst = 1;
    public static final int NetWorkFirst = 2;
    public static final int GpsOnly = 3;
    public String coorType = "gcj02";
    public String addrType = "detail";
    public boolean openGps = false;
    public int scanSpan = 0;
    public int timeOut = 12000;
    public String prodName = "SDK6.0";
    public int priority = 1;
    public boolean location_change_notify = false;
    public boolean disableLocCache = true;
    public boolean enableSimulateGps = false;
    public String serviceName = "com.baidu.location.service_v2.9";
    public boolean isIgnoreCacheException = false;
    public boolean isIgnoreKillProcess = true;
    public boolean mIsNeedDeviceDirect = false;
    public boolean isNeedAptag = false;
    public boolean isNeedAptagd = false;
    public boolean isNeedPoiRegion = false;
    public boolean isNeedRegular = false;
    public boolean isNeedAltitude = false;
    protected LocationMode a;

    public LocationClientOption() {
    }

    public LocationClientOption(LocationClientOption locationClientOption) {
        this.coorType = locationClientOption.coorType;
        this.addrType = locationClientOption.addrType;
        this.openGps = locationClientOption.openGps;
        this.scanSpan = locationClientOption.scanSpan;
        this.timeOut = locationClientOption.timeOut;
        this.prodName = locationClientOption.prodName;
        this.priority = locationClientOption.priority;
        this.location_change_notify = locationClientOption.location_change_notify;
        this.serviceName = locationClientOption.serviceName;
        this.disableLocCache = locationClientOption.disableLocCache;
        this.isIgnoreCacheException = locationClientOption.isIgnoreCacheException;
        this.isIgnoreKillProcess = locationClientOption.isIgnoreKillProcess;
        this.enableSimulateGps = locationClientOption.enableSimulateGps;
        this.a = locationClientOption.a;
        this.isNeedAptag = locationClientOption.isNeedAptag;
        this.isNeedAptagd = locationClientOption.isNeedAptagd;
        this.isNeedPoiRegion = locationClientOption.isNeedPoiRegion;
        this.isNeedRegular = locationClientOption.isNeedRegular;
        this.mIsNeedDeviceDirect = locationClientOption.mIsNeedDeviceDirect;
        this.isNeedAltitude = locationClientOption.isNeedAltitude;
    }

    public boolean equals(LocationClientOption locationClientOption) {
        return this.coorType.equals(locationClientOption.coorType) && this.addrType.equals(locationClientOption.addrType) && this.openGps == locationClientOption.openGps && this.scanSpan == locationClientOption.scanSpan && this.timeOut == locationClientOption.timeOut && this.prodName.equals(locationClientOption.prodName) && this.location_change_notify == locationClientOption.location_change_notify && this.priority == locationClientOption.priority && this.disableLocCache == locationClientOption.disableLocCache && this.isIgnoreCacheException == locationClientOption.isIgnoreCacheException && this.isIgnoreKillProcess == locationClientOption.isIgnoreKillProcess && this.isNeedAptag == locationClientOption.isNeedAptag && this.isNeedAptagd == locationClientOption.isNeedAptagd && this.isNeedPoiRegion == locationClientOption.isNeedPoiRegion && this.isNeedRegular == locationClientOption.isNeedRegular && this.mIsNeedDeviceDirect == locationClientOption.mIsNeedDeviceDirect && this.isNeedAltitude == locationClientOption.isNeedAltitude && this.a == locationClientOption.a;
    }

    public String getCoorType() {
        return this.coorType;
    }

    public void setCoorType(String string) {
        if ((string = string.toLowerCase()).equals("gcj02") || string.equals("bd09") || string.equals("bd09ll")) {
            this.coorType = string;
        }
    }

    public String getAddrType() {
        return this.addrType;
    }

    public void setAddrType(String string) {
        this.addrType = string;
        if ("all".equals(this.addrType)) {
            this.setIsNeedAddress(true);
        } else {
            this.setIsNeedAddress(false);
        }
    }

    public void setIsNeedAddress(boolean bl) {
        this.addrType = bl ? "all" : "noaddr";
    }

    public boolean isOpenGps() {
        return this.openGps;
    }

    public void setOpenGps(boolean bl) {
        this.openGps = bl;
    }

    public boolean isLocationNotify() {
        return this.location_change_notify;
    }

    public void setLocationNotify(boolean bl) {
        this.location_change_notify = bl;
    }

    public int getScanSpan() {
        return this.scanSpan;
    }

    public void setScanSpan(int n2) {
        this.scanSpan = n2;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int n2) {
        this.timeOut = n2;
    }

    public String getProdName() {
        return this.prodName;
    }

    public void setProdName(String string) {
        if (string.length() > 64) {
            string = string.substring(0, 64);
        }
        this.prodName = string;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n2) {
        if (n2 == 1 || n2 == 2) {
            this.priority = n2;
        }
    }

    public void setLocationMode(LocationMode locationMode) {
        switch (locationMode) {
            case Hight_Accuracy: {
                this.openGps = true;
                this.priority = 1;
                break;
            }
            case Battery_Saving: {
                this.openGps = false;
                this.priority = 2;
                break;
            }
            case Device_Sensors: {
                this.priority = 3;
                this.openGps = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal this mode : " + (Object)((Object)locationMode));
            }
        }
        this.a = locationMode;
    }

    public LocationMode getLocationMode() {
        return this.a;
    }

    public void setNeedDeviceDirect(boolean bl) {
        this.mIsNeedDeviceDirect = bl;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public void setIsNeedLocationDescribe(boolean bl) {
        this.isNeedAptag = bl;
    }

    private void a(boolean bl) {
        this.isNeedAltitude = bl;
    }

    public void setIsNeedLocationPoiList(boolean bl) {
        this.isNeedAptagd = bl;
    }

    public void setSema(boolean bl, boolean bl2, boolean bl3) {
        this.isNeedAptag = bl;
        this.isNeedPoiRegion = bl2;
        this.isNeedRegular = bl3;
    }

    public void disableCache(boolean bl) {
        this.disableLocCache = bl;
    }

    public boolean isDisableCache() {
        return this.disableLocCache;
    }

    public void SetIgnoreCacheException(boolean bl) {
        this.isIgnoreCacheException = bl;
    }

    public void setIgnoreKillProcess(boolean bl) {
        this.isIgnoreKillProcess = bl;
    }

    public void setEnableSimulateGps(boolean bl) {
        this.enableSimulateGps = bl;
    }

    public static enum LocationMode {
        Hight_Accuracy,
        Battery_Saving,
        Device_Sensors;

    }
}

