/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.InternalQueryDaoAccess;
import de.greenrobot.dao.query.CloseableListIterator;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantLock;

public class LazyList<E>
implements List<E>,
Closeable {
    private final InternalQueryDaoAccess<E> daoAccess;
    private final Cursor cursor;
    private final List<E> entities;
    private final int size;
    private final ReentrantLock lock;
    private volatile int loadedCount;

    LazyList(InternalQueryDaoAccess<E> daoAccess, Cursor cursor, boolean cacheEntities) {
        this.cursor = cursor;
        this.daoAccess = daoAccess;
        this.size = cursor.getCount();
        if (cacheEntities) {
            this.entities = new ArrayList(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.entities.add(null);
            }
        } else {
            this.entities = null;
        }
        if (this.size == 0) {
            cursor.close();
        }
        this.lock = new ReentrantLock();
    }

    public void loadRemaining() {
        this.checkCached();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            this.get(i);
        }
    }

    protected void checkCached() {
        if (this.entities == null) {
            throw new DaoException("This operation only works with cached lazy lists");
        }
    }

    public E peak(int location) {
        if (this.entities != null) {
            return this.entities.get(location);
        }
        return null;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    public boolean isClosed() {
        return this.cursor.isClosed();
    }

    public int getLoadedCount() {
        return this.loadedCount;
    }

    public boolean isLoadedCompletely() {
        return this.loadedCount == this.size;
    }

    @Override
    public boolean add(E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends E> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        this.loadRemaining();
        return this.entities.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        this.loadRemaining();
        return this.entities.containsAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int location) {
        if (this.entities != null) {
            E entity = this.entities.get(location);
            if (entity == null) {
                this.lock.lock();
                try {
                    entity = this.entities.get(location);
                    if (entity == null) {
                        entity = this.loadEntity(location);
                        this.entities.set(location, entity);
                        ++this.loadedCount;
                        if (this.loadedCount == this.size) {
                            this.cursor.close();
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            return entity;
        }
        return this.loadEntity(location);
    }

    protected E loadEntity(int location) {
        this.cursor.moveToPosition(location);
        E entity = this.daoAccess.loadCurrent(this.cursor, 0, true);
        if (entity == null) {
            throw new DaoException("Loading of entity failed (null) at position " + location);
        }
        return entity;
    }

    @Override
    public int indexOf(Object object) {
        this.loadRemaining();
        return this.entities.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new LazyIterator(0, false);
    }

    @Override
    public int lastIndexOf(Object object) {
        this.loadRemaining();
        return this.entities.lastIndexOf(object);
    }

    @Override
    public CloseableListIterator<E> listIterator() {
        return new LazyIterator(0, false);
    }

    public CloseableListIterator<E> listIteratorAutoClose() {
        return new LazyIterator(0, true);
    }

    @Override
    public ListIterator<E> listIterator(int location) {
        return new LazyIterator(location, false);
    }

    @Override
    public E remove(int location) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int location, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public List<E> subList(int start, int end) {
        this.checkCached();
        for (int i = start; i < end; ++i) {
            this.entities.get(i);
        }
        return this.entities.subList(start, end);
    }

    @Override
    public Object[] toArray() {
        this.loadRemaining();
        return this.entities.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.loadRemaining();
        return this.entities.toArray(array);
    }

    protected class LazyIterator
    implements CloseableListIterator<E> {
        private int index;
        private final boolean closeWhenDone;

        public LazyIterator(int startLocation, boolean closeWhenDone) {
            this.index = startLocation;
            this.closeWhenDone = closeWhenDone;
        }

        @Override
        public void add(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public E previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            Object entity = LazyList.this.get(this.index);
            return entity;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(E object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < LazyList.this.size;
        }

        @Override
        public E next() {
            if (this.index >= LazyList.this.size) {
                throw new NoSuchElementException();
            }
            Object entity = LazyList.this.get(this.index);
            ++this.index;
            if (this.index == LazyList.this.size && this.closeWhenDone) {
                this.close();
            }
            return entity;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            LazyList.this.close();
        }
    }
}

