/*
 * Decompiled with CFR 0.152.
 */
package com.sensoro.beacon.kit;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;

public class BaseSettings
implements Parcelable {
    TransmitPower a;
    AdvertisingInterval b;
    EnergySavingMode c;
    int d;
    public static final Parcelable.Creator<BaseSettings> CREATOR = new Parcelable.Creator<BaseSettings>(){

        public BaseSettings a(Parcel parcel) {
            return new BaseSettings(parcel);
        }

        public BaseSettings[] a(int n) {
            return new BaseSettings[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public BaseSettings() {
        this.a = TransmitPower.UNKNOWN;
        this.b = AdvertisingInterval.UNKNOWN;
        this.c = EnergySavingMode.UNKNOWN;
        this.d = Integer.MAX_VALUE;
    }

    public String toString() {
        return "BaseSettings{transmitPower=" + this.a + ", advertisingInterval=" + this.b + ", energySavingMode=" + this.c + ", measuredPower=" + this.d + '}';
    }

    public void setTransmitPower(TransmitPower transmitPower) {
        this.a = transmitPower;
    }

    public TransmitPower getTransmitPower() {
        return this.a;
    }

    public void setAdvertisingInterval(AdvertisingInterval advertisingInterval) {
        this.b = advertisingInterval;
    }

    public AdvertisingInterval getAdvertisingInterval() {
        return this.b;
    }

    public void setEnergySavingMode(EnergySavingMode energySavingMode) {
        this.c = energySavingMode;
    }

    public EnergySavingMode getEnergySavingMode() {
        return this.c;
    }

    public void setMeasuredPower(int n) {
        this.d = n;
    }

    public int getMeasuredPower() {
        return this.d;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.a.ordinal());
        parcel.writeInt(this.b.ordinal());
        parcel.writeInt(this.c.ordinal());
        parcel.writeInt(this.d);
    }

    private BaseSettings(Parcel parcel) {
        this.a = TransmitPower.values()[parcel.readInt()];
        this.b = AdvertisingInterval.values()[parcel.readInt()];
        this.c = EnergySavingMode.values()[parcel.readInt()];
        this.d = parcel.readInt();
    }

    public static enum SecureBroadcastInterval implements Serializable
    {
        UNKNOWN,
        NONE,
        SECURE_BROADCAST_INTERVAL_5_SECONDS,
        SECURE_BROADCAST_INTERVAL_1_MINTE,
        SECURE_BROADCAST_INTERVAL_1_HONR,
        SECURE_BROADCAST_INTERVAL_1_DAY,
        SECURE_BROADCAST_INTERVAL_7_DAYS,
        SECURE_BROADCAST_INTERVAL_30_DAYS;

    }

    public static enum TransmitPower implements Serializable
    {
        UNKNOWN,
        LEVEL0,
        LEVEL1,
        LEVEL2,
        LEVEL3,
        LEVEL4,
        LEVEL5,
        LEVEL6,
        LEVEL7,
        LEVEL8,
        LEVEL9,
        LEVEL10,
        LEVEL11;


        public static Boolean isMicroTX(TransmitPower transmitPower, String string) {
            if (string.equals("A0")) {
                return false;
            }
            if (string.equals("B0")) {
                return false;
            }
            if (string.equals("C0")) {
                if (transmitPower == UNKNOWN) {
                    return null;
                }
                if (transmitPower.compareTo(LEVEL4) < 0) {
                    return true;
                }
                return false;
            }
            return null;
        }

        public static Integer getTransmitPowerValue(TransmitPower transmitPower, String string) {
            if (string.equals("A0")) {
                switch (transmitPower) {
                    case LEVEL0: {
                        return -23;
                    }
                    case LEVEL1: {
                        return -6;
                    }
                    case LEVEL2: {
                        return 0;
                    }
                }
                return null;
            }
            if (string.equals("B0")) {
                switch (transmitPower) {
                    case LEVEL0: {
                        return -30;
                    }
                    case LEVEL1: {
                        return -20;
                    }
                    case LEVEL2: {
                        return -16;
                    }
                    case LEVEL3: {
                        return -12;
                    }
                    case LEVEL4: {
                        return -8;
                    }
                    case LEVEL5: {
                        return -4;
                    }
                    case LEVEL6: {
                        return 0;
                    }
                    case LEVEL7: {
                        return 4;
                    }
                }
                return null;
            }
            if (string.equals("C0")) {
                switch (transmitPower) {
                    case LEVEL0: {
                        return -30;
                    }
                    case LEVEL1: {
                        return -20;
                    }
                    case LEVEL2: {
                        return -16;
                    }
                    case LEVEL3: {
                        return -12;
                    }
                    case LEVEL4: {
                        return -30;
                    }
                    case LEVEL5: {
                        return -20;
                    }
                    case LEVEL6: {
                        return -16;
                    }
                    case LEVEL7: {
                        return -12;
                    }
                    case LEVEL8: {
                        return -8;
                    }
                    case LEVEL9: {
                        return -4;
                    }
                    case LEVEL10: {
                        return 0;
                    }
                    case LEVEL11: {
                        return 4;
                    }
                }
                return null;
            }
            return null;
        }
    }

    public static enum EnergySavingMode implements Serializable
    {
        UNKNOWN,
        NONE,
        LIGHT_SENSOR;

    }

    public static enum AdvertisingInterval implements Serializable
    {
        UNKNOWN,
        ADVERTISING_INTERVAL_100,
        ADVERTISING_INTERVAL_152_5,
        ADVERTISING_INTERVAL_211_25,
        ADVERTISING_INTERVAL_318_75,
        ADVERTISING_INTERVAL_417_5,
        ADVERTISING_INTERVAL_546_25,
        ADVERTISING_INTERVAL_760,
        ADVERTISING_INTERVAL_852_5,
        ADVERTISING_INTERVAL_1022_5,
        ADVERTISING_INTERVAL_1285;


        public static Double getAdvertisingIntervalValue(AdvertisingInterval advertisingInterval) {
            switch (advertisingInterval) {
                case ADVERTISING_INTERVAL_100: {
                    return 100.0;
                }
                case ADVERTISING_INTERVAL_152_5: {
                    return 152.5;
                }
                case ADVERTISING_INTERVAL_211_25: {
                    return 211.25;
                }
                case ADVERTISING_INTERVAL_318_75: {
                    return 318.75;
                }
                case ADVERTISING_INTERVAL_417_5: {
                    return 417.5;
                }
                case ADVERTISING_INTERVAL_546_25: {
                    return 546.25;
                }
                case ADVERTISING_INTERVAL_760: {
                    return 760.0;
                }
                case ADVERTISING_INTERVAL_852_5: {
                    return 852.5;
                }
                case ADVERTISING_INTERVAL_1022_5: {
                    return 1022.5;
                }
                case ADVERTISING_INTERVAL_1285: {
                    return 1285.0;
                }
            }
            return null;
        }
    }
}

