/*
 * Decompiled with CFR 0.152.
 */
package com.sensoro.beacon.kit;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=5)
public class BluetoothCrashResolver {
    private boolean aH = false;
    private boolean aI = false;
    private boolean aJ = false;
    private long aK = 0L;
    private long aL = 0L;
    private long aM = 0L;
    private int aN = 0;
    private int aO = 0;
    private boolean aP = false;
    private long aQ = 0L;
    private Context aR = null;
    private UpdateNotifier aS;
    private Set<String> aT = new HashSet<String>();
    private a aU = new a();
    private final BroadcastReceiver aV = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if (string.equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                if (BluetoothCrashResolver.this.aI) {
                    if (BluetoothCrashResolver.this.isDebugEnabled()) {
                        Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth discovery finished");
                    }
                    BluetoothCrashResolver.this.j();
                } else if (BluetoothCrashResolver.this.isDebugEnabled()) {
                    Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth discovery finished (external)");
                }
            }
            if (string.equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                if (BluetoothCrashResolver.this.aI) {
                    BluetoothCrashResolver.this.aJ = true;
                    if (BluetoothCrashResolver.this.isDebugEnabled()) {
                        Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth discovery started");
                    }
                } else if (BluetoothCrashResolver.this.isDebugEnabled()) {
                    Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth discovery started (external)");
                }
            }
            if (string.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int n = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                switch (n) {
                    case -2147483648: {
                        if (!BluetoothCrashResolver.this.isDebugEnabled()) break;
                        Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth state is ERROR");
                        break;
                    }
                    case 10: {
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth state is OFF");
                        }
                        BluetoothCrashResolver.this.aK = new Date().getTime();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 12: {
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth state is ON");
                        }
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)"BluetoothCrashResolver", (String)("Bluetooth was turned off for " + (BluetoothCrashResolver.this.aL - BluetoothCrashResolver.this.aK) + " milliseconds"));
                        }
                        if (BluetoothCrashResolver.this.aL - BluetoothCrashResolver.this.aK >= 600L) break;
                        BluetoothCrashResolver.this.crashDetected();
                        break;
                    }
                    case 11: {
                        BluetoothCrashResolver.this.aL = new Date().getTime();
                        if (!BluetoothCrashResolver.this.isDebugEnabled()) break;
                        Log.d((String)"BluetoothCrashResolver", (String)"Bluetooth state is TURNING_ON");
                    }
                }
            }
        }
    };

    public BluetoothCrashResolver(Context context) {
        this.aR = context.getApplicationContext();
        if (this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)"constructed");
        }
        this.l();
    }

    public void start() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        intentFilter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        this.aR.registerReceiver(this.aV, intentFilter);
        if (this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)"started listening for BluetoothAdapter events");
        }
    }

    public void stop() {
        this.aR.unregisterReceiver(this.aV);
        if (this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)"stopped listening for BluetoothAdapter events");
        }
        this.k();
    }

    public void enableDebug() {
        this.aH = true;
    }

    public void disableDebug() {
        this.aH = false;
    }

    @TargetApi(value=18)
    public void notifyScannedDevice(BluetoothDevice bluetoothDevice, BluetoothAdapter.LeScanCallback leScanCallback) {
        int n = 0;
        int n2 = 0;
        if (this.isDebugEnabled()) {
            n = this.aT.size();
        }
        this.aT.add(bluetoothDevice.getAddress());
        if (this.isDebugEnabled() && n != (n2 = this.aT.size()) && n2 % 100 == 0 && this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)("Distinct bluetooth devices seen: " + this.aT.size()));
        }
        if (this.aT.size() > this.g() && !this.aI) {
            Log.w((String)"BluetoothCrashResolver", (String)("Large number of bluetooth devices detected: " + this.aT.size() + " Proactively attempting to clear out address list to prevent a crash"));
            Log.w((String)"BluetoothCrashResolver", (String)"Stopping LE Scan");
            BluetoothAdapter.getDefaultAdapter().stopLeScan(leScanCallback);
            this.i();
            this.h();
        }
    }

    public void crashDetected() {
        long l;
        if (Build.VERSION.SDK_INT < 18) {
            if (this.isDebugEnabled()) {
                Log.d((String)"BluetoothCrashResolver", (String)"Ignoring crashes before SDK 18, because BLE is unsupported.");
            }
            return;
        }
        Log.w((String)"BluetoothCrashResolver", (String)"BluetoothService crash detected");
        if (this.aT.size() > 0 && this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)("Distinct bluetooth devices seen at crash: " + this.aT.size()));
        }
        this.aM = l = new Date().getTime();
        ++this.aN;
        if (this.aI) {
            if (this.isDebugEnabled()) {
                Log.d((String)"BluetoothCrashResolver", (String)"Ignoring bluetooth crash because recovery is already in progress.");
            }
        } else {
            this.i();
        }
        this.h();
    }

    public long getLastBluetoothCrashDetectionTime() {
        return this.aM;
    }

    public int getDetectedCrashCount() {
        return this.aN;
    }

    public int getRecoveryAttemptCount() {
        return this.aO;
    }

    public boolean isLastRecoverySucceeded() {
        return this.aP;
    }

    public boolean isRecoveryInProgress() {
        return this.aI;
    }

    public void setUpdateNotifier(UpdateNotifier updateNotifier) {
        this.aS = updateNotifier;
    }

    public void forceFlush() {
        this.i();
        this.h();
    }

    private boolean isDebugEnabled() {
        return this.aH;
    }

    private int g() {
        return 1590;
    }

    private void h() {
        if (this.aS != null) {
            this.aS.dataUpdated();
        }
        if (new Date().getTime() - this.aQ > 60000L) {
            this.k();
        }
    }

    @TargetApi(value=17)
    private void i() {
        ++this.aO;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)"about to check if discovery is active");
        }
        if (!bluetoothAdapter.isDiscovering()) {
            Log.w((String)"BluetoothCrashResolver", (String)"Recovery attempt started");
            this.aI = true;
            this.aJ = false;
            if (this.isDebugEnabled()) {
                Log.d((String)"BluetoothCrashResolver", (String)"about to command discovery");
            }
            if (!bluetoothAdapter.startDiscovery()) {
                Log.w((String)"BluetoothCrashResolver", (String)"Can't start discovery.  Is bluetooth turned on?");
            }
            if (this.isDebugEnabled()) {
                Log.d((String)"BluetoothCrashResolver", (String)("startDiscovery commanded.  isDiscovering()=" + bluetoothAdapter.isDiscovering()));
            }
            if (this.isDebugEnabled()) {
                Log.d((String)"BluetoothCrashResolver", (String)"We will be cancelling this discovery in 5000 milliseconds.");
            }
            this.aU.b(new Void[0]);
        } else {
            Log.w((String)"BluetoothCrashResolver", (String)"Already discovering.  Recovery attempt abandoned.");
        }
    }

    private void j() {
        Log.w((String)"BluetoothCrashResolver", (String)"Recovery attempt finished");
        this.aT.clear();
        this.aI = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void k() {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        this.aQ = new Date().getTime();
        try {
            fileOutputStream = this.aR.openFileOutput("BluetoothCrashResolverState.txt", 0);
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            outputStreamWriter.write(this.aM + "\n");
            outputStreamWriter.write(this.aN + "\n");
            outputStreamWriter.write(this.aO + "\n");
            outputStreamWriter.write(this.aP ? "1\n" : "0\n");
            Set<String> set = this.aT;
            synchronized (set) {
                for (String string : this.aT) {
                    outputStreamWriter.write(string);
                    outputStreamWriter.write("\n");
                }
            }
        }
        catch (IOException iOException) {
            Log.w((String)"BluetoothCrashResolver", (String)"Can't write macs to BluetoothCrashResolverState.txt");
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)("Wrote " + this.aT.size() + " bluetooth addresses"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void l() {
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            fileInputStream = this.aR.openFileInput("BluetoothCrashResolverState.txt");
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            if (string2 != null) {
                this.aM = Long.parseLong(string2);
            }
            if ((string2 = bufferedReader.readLine()) != null) {
                this.aN = Integer.parseInt(string2);
            }
            if ((string2 = bufferedReader.readLine()) != null) {
                this.aO = Integer.parseInt(string2);
            }
            if ((string2 = bufferedReader.readLine()) != null) {
                this.aP = false;
                if (string2.equals("1")) {
                    this.aP = true;
                }
            }
            while ((string = bufferedReader.readLine()) != null) {
                this.aT.add(string);
            }
        }
        catch (IOException iOException) {
            Log.w((String)"BluetoothCrashResolver", (String)"Can't read macs from BluetoothCrashResolverState.txt");
        }
        catch (NumberFormatException numberFormatException) {
            Log.w((String)"BluetoothCrashResolver", (String)"Can't parse file BluetoothCrashResolverState.txt");
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.isDebugEnabled()) {
            Log.d((String)"BluetoothCrashResolver", (String)("Read " + this.aT.size() + " bluetooth addresses"));
        }
    }

    private class a
    extends AsyncTask<Void, Void, Void> {
        private a() {
        }

        protected Void b(Void ... voidArray) {
            block7: {
                try {
                    BluetoothAdapter bluetoothAdapter;
                    Thread.sleep(5000L);
                    if (!BluetoothCrashResolver.this.aJ) {
                        Log.w((String)"BluetoothCrashResolver", (String)"BluetoothAdapter.ACTION_DISCOVERY_STARTED never received.  Recovery may fail.");
                    }
                    if ((bluetoothAdapter = BluetoothAdapter.getDefaultAdapter()).isDiscovering()) {
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)"BluetoothCrashResolver", (String)"Cancelling discovery");
                        }
                        bluetoothAdapter.cancelDiscovery();
                    } else if (BluetoothCrashResolver.this.isDebugEnabled()) {
                        Log.d((String)"BluetoothCrashResolver", (String)"Discovery not running.  Won't cancel it");
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!BluetoothCrashResolver.this.isDebugEnabled()) break block7;
                    Log.d((String)"BluetoothCrashResolver", (String)"DiscoveryCanceller sleep interrupted.");
                }
            }
            return null;
        }

        protected void a(Void void_) {
        }

        protected void onPreExecute() {
        }

        protected void a(Void ... voidArray) {
        }

        protected /* synthetic */ void onProgressUpdate(Object[] objectArray) {
            this.a((Void[])objectArray);
        }

        protected /* synthetic */ void onPostExecute(Object object) {
            this.a((Void)object);
        }

        protected /* synthetic */ Object doInBackground(Object[] objectArray) {
            return this.b((Void[])objectArray);
        }
    }

    public static interface UpdateNotifier {
        public void dataUpdated();
    }
}

