/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.os.Process;
import android.util.SparseArray;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.query.AbstractQuery;
import java.lang.ref.WeakReference;

abstract class AbstractQueryData<T, Q extends AbstractQuery<T>> {
    final String sql;
    final AbstractDao<T, ?> dao;
    final String[] initialValues;
    final SparseArray<WeakReference<Q>> queriesForThreads;

    AbstractQueryData(AbstractDao<T, ?> dao, String sql, String[] initialValues) {
        this.dao = dao;
        this.sql = sql;
        this.initialValues = initialValues;
        this.queriesForThreads = new SparseArray();
    }

    Q forCurrentThread(Q query) {
        if (Thread.currentThread() == ((AbstractQuery)query).ownerThread) {
            System.arraycopy(this.initialValues, 0, ((AbstractQuery)query).parameters, 0, this.initialValues.length);
            return query;
        }
        return this.forCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Q forCurrentThread() {
        int threadId = Process.myTid();
        SparseArray<WeakReference<Q>> sparseArray = this.queriesForThreads;
        synchronized (sparseArray) {
            AbstractQuery<Object> query;
            WeakReference queryRef = (WeakReference)this.queriesForThreads.get(threadId);
            AbstractQuery abstractQuery = query = queryRef != null ? (AbstractQuery)queryRef.get() : null;
            if (query == null) {
                this.gc();
                query = this.createQuery();
                this.queriesForThreads.put(threadId, new WeakReference<AbstractQuery>(query));
            } else {
                System.arraycopy(this.initialValues, 0, query.parameters, 0, this.initialValues.length);
            }
            return (Q)query;
        }
    }

    protected abstract Q createQuery();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gc() {
        SparseArray<WeakReference<Q>> sparseArray = this.queriesForThreads;
        synchronized (sparseArray) {
            for (int i = this.queriesForThreads.size() - 1; i >= 0; --i) {
                if (((WeakReference)this.queriesForThreads.valueAt(i)).get() != null) continue;
                this.queriesForThreads.remove(this.queriesForThreads.keyAt(i));
            }
        }
    }
}

