/*
 * Decompiled with CFR 0.152.
 */
package com.sensoro.beacon.kit;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensoro.beacon.kit.BaseSettings;
import com.sensoro.beacon.kit.BeaconListener;
import com.sensoro.beacon.kit.SensorSettings;
import java.io.Serializable;
import java.math.BigDecimal;

public class Beacon
implements Parcelable,
Cloneable {
    public static final int CONNECTED = 0;
    public static final int DISCONNECTED = 1;
    public static final String FV_10 = "1.0";
    public static final String FV_20 = "2.0";
    public static final String FV_21 = "2.1";
    public static final String FV_22 = "2.2";
    public static final String FV_23 = "2.3";
    public static final String FV_30 = "3.0";
    public static final String FV_31 = "3.1";
    public static final String HV_A0 = "A0";
    public static final String HV_B0 = "B0";
    public static final String HV_C0 = "C0";
    String k;
    Integer l;
    Integer m;
    String n;
    String o;
    int p;
    int q;
    int r;
    String s;
    String t;
    Integer u;
    Double v;
    int w;
    double x;
    Proximity y;
    int d;
    MovingState z;
    double A;
    BaseSettings B;
    SensorSettings C;
    BaseSettings.SecureBroadcastInterval D;
    boolean E;
    boolean F;
    boolean G;
    boolean H;
    BaseSettings.TransmitPower a;
    BaseSettings.AdvertisingInterval b;
    BaseSettings.EnergySavingMode c;
    BeaconListener I;
    public static final Parcelable.Creator<Beacon> CREATOR = new Parcelable.Creator<Beacon>(){

        public Beacon b(Parcel parcel) {
            return new Beacon(parcel);
        }

        public Beacon[] b(int n) {
            return new Beacon[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.b(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.b(parcel);
        }
    };

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.k);
        parcel.writeSerializable((Serializable)this.l);
        parcel.writeSerializable((Serializable)this.m);
        parcel.writeString(this.n);
        parcel.writeString(this.o);
        parcel.writeInt(this.p);
        parcel.writeInt(this.q);
        parcel.writeInt(this.r);
        parcel.writeString(this.s);
        parcel.writeString(this.t);
        parcel.writeSerializable((Serializable)this.u);
        parcel.writeSerializable((Serializable)this.v);
        parcel.writeInt(this.w);
        parcel.writeDouble(this.x);
        parcel.writeInt(this.y.ordinal());
        parcel.writeInt(this.d);
        parcel.writeInt(this.z.ordinal());
        parcel.writeDouble(this.A);
        parcel.writeParcelable((Parcelable)this.B, n);
        parcel.writeParcelable((Parcelable)this.C, n);
        parcel.writeInt(this.D.ordinal());
        parcel.writeByte((byte)(this.E ? 1 : 0));
        parcel.writeByte((byte)(this.F ? 1 : 0));
        parcel.writeByte((byte)(this.G ? 1 : 0));
        parcel.writeByte((byte)(this.H ? 1 : 0));
        parcel.writeInt(this.a.ordinal());
        parcel.writeInt(this.b.ordinal());
        parcel.writeInt(this.c.ordinal());
        parcel.writeParcelable((Parcelable)this.I, 0);
    }

    public Beacon clone() throws CloneNotSupportedException {
        Beacon beacon = null;
        try {
            beacon = (Beacon)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return beacon;
    }

    private Beacon(Parcel parcel) {
        this.k = parcel.readString();
        this.l = parcel != null ? (Integer)parcel.readSerializable() : null;
        this.m = parcel != null ? (Integer)parcel.readSerializable() : null;
        this.n = parcel.readString();
        this.o = parcel.readString();
        this.p = parcel.readInt();
        this.q = parcel.readInt();
        this.r = parcel.readInt();
        this.s = parcel.readString();
        this.t = parcel.readString();
        this.u = parcel != null ? (Integer)parcel.readSerializable() : null;
        this.v = parcel != null ? (Double)parcel.readSerializable() : null;
        this.w = parcel.readInt();
        this.x = parcel.readDouble();
        this.y = Proximity.values()[parcel.readInt()];
        this.d = parcel.readInt();
        this.z = MovingState.values()[parcel.readInt()];
        this.A = parcel.readDouble();
        this.B = (BaseSettings)parcel.readParcelable(BaseSettings.class.getClassLoader());
        this.C = (SensorSettings)parcel.readParcelable(SensorSettings.class.getClassLoader());
        this.D = BaseSettings.SecureBroadcastInterval.values()[parcel.readInt()];
        this.E = parcel.readByte() != 0;
        this.F = parcel.readByte() != 0;
        this.G = parcel.readByte() != 0;
        this.H = parcel.readByte() != 0;
        this.a = BaseSettings.TransmitPower.values()[parcel.readInt()];
        this.b = BaseSettings.AdvertisingInterval.values()[parcel.readInt()];
        this.c = BaseSettings.EnergySavingMode.values()[parcel.readInt()];
        this.I = parcel != null ? (BeaconListener)parcel.readParcelable(BeaconListener.class.getClassLoader()) : null;
    }

    protected Beacon() {
        this.k = null;
        this.l = null;
        this.m = null;
        this.n = null;
        this.o = null;
        this.p = 0;
        this.q = 0;
        this.r = 0;
        this.s = null;
        this.t = null;
        this.u = null;
        this.v = null;
        this.w = 0;
        this.x = 0.0;
        this.y = Proximity.PROXIMITY_UNKNOWN;
        this.d = 0;
        this.z = MovingState.UNKNOWN;
        this.A = 0.0;
        this.B = null;
        this.C = null;
        this.D = BaseSettings.SecureBroadcastInterval.UNKNOWN;
        this.E = true;
        this.F = false;
        this.G = false;
        this.H = false;
        this.a = BaseSettings.TransmitPower.UNKNOWN;
        this.b = BaseSettings.AdvertisingInterval.UNKNOWN;
        this.c = BaseSettings.EnergySavingMode.UNKNOWN;
        this.I = null;
    }

    public String getSerialNumber() {
        return this.k;
    }

    public MovingState getMovingState() {
        return this.z;
    }

    public int getBatteryLevel() {
        return this.q;
    }

    protected int getRemainingLifetime() {
        return this.r;
    }

    public String getHardwareModelName() {
        return this.s;
    }

    public String getFirmwareVersion() {
        return this.t;
    }

    public Integer getTemperature() {
        return this.u;
    }

    public Double getLight() {
        return this.v;
    }

    public int getAccelerometerCount() {
        return this.w;
    }

    protected double getRunningAverageRssi() {
        return this.A;
    }

    public double getAccuracy() {
        if (this.x == -1.0) {
            this.x = this.a(this.d, this.p);
        }
        return this.x;
    }

    public Proximity getProximity() {
        if (this.y == null) {
            this.y = this.a(this.getAccuracy());
        }
        return this.y;
    }

    public int getRssi() {
        return this.p;
    }

    public int getMeasuredPower() {
        return this.d;
    }

    public Integer getMajor() {
        return this.l;
    }

    public Integer getMinor() {
        return this.m;
    }

    public String getMacAddress() {
        return this.o;
    }

    public String getProximityUUID() {
        return this.n;
    }

    public BaseSettings getBaseSettings() {
        return this.B;
    }

    public BaseSettings.SecureBroadcastInterval getSecureBroadcastInterval() {
        return this.D;
    }

    public BaseSettings.AdvertisingInterval getAdvertisingInterval() {
        return this.b;
    }

    public BaseSettings.TransmitPower getTransmitPower() {
        return this.a;
    }

    public boolean isIBeaconEnabled() {
        return this.E;
    }

    public boolean isSecretEnabled() {
        return this.F;
    }

    public boolean isPasswordEnabled() {
        return this.G;
    }

    public boolean isEnergySavingEnabled() {
        return this.H;
    }

    public SensorSettings getSensorSettings() {
        return this.C;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Beacon)) {
            return false;
        }
        Beacon beacon = (Beacon)object;
        return beacon.k.equals(this.k);
    }

    public int hashCode() {
        return this.k.hashCode();
    }

    public String toString() {
        return "Beacon [major=" + this.l + ", minor=" + this.m + ", proximityUUID=" + this.n + ", serialNumber=" + this.k + ", macAddress=" + this.o + ", rssi=" + this.p + ", batteryLevel=" + this.q + ", remainingLifetime=" + this.r + ", hardwareModelName=" + this.s + ", firmwareVersion=" + this.t + ", temperature=" + this.u + ", light=" + this.v + ", accelerometerCount=" + this.w + ", accuracy=" + this.x + ", proximity=" + this.y + ", measuredPower=" + this.d + ", movingState=" + (Object)((Object)this.z) + ", runningAverageRssi=" + this.A + ", baseSettings=" + this.B + ", sensorSettings=" + this.C + ", secureBroadcastInterval=" + this.D + ", isIBeaconEnabled=" + this.E + ", isSecretEnabled=" + this.F + ", isPasswordEnabled=" + this.G + "]";
    }

    private Proximity a(double d2) {
        if (d2 < 0.0) {
            return Proximity.PROXIMITY_UNKNOWN;
        }
        if (d2 < 0.5) {
            return Proximity.PROXIMITY_IMMEDIATE;
        }
        if (d2 <= 4.0) {
            return Proximity.PROXIMITY_NEAR;
        }
        return Proximity.PROXIMITY_FAR;
    }

    private double a(int n, double d2) {
        if (d2 == 0.0) {
            return -1.0;
        }
        double d3 = 0.0;
        double d4 = d2 * 1.0 / (double)n;
        d3 = d4 < 1.0 ? Math.pow(d4, 10.0) : 0.42093 * Math.pow(d4, 6.9476) + 0.54992;
        return new BigDecimal(Double.toString(d3)).setScale(4, 4).doubleValue();
    }

    public static enum MovingState {
        MOVING,
        STILL,
        DISABLED,
        UNKNOWN;


        static MovingState c(int n) {
            switch (n) {
                case 255: {
                    return DISABLED;
                }
                case 0: {
                    return STILL;
                }
                case 1: {
                    return MOVING;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Proximity implements Serializable
    {
        PROXIMITY_IMMEDIATE,
        PROXIMITY_NEAR,
        PROXIMITY_FAR,
        PROXIMITY_UNKNOWN;

    }
}

