/*
 * Decompiled with CFR 0.152.
 */
package com.sensoro.beacon.kit;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.sensoro.beacon.kit.BaseSettings;
import com.sensoro.beacon.kit.Beacon;
import com.sensoro.beacon.kit.SensorSettings;
import com.sensoro.beacon.kit.d;
import com.sensoro.beacon.kit.e;
import com.sensoro.beacon.kit.g;
import com.sensoro.beacon.kit.h;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensoroBeaconConnection {
    public static final int SUCCESS = 0;
    public static final int FAILURE = 1;
    public static final int SETTING_DATA_INVALID = 2;
    public static final int WRITE_NOT_PERMITTED = 3;
    public static final int AUTHORIZATION_FAILED = 4;
    public static final int CONNECTED_TIME_OUT = 5;
    public static final int ERROR_BEACON_MODEL = 6;
    public static final int NOT_SUPPORT = 7;
    private static final String TAG = SensoroBeaconConnection.class.getSimpleName();
    private Context aR;
    private Beacon L;
    private BeaconConnectionCallback bR;
    private d bS;
    private int bT = 0;
    private BaseSettings B;
    private SensorSettings C;
    private BaseSettings bU;
    private SensorSettings bV;
    private boolean bW = false;
    private boolean bX;
    private String bY;
    private int major;
    private int minor;
    private String bZ;
    private String ca;
    private BaseSettings.SecureBroadcastInterval D;
    private boolean E = true;
    private boolean cb;
    private Handler handler;
    private b cc;
    private a cd;
    private boolean ce;
    private HashMap<String, h> cf;
    private e cg;
    private BluetoothGattCallback ch = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
            SensoroBeaconConnection.this.handler.removeCallbacks((Runnable)SensoroBeaconConnection.this.cc);
            SensoroBeaconConnection.this.handler.removeCallbacks((Runnable)SensoroBeaconConnection.this.cd);
            Log.d((String)TAG, (String)"connect timeout---stop time out runnable");
            if (n == 0) {
                if (n2 == 2) {
                    bluetoothGatt.discoverServices();
                }
                if (n2 == 0) {
                    SensoroBeaconConnection.this.cb = false;
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 1, 0);
                    SensoroBeaconConnection.this.cg.b(1, 0);
                    Log.d((String)TAG, (String)"onConnectionStateChange---callback disconnect success");
                }
            } else if (n == 257) {
                SensoroBeaconConnection.this.cb = false;
                if (n2 == 2) {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                    SensoroBeaconConnection.this.cg.b(0, 1);
                    Log.d((String)TAG, (String)"onConnectionStateChange---callback connect failure");
                }
                if (n2 == 0) {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 1, 1);
                    SensoroBeaconConnection.this.cg.b(1, 1);
                    Log.d((String)TAG, (String)"onConnectionStateChange---callback disconnect failure");
                }
            } else if (n == 133) {
                SensoroBeaconConnection.this.cb = false;
                SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                SensoroBeaconConnection.this.cg.b(0, 1);
            } else {
                SensoroBeaconConnection.this.cb = false;
                if (n2 == 2) {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, n);
                    SensoroBeaconConnection.this.cg.b(0, 1);
                    Log.d((String)TAG, (String)"onConnectionStateChange---callback connect failure");
                }
                if (n2 == 0) {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 1, 9);
                    SensoroBeaconConnection.this.cg.b(1, 1);
                    Log.d((String)TAG, (String)"onConnectionStateChange---callback disconnect failure");
                }
            }
            super.onConnectionStateChange(bluetoothGatt, n, n2);
        }

        public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
            if (n == 0) {
                List list = bluetoothGatt.getServices();
                if (SensoroBeaconConnection.this.bS.a(SensoroBeaconConnection.this.ca, SensoroBeaconConnection.this.bZ, list)) {
                    if (!SensoroBeaconConnection.this.bS.q()) {
                        SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                        SensoroBeaconConnection.this.cg.b(0, 1);
                        bluetoothGatt.close();
                        Log.d((String)TAG, (String)"onServicesDiscovered---callback connect failure:no baseSetting char");
                    }
                } else {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                    SensoroBeaconConnection.this.cg.b(0, 1);
                    bluetoothGatt.close();
                    Log.d((String)TAG, (String)"onServicesDiscovered---callback connect failure:no baseSetting or sensorSetting service");
                }
            } else {
                SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                SensoroBeaconConnection.this.cg.b(0, 1);
                bluetoothGatt.close();
                Log.d((String)TAG, (String)"onServicesDiscovered---callback connect failure:get beacon service failure");
            }
            super.onServicesDiscovered(bluetoothGatt, n);
        }

        public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            if (bluetoothGattCharacteristic.getUuid().equals(d.a.by)) {
                h h2 = (h)SensoroBeaconConnection.this.cf.get("RESET_ACCELEROMETER_COUNT");
                if (n == 0) {
                    SensoroBeaconConnection.this.bR.onResetAcceleratorCount(SensoroBeaconConnection.this.L, 0);
                    SensoroBeaconConnection.this.cf.remove("RESET_ACCELEROMETER_COUNT");
                } else {
                    SensoroBeaconConnection.this.bR.onResetAcceleratorCount(SensoroBeaconConnection.this.L, 1);
                    SensoroBeaconConnection.this.cf.remove("RESET_ACCELEROMETER_COUNT");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bm)) {
                h h3 = (h)SensoroBeaconConnection.this.cf.get("DISABLE_PASSWORD");
                h h4 = (h)SensoroBeaconConnection.this.cf.get("WRITE_PASSWORD_STRING");
                h h5 = (h)SensoroBeaconConnection.this.cf.get("WRITE_PASSWORD_BYTE");
                if (n == 0) {
                    if (SensoroBeaconConnection.this.bX) {
                        SensoroBeaconConnection.this.bX = false;
                        SensoroBeaconConnection.this.bR.onDisablePassword(SensoroBeaconConnection.this.L, 0);
                        SensoroBeaconConnection.this.cf.remove("DISABLE_PASSWORD");
                    } else {
                        SensoroBeaconConnection.this.bR.onWritePassword(SensoroBeaconConnection.this.L, 0);
                        if (h5 != null) {
                            SensoroBeaconConnection.this.cf.remove("WRITE_PASSWORD_BYTE");
                        }
                        if (h4 != null) {
                            SensoroBeaconConnection.this.cf.remove("WRITE_PASSWORD_STRING");
                        }
                    }
                } else if (SensoroBeaconConnection.this.bX) {
                    SensoroBeaconConnection.this.bX = false;
                    SensoroBeaconConnection.this.bR.onDisablePassword(SensoroBeaconConnection.this.L, 1);
                    SensoroBeaconConnection.this.cf.remove("DISABLE_PASSWORD");
                } else {
                    SensoroBeaconConnection.this.bR.onWritePassword(SensoroBeaconConnection.this.L, 1);
                    if (h5 != null) {
                        SensoroBeaconConnection.this.cf.remove("WRITE_PASSWORD_BYTE");
                    }
                    if (h4 != null) {
                        h4.onFailure(1);
                        SensoroBeaconConnection.this.cf.remove("WRITE_PASSWORD_STRING");
                    }
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bl)) {
                h h6 = (h)SensoroBeaconConnection.this.cf.get("REQUIRE_WRITE_PERMISSION_STRING");
                h h7 = (h)SensoroBeaconConnection.this.cf.get("REQUIRE_WRITE_PERMISSION_BYTE");
                if (n == 0) {
                    SensoroBeaconConnection.this.bW = true;
                    SensoroBeaconConnection.this.bR.onRequireWritePermission(SensoroBeaconConnection.this.L, 0);
                    if (h7 != null) {
                        h7.onSuccess();
                        SensoroBeaconConnection.this.cf.remove("REQUIRE_WRITE_PERMISSION_BYTE");
                    }
                    if (h6 != null) {
                        h6.onSuccess();
                        SensoroBeaconConnection.this.cf.remove("REQUIRE_WRITE_PERMISSION_STRING");
                    }
                } else if (n == 3) {
                    SensoroBeaconConnection.this.bR.onRequireWritePermission(SensoroBeaconConnection.this.L, 4);
                    if (h7 != null) {
                        h7.onFailure(4);
                        SensoroBeaconConnection.this.cf.remove("REQUIRE_WRITE_PERMISSION_BYTE");
                    }
                    if (h6 != null) {
                        h6.onFailure(4);
                        SensoroBeaconConnection.this.cf.remove("REQUIRE_WRITE_PERMISSION_STRING");
                    }
                } else {
                    SensoroBeaconConnection.this.bR.onRequireWritePermission(SensoroBeaconConnection.this.L, 1);
                    if (h7 != null) {
                        h7.onFailure(1);
                        SensoroBeaconConnection.this.cf.remove("REQUIRE_WRITE_PERMISSION_BYTE");
                    }
                    if (h6 != null) {
                        h6.onFailure(1);
                        SensoroBeaconConnection.this.cf.remove("REQUIRE_WRITE_PERMISSION_STRING");
                    }
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bn)) {
                h h8 = (h)SensoroBeaconConnection.this.cf.get("WRITE_BASE_SETTINGS");
                if (n == 0) {
                    SensoroBeaconConnection.this.B = SensoroBeaconConnection.this.bU;
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.B = SensoroBeaconConnection.this.bU;
                    SensoroBeaconConnection.this.bR.onWriteBaseSetting(SensoroBeaconConnection.this.L, 0);
                    h8.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("WRITE_BASE_SETTINGS");
                } else {
                    SensoroBeaconConnection.this.bR.onWriteBaseSetting(SensoroBeaconConnection.this.L, 1);
                    h8.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("WRITE_BASE_SETTINGS");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bv)) {
                h h9 = (h)SensoroBeaconConnection.this.cf.get("WRITE_SENSOR_SETTINGS");
                if (n == 0) {
                    SensoroBeaconConnection.this.C = SensoroBeaconConnection.this.bV;
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.C = SensoroBeaconConnection.this.bV;
                    SensoroBeaconConnection.this.bR.onWirteSensorSetting(SensoroBeaconConnection.this.L, 0);
                    h9.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("WRITE_SENSOR_SETTINGS");
                } else {
                    SensoroBeaconConnection.this.bR.onWirteSensorSetting(SensoroBeaconConnection.this.L, 1);
                    h9.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("WRITE_SENSOR_SETTINGS");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bo)) {
                h h10 = (h)SensoroBeaconConnection.this.cf.get("WRITE_PROXIMITY_UUID");
                if (n == 0) {
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.n = SensoroBeaconConnection.this.bY;
                    SensoroBeaconConnection.this.bR.onWriteProximityUUID(SensoroBeaconConnection.this.L, 0);
                    h10.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("WRITE_PROXIMITY_UUID");
                } else {
                    SensoroBeaconConnection.this.bR.onWriteProximityUUID(SensoroBeaconConnection.this.L, 1);
                    h10.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("WRITE_PROXIMITY_UUID");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bp)) {
                h h11 = (h)SensoroBeaconConnection.this.cf.get("WRITE_MAJOR_MINOR");
                if (n == 0) {
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.l = SensoroBeaconConnection.this.major;
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.m = SensoroBeaconConnection.this.minor;
                    SensoroBeaconConnection.this.bR.onWriteMajorMinor(SensoroBeaconConnection.this.L, 0);
                    h11.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("WRITE_MAJOR_MINOR");
                } else {
                    SensoroBeaconConnection.this.bR.onWriteMajorMinor(SensoroBeaconConnection.this.L, 1);
                    h11.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("WRITE_MAJOR_MINOR");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bz)) {
                h h12 = (h)SensoroBeaconConnection.this.cf.get("RELOAD_SENSOR_DATA");
                if (n == 0) {
                    SensoroBeaconConnection.this.bR.onReloadSensorData(SensoroBeaconConnection.this.L, 0);
                    h12.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("RELOAD_SENSOR_DATA");
                } else {
                    SensoroBeaconConnection.this.bR.onReloadSensorData(SensoroBeaconConnection.this.L, 1);
                    h12.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("RELOAD_SENSOR_DATA");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bq)) {
                h h13 = (h)SensoroBeaconConnection.this.cf.get("RESET_TO_FACTORY");
                if (n == 0) {
                    SensoroBeaconConnection.this.disconnect();
                    SensoroBeaconConnection.this.bR.onResetToFactorySettings(SensoroBeaconConnection.this.L, 0);
                    h13.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("RESET_TO_FACTORY");
                } else {
                    SensoroBeaconConnection.this.bR.onResetToFactorySettings(SensoroBeaconConnection.this.L, 1);
                    h13.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("RESET_TO_FACTORY");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.br)) {
                h h14 = (h)SensoroBeaconConnection.this.cf.get("WRITE_SECURE_BROADCAST_INTERVAL");
                if (n == 0) {
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.D = SensoroBeaconConnection.this.D;
                    SensoroBeaconConnection.this.bR.onWriteSecureBroadcastInterval(SensoroBeaconConnection.this.L, 0);
                    h14.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("WRITE_SECURE_BROADCAST_INTERVAL");
                } else {
                    SensoroBeaconConnection.this.bR.onWriteSecureBroadcastInterval(SensoroBeaconConnection.this.L, 1);
                    h14.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("WRITE_SECURE_BROADCAST_INTERVAL");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bt)) {
                h h15 = (h)SensoroBeaconConnection.this.cf.get("ENABLE_IBEACON");
                h h16 = (h)SensoroBeaconConnection.this.cf.get("DISABLE_IBEACON");
                if (n == 0) {
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.E = SensoroBeaconConnection.this.E;
                    if (SensoroBeaconConnection.this.E) {
                        SensoroBeaconConnection.this.bR.onEnableIBeacon(SensoroBeaconConnection.this.L, 0);
                        h15.onSuccess();
                        SensoroBeaconConnection.this.cf.remove("ENABLE_IBEACON");
                    } else {
                        SensoroBeaconConnection.this.bR.onDisableIBeacon(SensoroBeaconConnection.this.L, 0);
                        h16.onSuccess();
                        SensoroBeaconConnection.this.cf.remove("DISABLE_IBEACON");
                    }
                } else if (SensoroBeaconConnection.this.E) {
                    SensoroBeaconConnection.this.bR.onEnableIBeacon(SensoroBeaconConnection.this.L, 1);
                    h15.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("ENABLE_IBEACON");
                } else {
                    SensoroBeaconConnection.this.bR.onDisableIBeacon(SensoroBeaconConnection.this.L, 1);
                    h16.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("DISABLE_IBEACON");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bs)) {
                h h17 = (h)SensoroBeaconConnection.this.cf.get("WRITE_BROADCAST_KEY");
                if (n == 0) {
                    if (SensoroBeaconConnection.this.ce) {
                        ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.F = false;
                        SensoroBeaconConnection.this.ce = false;
                    } else {
                        ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.F = true;
                    }
                    SensoroBeaconConnection.this.bR.onWriteBroadcastKey(SensoroBeaconConnection.this.L, 0);
                    h17.onSuccess();
                    SensoroBeaconConnection.this.cf.remove("WRITE_BROADCAST_KEY");
                } else {
                    SensoroBeaconConnection.this.bR.onWriteBroadcastKey(SensoroBeaconConnection.this.L, 1);
                    h17.onFailure(1);
                    SensoroBeaconConnection.this.cf.remove("WRITE_BROADCAST_KEY");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bC)) {
                if (n == 0) {
                    SensoroBeaconConnection.this.bR.onFlashLightWitCommand(SensoroBeaconConnection.this.L, 0);
                } else {
                    SensoroBeaconConnection.this.bR.onFlashLightWitCommand(SensoroBeaconConnection.this.L, 1);
                }
            }
            super.onCharacteristicWrite(bluetoothGatt, bluetoothGattCharacteristic, n);
        }

        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            Log.d((String)TAG, (String)("onCharacteristicRead---status =" + n));
            if (bluetoothGattCharacteristic.getUuid().equals(d.a.bn)) {
                Log.d((String)TAG, (String)"onCharacteristicRead---char is baseSetting");
                if (n == 0) {
                    byte[] byArray = bluetoothGattCharacteristic.getValue();
                    BaseSettings.TransmitPower transmitPower = g.h(byArray[0] & 0xFF);
                    SensoroBeaconConnection.this.B.setTransmitPower(transmitPower);
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.a = transmitPower;
                    BaseSettings.AdvertisingInterval advertisingInterval = g.k(byArray[1] & 0xFF);
                    SensoroBeaconConnection.this.B.setAdvertisingInterval(advertisingInterval);
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.b = advertisingInterval;
                    SensoroBeaconConnection.this.B.setEnergySavingMode(g.i(byArray[2] & 0xFF));
                    int n2 = byArray[3] & 0xFF;
                    SensoroBeaconConnection.this.B.setMeasuredPower(n2 > 127 ? n2 - 256 : n2);
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.G = byArray[4] != 0;
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.B = SensoroBeaconConnection.this.B;
                    if (SensoroBeaconConnection.this.B()) {
                        SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 0);
                        return;
                    }
                    if (SensoroBeaconConnection.this.C()) {
                        if (SensoroBeaconConnection.this.A()) {
                            SensoroBeaconConnection.this.bS.s();
                        } else {
                            SensoroBeaconConnection.this.bS.r();
                        }
                    } else if (SensoroBeaconConnection.this.D()) {
                        SensoroBeaconConnection.this.bS.s();
                    } else {
                        SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 6);
                    }
                } else {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                    bluetoothGatt.close();
                    Log.d((String)TAG, (String)"onCharacteristicRead---callback connect failure:get baseSetting failure");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.br)) {
                Log.d((String)TAG, (String)"onCharacteristicRead---char is dynamic mm");
                if (n == 0) {
                    byte[] byArray = bluetoothGattCharacteristic.getValue();
                    int n3 = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16) + ((byArray[3] & 0xFF) << 24);
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.D = g.l(n3);
                    if (((SensoroBeaconConnection)SensoroBeaconConnection.this).L.s.equals("B0") && ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.t.equals("3.0") || ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.s.equals("C0") && ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.t.equals("3.0")) {
                        SensoroBeaconConnection.this.bS.t();
                    } else {
                        SensoroBeaconConnection.this.bS.r();
                    }
                } else {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                    bluetoothGatt.close();
                    Log.d((String)TAG, (String)"onCharacteristicRead---callback connect failure:get dynamic mm failure");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bt)) {
                Log.d((String)TAG, (String)"onCharacteristicRead---char is work mode");
                if (n == 0) {
                    byte[] byArray = bluetoothGattCharacteristic.getValue();
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.E = byArray[0] != 0;
                    SensoroBeaconConnection.this.bS.r();
                } else {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                    bluetoothGatt.close();
                    Log.d((String)TAG, (String)"onCharacteristicRead---callback connect failure:get work mode failure");
                }
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bv)) {
                Log.d((String)TAG, (String)"onCharacteristicRead---char is sensoSetting");
                if (n == 0) {
                    byte[] byArray = bluetoothGattCharacteristic.getValue();
                    SensoroBeaconConnection.this.C.setTemperatureSamplingInterval((byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8));
                    SensoroBeaconConnection.this.C.setLightSamplingInterval((byArray[2] & 0xFF) + ((byArray[3] & 0xFF) << 8));
                    SensoroBeaconConnection.this.C.setAccelerometerSensitivity(g.j((byArray[4] & 0xFF) + ((byArray[5] & 0xFF) << 8)));
                    ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.C = SensoroBeaconConnection.this.C;
                    SensoroBeaconConnection.this.bS.u();
                } else {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 1);
                    bluetoothGatt.close();
                    Log.d((String)TAG, (String)"onCharacteristicRead---callback connect failure:get sensoSetting failure");
                }
            }
            super.onCharacteristicRead(bluetoothGatt, bluetoothGattCharacteristic, n);
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            if (bluetoothGattCharacteristic.getUuid().equals(d.a.bw)) {
                byte[] byArray = bluetoothGattCharacteristic.getValue();
                int n = byArray[0] & 0xFF;
                ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.u = n == 255 ? null : Integer.valueOf(n);
                SensoroBeaconConnection.this.bR.onUpdateTemperatureData(SensoroBeaconConnection.this.L, ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.u);
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bx)) {
                byte[] byArray = bluetoothGattCharacteristic.getValue();
                int n = byArray[0] & 0xFF;
                int n2 = byArray[1] & 0xFF;
                ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.v = n2 == 255 ? null : Double.valueOf(SensoroBeaconConnection.this.a(n2, n));
                SensoroBeaconConnection.this.bR.onUpdateLightData(SensoroBeaconConnection.this.L, ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.v);
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.bA)) {
                Beacon.MovingState movingState;
                byte[] byArray = bluetoothGattCharacteristic.getValue();
                int n = byArray[0] & 0xFF;
                ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.z = movingState = Beacon.MovingState.c(n);
                SensoroBeaconConnection.this.bR.onUpdateMovingState(SensoroBeaconConnection.this.L, ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.z);
            } else if (bluetoothGattCharacteristic.getUuid().equals(d.a.by)) {
                int n;
                byte[] byArray = bluetoothGattCharacteristic.getValue();
                ((SensoroBeaconConnection)SensoroBeaconConnection.this).L.w = n = (byArray[0] & 0xFF) + ((byArray[1] & 0xFF) << 8) + ((byArray[2] & 0xFF) << 16);
                SensoroBeaconConnection.this.bR.onUpdateAccelerometerCount(SensoroBeaconConnection.this.L, n);
            }
            super.onCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic);
        }

        public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            if (bluetoothGattDescriptor.getUuid().equals(d.a.bE) && n == 0) {
                if (SensoroBeaconConnection.this.bT == 0) {
                    SensoroBeaconConnection.this.bT = 1;
                    SensoroBeaconConnection.this.bS.v();
                } else if (SensoroBeaconConnection.this.bT == 1) {
                    SensoroBeaconConnection.this.bT = 2;
                    SensoroBeaconConnection.this.bS.w();
                } else if (SensoroBeaconConnection.this.bT == 2) {
                    SensoroBeaconConnection.this.bT = 3;
                    SensoroBeaconConnection.this.bS.x();
                } else if (SensoroBeaconConnection.this.bT == 3) {
                    SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 0);
                    Log.d((String)TAG, (String)"onDescriptorWrite---callback connect success");
                    SensoroBeaconConnection.this.cb = true;
                }
            }
            super.onDescriptorWrite(bluetoothGatt, bluetoothGattDescriptor, n);
        }
    };

    public SensoroBeaconConnection(Context context, Beacon beacon, BeaconConnectionCallback beaconConnectionCallback) throws SensoroException {
        if (context == null) {
            throw new SensoroException("Context is null");
        }
        if (beacon == null) {
            throw new SensoroException("Beacon is null");
        }
        if (beaconConnectionCallback == null) {
            throw new SensoroException("BeaconConnectionCallback is null");
        }
        this.bR = beaconConnectionCallback;
        this.aR = context;
        this.L = beacon;
        this.bS = new d(context);
        this.B = new BaseSettings();
        this.C = new SensorSettings();
        this.handler = new Handler();
        this.cc = new b();
        this.cd = new a();
        this.bZ = beacon.getHardwareModelName();
        this.ca = beacon.getFirmwareVersion();
        this.cf = new HashMap();
        this.cg = new e(){

            @Override
            public void b(int n, int n2) {
            }
        };
    }

    public void connect() {
        if (!(this.B() || this.C() || this.D())) {
            this.bR.onConnectedState(this.L, 0, 6);
            return;
        }
        if (!this.bS.m()) {
            this.bR.onConnectedState(this.L, 0, 1);
            Log.d((String)TAG, (String)"connect---callback connect failure:bleHelper init failure");
            return;
        }
        if (!this.bS.a(this.L.getMacAddress(), this.ch)) {
            this.bR.onConnectedState(this.L, 0, 1);
            Log.d((String)TAG, (String)"connect---callback connect failure:bleHelper connect failure");
        }
        this.handler.postDelayed((Runnable)this.cc, 20000L);
        Log.d((String)TAG, (String)"connect timeout---start time out runnable");
    }

    public void disconnect() {
        if (this.n()) {
            this.bR.onConnectedState(this.L, 1, 0);
            this.cg.b(1, 0);
            this.cb = false;
        } else {
            this.bR.onConnectedState(this.L, 1, 1);
            this.cg.b(1, 1);
        }
    }

    private boolean n() {
        return this.bS.n();
    }

    public boolean isConnected() {
        return this.cb;
    }

    public void resetToFactorySettings() {
        if (this.L.G && !this.bW) {
            this.bR.onResetToFactorySettings(this.L, 3);
            return;
        }
        if (!this.bS.o()) {
            this.bR.onResetToFactorySettings(this.L, 1);
        }
    }

    public void resetAccelerometerCount() {
        if (this.L.G && !this.bW) {
            this.bR.onResetAcceleratorCount(this.L, 3);
            return;
        }
        if (!this.bS.p()) {
            this.bR.onResetAcceleratorCount(this.L, 1);
        }
    }

    public void writePassword(String string) {
        if (this.L.G && !this.bW) {
            this.bR.onWritePassword(this.L, 3);
            return;
        }
        if (string == null) {
            this.bR.onWritePassword(this.L, 2);
            return;
        }
        byte[] byArray = new byte[16];
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.bR.onWritePassword(this.L, 2);
            return;
        }
        byte[] byArray3 = g.a(byArray2, "CtKnQ8BVb3C2khd6HQv6FFBuoHzxWi");
        System.arraycopy(byArray3, 0, byArray, 0, 16);
        if (!this.bS.d(byArray)) {
            this.bR.onWritePassword(this.L, 1);
        }
        this.bX = false;
    }

    public void writePassword(byte[] byArray) {
        if (this.L.G && !this.bW) {
            this.bR.onWritePassword(this.L, 3);
            return;
        }
        if (byArray == null) {
            this.bR.onWritePassword(this.L, 2);
            return;
        }
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = g.a(byArray, "CtKnQ8BVb3C2khd6HQv6FFBuoHzxWi");
        System.arraycopy(byArray3, 0, byArray2, 0, 16);
        if (!this.bS.d(byArray2)) {
            this.bR.onWritePassword(this.L, 1);
        }
        this.bX = false;
    }

    public void disablePassword() {
        if (this.L.G && !this.bW) {
            this.bR.onDisablePassword(this.L, 3);
            return;
        }
        this.bX = true;
        byte[] byArray = new byte[16];
        if (!this.bS.d(byArray)) {
            this.bX = false;
            this.bR.onDisablePassword(this.L, 1);
        }
    }

    public void requireWritePermission(String string) {
        byte[] byArray = new byte[16];
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            this.bR.onRequireWritePermission(this.L, 1);
            return;
        }
        byte[] byArray3 = g.a(byArray2, "CtKnQ8BVb3C2khd6HQv6FFBuoHzxWi");
        System.arraycopy(byArray3, 0, byArray, 0, 16);
        if (!this.bS.e(byArray)) {
            this.bR.onRequireWritePermission(this.L, 1);
        }
    }

    public void requireWritePermission(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = g.a(byArray, "CtKnQ8BVb3C2khd6HQv6FFBuoHzxWi");
        System.arraycopy(byArray3, 0, byArray2, 0, 16);
        if (!this.bS.e(byArray2)) {
            this.bR.onRequireWritePermission(this.L, 1);
        }
    }

    public void writeBaseSettings(BaseSettings baseSettings) {
        if (this.L.G && !this.bW) {
            this.bR.onWriteBaseSetting(this.L, 3);
            return;
        }
        byte[] byArray = null;
        if (this.B()) {
            byArray = new byte[6];
        } else if (this.C() || this.D()) {
            byArray = new byte[4];
        } else {
            this.bR.onWriteBaseSetting(this.L, 6);
            return;
        }
        if (!this.a(baseSettings)) {
            this.bR.onWriteBaseSetting(this.L, 2);
            return;
        }
        this.a(baseSettings, byArray);
        if (!this.bS.f(byArray)) {
            this.bR.onWriteBaseSetting(this.L, 1);
        }
    }

    public void writeSensorSettings(SensorSettings sensorSettings) {
        if (this.L.G && !this.bW) {
            this.bR.onWirteSensorSetting(this.L, 3);
            return;
        }
        byte[] byArray = new byte[6];
        if (!this.a(sensorSettings)) {
            this.bR.onWirteSensorSetting(this.L, 2);
            return;
        }
        this.a(sensorSettings, byArray);
        if (!this.bS.g(byArray)) {
            this.bR.onWirteSensorSetting(this.L, 1);
        }
    }

    public void writeProximityUUID(String string) {
        this.bY = string;
        if (this.L.G && !this.bW) {
            this.bR.onWriteProximityUUID(this.L, 3);
            return;
        }
        byte[] byArray = new byte[16];
        if (!this.a(string)) {
            this.bR.onWriteProximityUUID(this.L, 2);
            return;
        }
        if (!this.a(string, byArray)) {
            this.bR.onWriteProximityUUID(this.L, 2);
            return;
        }
        if (!this.bS.h(byArray)) {
            this.bR.onWriteProximityUUID(this.L, 1);
        }
    }

    public void writeMajorMinor(int n, int n2) {
        this.major = n;
        this.minor = n2;
        if (this.L.G && !this.bW) {
            this.bR.onWriteMajorMinor(this.L, 3);
            return;
        }
        byte[] byArray = new byte[4];
        if (!this.c(n, n2)) {
            this.bR.onWriteMajorMinor(this.L, 2);
            return;
        }
        this.a(n, n2, byArray);
        if (!this.bS.i(byArray)) {
            this.bR.onWriteMajorMinor(this.L, 1);
        }
    }

    public void reloadSensorData() {
        if (this.L.G && !this.bW) {
            this.bR.onReloadSensorData(this.L, 3);
            return;
        }
        if (!this.bS.y()) {
            this.bR.onReloadSensorData(this.L, 1);
        }
    }

    public void disableIBeacon() {
        if (!(this.L.s.equals("B0") && this.L.t.equals("3.0") || this.L.s.equals("C0") && this.L.t.equals("3.0"))) {
            this.bR.onDisableIBeacon(this.L, 7);
            return;
        }
        this.E = false;
        if (this.L.G && !this.bW) {
            this.bR.onDisableIBeacon(this.L, 3);
            return;
        }
        byte[] byArray = new byte[]{0};
        if (!this.bS.m(byArray)) {
            this.bR.onDisableIBeacon(this.L, 1);
            return;
        }
    }

    public void enableIBeacon() {
        if (!(this.L.s.equals("B0") && this.L.t.equals("3.0") || this.L.s.equals("C0") && this.L.t.equals("3.0"))) {
            this.bR.onEnableIBeacon(this.L, 7);
            return;
        }
        this.E = true;
        if (this.L.G && !this.bW) {
            this.bR.onEnableIBeacon(this.L, 3);
            return;
        }
        byte[] byArray = new byte[]{1};
        if (!this.bS.m(byArray)) {
            this.bR.onEnableIBeacon(this.L, 1);
            return;
        }
    }

    public void writeBroadcastKey(String string) {
        Matcher matcher;
        Object object;
        if (!(this.L.s.equals("B0") && this.L.t.equals("3.0") || this.L.s.equals("C0") && this.L.t.equals("3.0"))) {
            this.bR.onWriteBroadcastKey(this.L, 7);
            return;
        }
        if (this.L.G && !this.bW) {
            this.bR.onWriteBroadcastKey(this.L, 3);
            return;
        }
        byte[] byArray = null;
        if (string == null || string == null || string.length() != 40 && string.length() != 90) {
            this.bR.onWriteBroadcastKey(this.L, 2);
            return;
        }
        int n = string.length();
        if (n == 90) {
            object = g.b(string.substring(2, n), "password");
            if (object == null) {
                this.bR.onWriteBroadcastKey(this.L, 2);
                return;
            }
            long l = Integer.parseInt(((String)object).substring(40, ((String)object).length()), 16);
            long l2 = System.currentTimeMillis();
            if (l2 > l * 1000L) {
                this.bR.onWriteBroadcastKey(this.L, 2);
                return;
            }
            string = ((String)object).substring(0, 40);
        }
        this.ce = (matcher = ((Pattern)(object = Pattern.compile("[0]{40}"))).matcher(string)).matches();
        byArray = g.d(string);
        if (byArray != null && byArray.length == 20) {
            if (!this.bS.l(byArray)) {
                this.bR.onWriteBroadcastKey(this.L, 1);
                return;
            }
        } else {
            this.bR.onWriteBroadcastKey(this.L, 2);
        }
    }

    public void writeSecureBroadcastInterval(BaseSettings.SecureBroadcastInterval secureBroadcastInterval) {
        if (!(this.L.s.equals("B0") && this.L.t.equals("2.3") || this.L.s.equals("B0") && this.L.t.equals("3.0") || this.L.s.equals("C0") && this.L.t.equals("3.0"))) {
            this.bR.onWriteSecureBroadcastInterval(this.L, 7);
            return;
        }
        if (!(secureBroadcastInterval != BaseSettings.SecureBroadcastInterval.NONE || this.L.s.equals("B0") && this.L.t.equals("2.3"))) {
            this.bR.onWriteSecureBroadcastInterval(this.L, 2);
            return;
        }
        this.D = secureBroadcastInterval;
        if (this.L.G && !this.bW) {
            this.bR.onWriteSecureBroadcastInterval(this.L, 3);
            return;
        }
        byte[] byArray = new byte[20];
        if (secureBroadcastInterval == BaseSettings.SecureBroadcastInterval.UNKNOWN) {
            this.bR.onWriteSecureBroadcastInterval(this.L, 2);
            return;
        }
        this.a(secureBroadcastInterval, byArray);
        if (!this.bS.j(byArray)) {
            this.bR.onWriteSecureBroadcastInterval(this.L, 1);
            return;
        }
    }

    public void flashLightWitCommand(byte by, byte by2) {
        if (!this.L.s.equals("C0") || !this.L.t.equals("3.1")) {
            this.bR.onFlashLightWitCommand(this.L, 7);
            return;
        }
        if (this.L.G && !this.bW) {
            this.bR.onFlashLightWitCommand(this.L, 3);
            return;
        }
        byte[] byArray = new byte[5];
        this.a(by, by2, byArray);
        if (!this.bS.k(byArray)) {
            this.bR.onEnableIBeacon(this.L, 1);
            return;
        }
    }

    protected BaseSettings getBaseSettings() {
        return this.B;
    }

    protected SensorSettings getSensorSettings() {
        return this.C;
    }

    private boolean a(BaseSettings baseSettings) {
        BaseSettings.TransmitPower transmitPower = baseSettings.getTransmitPower();
        if (BaseSettings.TransmitPower.UNKNOWN == transmitPower) {
            baseSettings.setTransmitPower(this.B.getTransmitPower());
        } else {
            if (this.B() && transmitPower.compareTo(BaseSettings.TransmitPower.LEVEL2) > 0) {
                return false;
            }
            if (this.C() && transmitPower.compareTo(BaseSettings.TransmitPower.LEVEL7) > 0) {
                return false;
            }
        }
        if (BaseSettings.AdvertisingInterval.UNKNOWN == baseSettings.getAdvertisingInterval()) {
            baseSettings.setAdvertisingInterval(this.B.getAdvertisingInterval());
        }
        if (BaseSettings.EnergySavingMode.UNKNOWN == baseSettings.getEnergySavingMode()) {
            baseSettings.setEnergySavingMode(this.B.getEnergySavingMode());
        }
        if (Integer.MAX_VALUE == baseSettings.getMeasuredPower()) {
            baseSettings.setMeasuredPower(this.B.getMeasuredPower());
        } else if (-128 > baseSettings.getMeasuredPower() && baseSettings.getMeasuredPower() > 127) {
            return false;
        }
        this.bU = baseSettings;
        return true;
    }

    private boolean a(SensorSettings sensorSettings) {
        int n = sensorSettings.getTemperatureSamplingInterval();
        if (n == -2) {
            sensorSettings.setTemperatureSamplingInterval(this.C.getTemperatureSamplingInterval());
        } else if (n != 0 && (1000 > n || n > 65535)) {
            return false;
        }
        int n2 = sensorSettings.getLightSamplingInterval();
        if (n2 == -2) {
            sensorSettings.setLightSamplingInterval(this.C.getLightSamplingInterval());
        } else if (n2 != 0 && (1000 > n2 || n2 > 65535)) {
            return false;
        }
        if (SensorSettings.AccelerometerSensitivity.UNKNOWN == sensorSettings.getAccelerometerSensitivity()) {
            sensorSettings.setAccelerometerSensitivity(this.C.getAccelerometerSensitivity());
        }
        this.bV = sensorSettings;
        return true;
    }

    private boolean a(String string) {
        if (string.length() != 36) {
            return false;
        }
        if (string.charAt(8) != '-' && string.charAt(13) != '-' && string.charAt(18) != '-' && string.charAt(23) != '-') {
            return false;
        }
        string = string.toLowerCase();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= 'a' && string.charAt(i) <= 'f' || string.charAt(i) <= '9' && string.charAt(i) >= '0' || string.charAt(i) == '-') continue;
            return false;
        }
        return true;
    }

    private boolean c(int n, int n2) {
        return n <= 65535 && n >= 0 && n2 <= 65535 && n2 >= 0;
    }

    private void a(BaseSettings baseSettings, byte[] byArray) {
        byte by;
        byte by2;
        byte by3;
        byArray[0] = by3 = this.a(baseSettings.getTransmitPower());
        byArray[1] = by2 = this.a(baseSettings.getAdvertisingInterval());
        byArray[2] = by = this.a(baseSettings.getEnergySavingMode());
        byArray[3] = baseSettings.getMeasuredPower() != Integer.MAX_VALUE ? (byte)baseSettings.getMeasuredPower() : (byte)this.B.getMeasuredPower();
        if (this.B()) {
            byArray[4] = 0;
            byArray[5] = 7;
        }
    }

    private byte a(BaseSettings.AdvertisingInterval advertisingInterval) {
        switch (advertisingInterval) {
            case ADVERTISING_INTERVAL_100: {
                return 0;
            }
            case ADVERTISING_INTERVAL_152_5: {
                return 1;
            }
            case ADVERTISING_INTERVAL_211_25: {
                return 2;
            }
            case ADVERTISING_INTERVAL_318_75: {
                return 3;
            }
            case ADVERTISING_INTERVAL_417_5: {
                return 4;
            }
            case ADVERTISING_INTERVAL_546_25: {
                return 5;
            }
            case ADVERTISING_INTERVAL_760: {
                return 6;
            }
            case ADVERTISING_INTERVAL_852_5: {
                return 7;
            }
            case ADVERTISING_INTERVAL_1285: {
                return 9;
            }
        }
        return 9;
    }

    private byte a(BaseSettings.EnergySavingMode energySavingMode) {
        switch (energySavingMode) {
            case NONE: {
                return 0;
            }
            case LIGHT_SENSOR: {
                return 1;
            }
        }
        return 0;
    }

    private byte a(BaseSettings.TransmitPower transmitPower) {
        switch (transmitPower) {
            case LEVEL0: {
                return 0;
            }
            case LEVEL1: {
                return 1;
            }
            case LEVEL2: {
                return 2;
            }
            case LEVEL3: {
                return 3;
            }
            case LEVEL4: {
                return 4;
            }
            case LEVEL5: {
                return 5;
            }
            case LEVEL6: {
                return 6;
            }
            case LEVEL7: {
                return 7;
            }
            case LEVEL8: {
                return 8;
            }
            case LEVEL9: {
                return 9;
            }
            case LEVEL10: {
                return 10;
            }
            case LEVEL11: {
                return 11;
            }
        }
        return 0;
    }

    private void a(SensorSettings sensorSettings, byte[] byArray) {
        byte by;
        if (sensorSettings.getTemperatureSamplingInterval() != -2) {
            byArray[0] = (byte)(sensorSettings.getTemperatureSamplingInterval() & 0xFF);
            byArray[1] = (byte)(sensorSettings.getTemperatureSamplingInterval() >> 8 & 0xFF);
        } else {
            byArray[0] = (byte)(this.C.getTemperatureSamplingInterval() & 0xFF);
            byArray[1] = (byte)(this.C.getTemperatureSamplingInterval() >> 8 & 0xFF);
        }
        if (sensorSettings.getLightSamplingInterval() != -2) {
            byArray[2] = (byte)(sensorSettings.getLightSamplingInterval() & 0xFF);
            byArray[3] = (byte)(sensorSettings.getLightSamplingInterval() >> 8 & 0xFF);
        } else {
            byArray[2] = (byte)(this.C.getLightSamplingInterval() & 0xFF);
            byArray[3] = (byte)(this.C.getLightSamplingInterval() >> 8 & 0xFF);
        }
        byArray[4] = by = this.a(sensorSettings.getAccelerometerSensitivity());
        byArray[5] = 0;
    }

    private byte a(SensorSettings.AccelerometerSensitivity accelerometerSensitivity) {
        switch (accelerometerSensitivity) {
            case DISABLED: {
                return 0;
            }
            case MIN: {
                return 112;
            }
            case MEDIUM: {
                return 93;
            }
            case MAX: {
                return 75;
            }
        }
        return 0;
    }

    private void a(byte by, byte by2, byte[] byArray) {
        byArray[0] = 4;
        byArray[1] = 0;
        byArray[2] = 0;
        byArray[3] = by;
        byArray[4] = by2;
    }

    private boolean a(String string, byte[] byArray) {
        byte[] byArray2 = g.d(string = string.replace("-", ""));
        if (byArray2 == null) {
            return false;
        }
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        return true;
    }

    private void a(int n, int n2, byte[] byArray) {
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        byArray[2] = (byte)(n2 >> 8 & 0xFF);
        byArray[3] = (byte)(n2 & 0xFF);
    }

    private void a(BaseSettings.SecureBroadcastInterval secureBroadcastInterval, byte[] byArray) {
        int n = g.a(secureBroadcastInterval);
        byArray[0] = (byte)(n & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[2] = (byte)(n >> 16 & 0xFF);
        byArray[3] = (byte)(n >> 24 & 0xFF);
    }

    private boolean A() {
        return this.bZ.equals("B0") && this.ca.compareTo("2.2") > 0;
    }

    private boolean B() {
        return this.bZ.equals("A0");
    }

    private boolean C() {
        return this.bZ.equals("B0");
    }

    private boolean D() {
        return this.bZ.equals("C0");
    }

    private double a(int n, int n2) {
        return Math.pow(2.0, n / 16) * (double)(n % 16 * 16 + n2 % 16) * 0.045;
    }

    public class SensoroException
    extends Exception {
        public SensoroException() {
        }

        public SensoroException(String string) {
            super(string);
        }
    }

    public static interface BeaconConnectionCallback {
        public void onConnectedState(Beacon var1, int var2, int var3);

        public void onWritePassword(Beacon var1, int var2);

        public void onDisablePassword(Beacon var1, int var2);

        public void onRequireWritePermission(Beacon var1, int var2);

        public void onWriteBaseSetting(Beacon var1, int var2);

        public void onWirteSensorSetting(Beacon var1, int var2);

        public void onWriteMajorMinor(Beacon var1, int var2);

        public void onWriteProximityUUID(Beacon var1, int var2);

        public void onWriteSecureBroadcastInterval(Beacon var1, int var2);

        public void onEnableIBeacon(Beacon var1, int var2);

        public void onDisableIBeacon(Beacon var1, int var2);

        public void onWriteBroadcastKey(Beacon var1, int var2);

        public void onResetToFactorySettings(Beacon var1, int var2);

        public void onResetAcceleratorCount(Beacon var1, int var2);

        public void onReloadSensorData(Beacon var1, int var2);

        public void onUpdateTemperatureData(Beacon var1, Integer var2);

        public void onUpdateLightData(Beacon var1, Double var2);

        public void onUpdateMovingState(Beacon var1, Beacon.MovingState var2);

        public void onUpdateAccelerometerCount(Beacon var1, int var2);

        public void onFlashLightWitCommand(Beacon var1, int var2);
    }

    class a
    implements Runnable {
        a() {
        }

        @Override
        public void run() {
            if (!SensoroBeaconConnection.this.cb) {
                SensoroBeaconConnection.this.n();
                SensoroBeaconConnection.this.cg.b(0, 5);
                Log.d((String)TAG, (String)"ConnectTimeOutRunnable---callback connect failure:connect time out");
            }
        }
    }

    class b
    implements Runnable {
        b() {
        }

        @Override
        public void run() {
            if (!SensoroBeaconConnection.this.cb) {
                SensoroBeaconConnection.this.n();
                SensoroBeaconConnection.this.bR.onConnectedState(SensoroBeaconConnection.this.L, 0, 5);
                Log.d((String)TAG, (String)"TimeOutRunnable---callback connect failure:connect time out");
            }
        }
    }
}

