﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using CCSPayments.Model;

namespace CCSPayments
{
    public interface IPaymentData
    {
        /**
        * 设置某个字段的值
        * @param key 字段名
         * @param value 字段值
        */
        void SetValue(string key, object value);
        /**
        * 根据字段名获取某个字段的值
        * @param key 字段名
         * @return key对应的字段值
        */
        object GetValue(string key);
        /**
         * 判断某个字段是否已设置
         * @param key 字段名
         * @return 若字段key已被设置，则返回true，否则返回false
         */
        bool IsSet(string key);

        /**
        * @将Dictionary转成xml
        * @return 经转换得到的xml串
        * @throws WxPayException
        **/
        string ToXml();

        /**
        * @将xml转为WxPayData对象并返回对象内部的数据
        * @param string 待转换的xml串
        * @return 经转换得到的Dictionary
        * @throws WxPayException
        */
        SortedDictionary<string, object> FromXml(string xml);

        /**
        * @Dictionary格式转化成url参数格式
        * @ return url格式串, 该串不包含sign字段值
        */
        string ToUrl();

        /**
        * @生成签名，详见签名生成算法
        * @return 签名, sign字段不参加签名
        */
        string MakeSign();

        /**
        * 
        * 检测签名是否正确
        * 正确返回true，错误抛异常
        */
        bool CheckSign();

    }
}
