﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using CCSPayments;

namespace CCSPayments.Model
{

    public abstract class PaymentData : IPaymentData
    {
        //采用排序的Dictionary的好处是方便对数据包进行签名，不用再签名之前再做一次排序
        protected SortedDictionary<string, object> m_values = new SortedDictionary<string, object>();

        public void SetValue(string key, object value)
        {
            m_values[key] = value;
        }

        public object GetValue(string key)
        {
            object o = null;
            if(!m_values.TryGetValue(key, out o))
                throw new PaymentException("The specified key: {0} does not exists", key);
            return o;
        }

        public bool IsSet(string key)
        {
            object o = null;
            return m_values.TryGetValue(key, out o);
        }

        //abstract methods below as different payment system may have different implementation
        public abstract string ToXml();
        public abstract SortedDictionary<string, object> FromXml(string xml);
        public abstract string ToUrl();
        public abstract string MakeSign();
        public abstract bool CheckSign();

        /**
        * 生成时间戳，标准北京时间，时区为东八区，自1970年1月1日 0点0分0秒以来的秒数
        * @return 时间戳
        */
        public static string GenerateTimeStamp()
        {
            TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds).ToString();
        }

        /**
        * 生成随机串，随机串包含字母或数字
        * @return 随机串
        */
        public static string GenerateNonceStr()
        {
            return Guid.NewGuid().ToString().Replace("-", "");
        }
    }
}
