﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using CCSPayments;

namespace CCSPayments.Model
{
    public class WxDownloadBillRequest : WxPaymentRequest
    {
        public WxDownloadBillRequest(WxConfiguration wxConfig):base(wxConfig)
        {

        }

        public void SetBillDate(DateTime billDate)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(billDate.Year);
            sb.Append(billDate.Month);
            sb.Append(billDate.Day);

            this.SetValue("bill_date", sb.ToString());//账单日期

        }

        public void SetBillType(BillType billType)
        {
            this.SetValue("bill_type", billType.ToString());//账单类型
        }
    }
}
