﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CCSPayments.Model
{
    public abstract class WxDownloadBillResponseDetails
    {
        public string TradeTime { get; set; } //交易时间
        public string WxAppId { get; set; } //公众账号ID
        public string MerchantId { get; set; } //商户号
        public string SubMerchantId { get; set; } //子商户号
        public string DeviceId { get; set; } //设备号
        public string WxOrderId { get; set; } //微信订单号
        public string MerchantOrderId { get; set; } //商户订单号

        public string UserId { get; set; } //用户标识
        public string TransactionType { get; set; } //交易类型
        public string TransactionStatus { get; set; } //交易状态
        public string PayerBank { get; set; } //付款银行
        public string CurrencyType { get; set; } //货币种类
        public double TotalPaymentAmount { get; set; } //总金额
        public double TotalCouponPaymentAmount { get; set; } //代金券或立减优惠金额

        public string ProductName { get; set; } //商品名称
        public string ProductDescription { get; set; } //商户数据包
        public double ProcessingFee { get; set; } //手续费
        public string ProcessingFeeRate { get; set; } //费率

        public virtual int FieldCount
        {
            get { return 18; }
        }

        public abstract BillType BillType { get; }
        //当日所有订单
        //
        //交易时间,公众账号ID,商户号,子商户号,设备号,微信订单号,商户订单号,用户标识,交易类型,交易状态,付款银行,货币种类,总金额,代金券或立减优惠金额,微信退款单号,商户退款单号,退款金额,代金券或立减优惠退款金额，退款类型，退款状态,商品名称,商户数据包,手续费,费率

        //当日成功支付的订单
        //
        //交易时间,公众账号ID,商户号,子商户号,设备号,微信订单号,商户订单号,用户标识,交易类型,交易状态,付款银行,货币种类,总金额,代金券或立减优惠金额,商品名称,商户数据包,手续费,费率
        
        //当日退款的订单
        //
        //交易时间,公众账号ID,商户号,子商户号,设备号,微信订单号,商户订单号,用户标识,交易类型,交易状态,付款银行,货币种类,总金额,代金券或立减优惠金额,退款申请时间,退款成功时间,微信退款单号,商户退款单号,退款金额,代金券或立减优惠退款金额,退款类型,退款状态,商品名称,商户数据包,手续费,费率 
    }
}
