﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using CCSPayments;
using CCSPayments.Utils;

namespace CCSPayments.Model
{
    public class WxPaymentRequest : WxPaymentData
    {
        public WxPaymentRequest(WxConfiguration wxConfig) :base(wxConfig)
        {
            this.SetAppId();//公众账号ID
            this.SetMerchantId();//商户号
            this.SetValue("nonce_str", GenerateNonceStr());//随机字符串

        }

        public void SetAppId()
        {
            this.SetValue("appid", m_paymentConfig.AppID);//公众账号ID
        }
        public void SetMerchantId()
        {
            this.SetValue("mch_id", m_paymentConfig.MerchantID);//公众账号ID
        }

        public void SetSign()
        {
            base.SetValue("sign", this.MakeSign());
        }


    }
}
