﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CCSPayments.Utils
{
    public class Log
    {
        private static ILogProvider mLogProvider ;

        public static void SetLogProvider(ILogProvider logProvider)
        {
            mLogProvider = logProvider;
        }

        public static void Debug(string className, string content)
        {
            if(mLogProvider == null)
                throw new PaymentException("must init log provider first");
            mLogProvider.Debug(className, content);
        }

        public static void Info(string className, string content)
        {
            if (mLogProvider == null)
                throw new PaymentException("must init log provider first");

            mLogProvider.Info(className, content);
            
        }

        public static void Error(string className, string content)
        {
            if (mLogProvider == null)
                throw new PaymentException("must init log provider first");

            mLogProvider.Error(className, content);
        }


    }
}
