﻿using System;
using CCSPayments;
using CCSPayments.Model;
using CCSPayments.Utils;
using Microsoft.VisualStudio.TestTools.UnitTesting;

namespace CCSPaymentsTest
{
    [TestClass]
    public class WxDownloadBillTest
    {
        [ClassInitialize]
        public static void TestClassInit(TestContext context)
        {
            Log.SetLogProvider(new TestLogProvider());
        }

        [TestMethod]
        public void TestWxDownloadBillRequestBillTypeAll()
        { 
            DateTime billDate = new DateTime(2015, 11, 24);
            BillType billType = BillType.ALL;

            WxPayment wxPayApi = new WxPayment();
            IPaymentData resp = wxPayApi.DownloadBill(billDate, billType);
            WxDownloadBillResponse wxDownloadBillResponse = (WxDownloadBillResponse) resp;

            Assert.IsNotNull(wxDownloadBillResponse);
            Assert.IsNotNull(wxDownloadBillResponse.GetValue(Configuration.ResultKey));
            Assert.IsNotNull(wxDownloadBillResponse.ResponseSummary);
            Assert.IsNotNull(wxDownloadBillResponse.ResponseDetails);
            Assert.IsTrue(wxDownloadBillResponse.ResponseDetails.Count !=0 );
            foreach (var respDetails in wxDownloadBillResponse.ResponseDetails)
            {
                Assert.IsInstanceOfType(respDetails, typeof(WxDownloadBillResponseDetailsBillTypeAll));
            }
            Assert.IsTrue(wxDownloadBillResponse.RequestStatus);
            Assert.IsNull(wxDownloadBillResponse.ErrorCode);
            Assert.IsNull(wxDownloadBillResponse.ErrorMessage);


        }

        [TestMethod]
        public void TestWxDownloadBillRequestBillTypeSucceed()
        {
            DateTime billDate = new DateTime(2015, 11, 24);
            BillType billType = BillType.SUCCESS;

            WxPayment wxPayApi = new WxPayment();
            IPaymentData resp = wxPayApi.DownloadBill(billDate, billType);
            WxDownloadBillResponse wxDownloadBillResponse = (WxDownloadBillResponse)resp;

            Assert.IsNotNull(wxDownloadBillResponse);
            Assert.IsNotNull(wxDownloadBillResponse.GetValue(Configuration.ResultKey));
            Assert.IsNotNull(wxDownloadBillResponse.ResponseSummary);
            Assert.IsNotNull(wxDownloadBillResponse.ResponseDetails);
            Assert.IsTrue(wxDownloadBillResponse.ResponseDetails.Count != 0);
            foreach (var respDetails in wxDownloadBillResponse.ResponseDetails)
            {
                Assert.IsInstanceOfType(respDetails, typeof(WxDownloadBillResponseDetailsBillTypeSucceed));
            }
            Assert.IsTrue(wxDownloadBillResponse.RequestStatus);
            Assert.IsNull(wxDownloadBillResponse.ErrorCode);
            Assert.IsNull(wxDownloadBillResponse.ErrorMessage);

        }

        [TestMethod]
        public void TestWxDownloadBillRequestBillTypeRefund()
        {
            DateTime billDate = new DateTime(2015, 11, 24);
            BillType billType = BillType.REFUND;

            WxPayment wxPayApi = new WxPayment();
            IPaymentData resp = wxPayApi.DownloadBill(billDate, billType);
            WxDownloadBillResponse wxDownloadBillResponse = (WxDownloadBillResponse)resp;

            Assert.IsNotNull(wxDownloadBillResponse);
            //No Refund on that day
            Assert.IsNull(wxDownloadBillResponse.ResponseSummary);
            Assert.IsNull(wxDownloadBillResponse.ResponseDetails);
            Assert.IsFalse(wxDownloadBillResponse.RequestStatus);
            Assert.IsNotNull(wxDownloadBillResponse.ErrorCode);
            Assert.IsNotNull(wxDownloadBillResponse.ErrorMessage);

        }


        [TestMethod]
        public void TestWxDownloadBillRequestBillTypeAllNoRecord()
        {
            DateTime billDate = new DateTime(2015, 12, 24);
            BillType billType = BillType.ALL;

            WxPayment wxPayApi = new WxPayment();
            IPaymentData resp = wxPayApi.DownloadBill(billDate, billType);
            WxDownloadBillResponse wxDownloadBillResponse = (WxDownloadBillResponse)resp;

            Assert.IsNotNull(wxDownloadBillResponse);
            //No Refund on that day
            Assert.IsNull(wxDownloadBillResponse.ResponseSummary);
            Assert.IsNull(wxDownloadBillResponse.ResponseDetails);
            Assert.IsFalse(wxDownloadBillResponse.RequestStatus);
            Assert.IsNotNull(wxDownloadBillResponse.ErrorCode);
            Assert.IsNotNull(wxDownloadBillResponse.ErrorMessage);

        }

        [TestMethod]
        public void TestWxDownloadBillResponseDetails()
        {
            WxDownloadBillResponseDetailsBillTypeAll respAllDetails = new WxDownloadBillResponseDetailsBillTypeAll();
            Assert.AreEqual(24, respAllDetails.FieldCount);

            WxDownloadBillResponseDetailsBillTypeRefund respRefundDetails = new WxDownloadBillResponseDetailsBillTypeRefund();
            Assert.AreEqual(26, respRefundDetails.FieldCount);

            WxDownloadBillResponseDetailsBillTypeSucceed respSucceedDetails = new WxDownloadBillResponseDetailsBillTypeSucceed();
            Assert.AreEqual(18, respSucceedDetails.FieldCount);
        }
    }
}
