﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;

namespace CCSPrototypeCommon
{
    public class Bill
    {
        [Key]
        public Guid BillID { get; set; }                                     // Primary Key  
        //public string BookID { get; set; }                                  // 表册

        //public string Sequence { get; set; }                                // 抄表序号
        [DisplayName("用户编号")]
        public string UserID { get; set; }                                  // 用户编号
      
        //public string AlternativeID { get; set; }                           // 手工编号
        //public string UserName { get; set; }                                // 户名
        [DisplayName("地址")]
        public string Address { get; set; }                                 // 地址
      
        //public double MeterDiameter { get; set; }                           // 表径
        //public string Sector { get; set; }                                  // 行业分类
        //public DateTimeOffset LastCheckDate { get; set; }                   // 上期抄表日期
        //public DateTimeOffset CurrentCheckDate { get; set; }                // 抄表日期
        //public double ReadingStart { get; set; }                            // 起码
        [DisplayName("止码")]
        public double ReadingEnd { get; set; }                              // 止码

        [DisplayName("抄见水量")]
        public double WaterUsage { get; set; }                              // 抄见水量               
   
        //public double BilledUsage { get; set; }                             // 应收水量
        //public string PaymentMethod { get; set; }                           // 应收水费
        //public double WaterUsage1 { get; set; }                             // 水费水量
        //public double WaterBillAmount { get; set; }                         // 基本水费
        //public double SewerUsage { get; set; }                              // 污水水量
        //public double SewerBillAmount { get; set; }                         // 污水处理费
        //public double TrashUsage { get; set; }                              // 垃圾费水量
        //public double TrashBillAmount { get; set; }                         // 垃圾费
        //public double LatePanelty { get; set; }                             // 违约金
        [DisplayName("应收金额")]
        [DisplayFormat(DataFormatString = "{0:F2}", ApplyFormatInEditMode = true)]
        public double AmountDue { get; set; }                               // 应收金额
  
        //public char Clearance { get; set; }                                 // 销账
        //public double ClearanceAmount { get; set; }                         // 销账金额
        //public string StaffName { get; set; }                               // 销账员
        //public DateTimeOffset ClearanceDateTime { get; set; }               // 销账日期
        //public List<string> PhoneNumber { get; set; }                       // 联系电话
        //public string ServicePerson { get; set; }                           // 抄表员
        //public string UsageType { get; set; }                               // 用水性质
        //public DateTimeOffset LateFeeBillingDate { get; set; }              // 违约金起算日
        //public string Flag { get; set; }                                    // 冲正标志
        //public string WaterMeterType { get; set; }                          // 水表类别
        //public string BillMonth { get; set; }                               // 账务月份
        [DisplayName("移动电话")]
        public string MobilePhone { get; set; }                             // 移动电话
   
        //public char TaxReceipt { get; set; }                                // 税票
        //public string TaxID { get; set; }                                   // 增值税号

        //public string PlaceHolder1 { get; set; }                            // placeholder1

        //public string BankName { get; set; }                                // 开户银行

        //public string PlaceHolder2 { get; set; }                            // placeholder2

        //public string AccountNumber { get; set; }                           // 付款帐号
        //public string ServiceArea { get; set; }                             // 管理区域
        [DisplayName("表身码")]
        public string MeterID { get; set; }                                 // 表身码
        
        // Below columns are not in bill template
        [DisplayName("收费号")]
        public string PaymentID { get; set; }                               // 收费号

        [DisplayName("收费类型")]
        public string PaymentType { get; set; }                             // 收费类型

        [DisplayName("身份证号")]
        public string IDNumber { get; set; }                                // 身份证号

        [DisplayName("营业所")]
        public string Office { get; set; }                                  // 营业所
        
        [DisplayName("上传时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}", ApplyFormatInEditMode = true)]
        public DateTime TimeStamp { get; set; }                             // 上传时间

        [DisplayName("催缴额度")]
        [DisplayFormat(DataFormatString = "{0:F2}", ApplyFormatInEditMode = true)]
        public double CollectionQuota { get; set; }                         // 催缴额度

        [DisplayName("预留字段1")]
        public string Reserved1 { get; set; }                               // Reserved field 1

        [DisplayName("预留字段2")]
        public string Reserved2 { get; set; }                               // Reserved field 2
    }
}