﻿namespace CCSPrototypeCommon
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    public class BillCommon
    {
        #region Old Bill Query
        //public static IEnumerable<Bill> getBillListWithInputID(BillContext thisDB, string userInputID)
        //{
        //    var billList = new List<Bill>();
        //    if (thisDB == null
        //        || thisDB.Database == null
        //        || !thisDB.Database.Exists()
        //        || thisDB.UserTable.Count() < 1
        //        || string.IsNullOrEmpty(userInputID))
        //    {
        //        return billList;
        //    }

        //    if (userInputID.Length < 15)
        //    {
        //        return (from bill in thisDB.BillTable
        //                join user in thisDB.UserTable on bill.UserID equals user.UserID
        //                where user.Cellphone == userInputID
        //                select new
        //                {
        //                    BillID = bill.BillID,
        //                    AmountDue = bill.AmountDue,
        //                    UserID = user.FirstName,
        //                    MobilePhone = user.Cellphone,
        //                    Address = user.Address
        //                }).AsEnumerable().Select(x => new Bill
        //                {
        //                    BillID = x.BillID,
        //                    AmountDue = x.AmountDue,
        //                    UserID = x.UserID,
        //                    MobilePhone = x.MobilePhone,
        //                    Address = x.Address
        //                }).ToList();
        //    }
        //    else
        //    {
        //        return (from bill in thisDB.BillTable
        //                join user in thisDB.UserTable on bill.UserID equals user.UserID
        //                where user.IDNumber == userInputID
        //                select new
        //                {
        //                    BillID = bill.BillID,
        //                    AmountDue = bill.AmountDue,
        //                    UserID = user.FirstName,
        //                    MobilePhone = user.Cellphone,
        //                    Address = user.Address
        //                }).AsEnumerable().Select(x => new Bill
        //                {
        //                    BillID = x.BillID,
        //                    AmountDue = x.AmountDue,
        //                    UserID = x.UserID,
        //                    MobilePhone = x.MobilePhone,
        //                    Address = x.Address
        //                }).ToList();
        //    }
        //}
        #endregion



        public static List<CCS_Bill_V1> getCCSUserBillHistory(BillContext thisDB, Guid UserID, string BillType)
        {
            if (thisDB == null
                 || thisDB.Database == null
                 || !thisDB.Database.Exists()
                 || thisDB.UserTable.Count() < 1
                 || string.IsNullOrEmpty(BillType))
            {
                return new List<CCS_Bill_V1>();
            }

            IQueryable<CCS_Bill_V1> billList = null;

            billList = from b in thisDB.BillTable
                       where b.UserID == UserID && b.BillType == BillType
                        orderby b.ModifiedDate descending
                        select b;
            
            return billList.ToList();
        }


        public static IEnumerable<CCS_User_V1> getCCSUserListWithInputID(BillContext thisDB, string userInputID)
        {
            if (thisDB == null
                || thisDB.Database == null
                || !thisDB.Database.Exists()
                || thisDB.UserTable.Count() < 1
                || string.IsNullOrEmpty(userInputID))
            {
                return new List<CCS_User_V1>();
            }


            IQueryable<CCS_User_V1> users = null;

            if (userInputID.Length < 15)
            {
                users = (from u in thisDB.UserTable
                            where u.Cellphone == userInputID
                            select u);
            }
            else
            {
                users = (from u in thisDB.UserTable
                            where u.IDNumber == userInputID
                            select u);
            }
            if (users == null)
                return new List<CCS_User_V1>();
            
            return users.ToList();
        }
        public static IEnumerable<CCS_Bill_V1> getCCSBillListWithInputID(BillContext thisDB, string userInputID)
        {
            if (thisDB == null
                || thisDB.Database == null
                || !thisDB.Database.Exists()
                || thisDB.UserTable.Count() < 1
                || string.IsNullOrEmpty(userInputID))
            {
                return new List<CCS_Bill_V1>();
            }
            return getCCSBillListWithInputID(thisDB, getCCSUserListWithInputID(thisDB, userInputID));
        }
        public static IEnumerable<CCS_Bill_V1> getCCSBillListWithInputID(BillContext thisDB, IEnumerable<CCS_User_V1> users)
        {
            if (thisDB == null
                || thisDB.Database == null
                || !thisDB.Database.Exists()
                || thisDB.UserTable.Count() < 1
                || users == null
                || users.Count() < 1)
            {
                return new List<CCS_Bill_V1>();
            }

            #region old
            //return (from bill in thisDB.BillTable
            //        join user in thisDB.UserTable on bill.UserID equals user.UserID
            //        where user.Cellphone == userInputID
            //        select new
            //        {
            //            BillID = bill.BillID,
            //            AmountDue = bill.AmountDue,
            //            UserID = user.FirstName,
            //            MobilePhone = user.Cellphone,
            //            Address = user.Address
            //        }).AsEnumerable().Select(x => new Bill
            //        {
            //            BillID = x.BillID,
            //            AmountDue = x.AmountDue,
            //            UserID = x.UserID,
            //            MobilePhone = x.MobilePhone,
            //            Address = x.Address
            //        }).ToList();


            //return (from bill in thisDB.BillTable
            //        join user in thisDB.UserTable on bill.UserID equals user.UserID
            //        where user.IDNumber == userInputID
            //        select new
            //        {
            //            BillID = bill.BillID,
            //            AmountDue = bill.AmountDue,
            //            UserID = user.FirstName,
            //            MobilePhone = user.Cellphone,
            //            Address = user.Address
            //        }).AsEnumerable().Select(x => new Bill
            //        {
            //            BillID = x.BillID,
            //            AmountDue = x.AmountDue,
            //            UserID = x.UserID,
            //            MobilePhone = x.MobilePhone,
            //            Address = x.Address
            //        }).ToList();
            #endregion

            IQueryable<CCS_Bill_V1> billList = null;
            if (users.Count() == 1 )
            {
                Guid QueryUserID = users.FirstOrDefault().UserID;
                billList = from b in thisDB.BillTable
                           where b.UserID == QueryUserID
                           orderby b.ModifiedDate descending
                           group b by b.UserID into g
                           select g.FirstOrDefault();
            }
            else
            {
                IEnumerable<Guid> QueryGuids = users.Select(x => x.UserID);
                billList = from b in thisDB.BillTable
                           where QueryGuids.Contains(b.UserID)
                           orderby b.ModifiedDate descending
                           group b by b.UserID into g
                           select g.FirstOrDefault();
            }
            if (billList.Count() > 2)
            {
                billList = billList.OrderBy(x => x.BillType);
            }
            return billList.ToList();
        }

        /*
        public static List<CCS_Payment_V1> getPaymentsWithLinkingToBill(BillContext thisDB)
        {
            if (thisDB == null
                || thisDB.Database == null
                || !thisDB.Database.Exists()
                || thisDB.Payments.Count() < 1)
            {
                return new List<CCS_Payment_V1>();
            }
            else if (thisDB.BillTable.Count() < 1)
            {
                return thisDB.Payments.ToList();
            }
            List<CCS_Payment_V1> paymentsWithBill = new List<CCS_Payment_V1>();
            CCS_Bill_V1 tempBill = null;

            //Cannot have multiple data readers opened simultaneously
            List<CCS_Payment_V1> payments = thisDB.Payments.ToList();
            foreach (CCS_Payment_V1 current in payments)
            {
                if (current.PaymentBill == null)
                {
                    tempBill = thisDB.BillTable.Find(current.BillID);
                    if (tempBill != null)
                    {
                        current.PaymentBill = tempBill;
                    }
                }
                paymentsWithBill.Add(current);
            }

            return paymentsWithBill;
        }
        */

    }
}