﻿using Microsoft.WindowsAzure.Storage.Table;
using System.Collections.Generic;

namespace CCSPrototypeCommon
{
    public class BillTemplateTableEntity : TableEntity
    {
        public BillTemplateTableEntity(string customerId, 
            string billType)
        {
            PartitionKey = customerId;
            RowKey = billType;
        }

        public BillTemplateTableEntity() { }

        public string AmountDueColumn { get; set; }

        public string UserNameColumn { get; set; }

        public string CellphoneColumn { get; set; }

        public string UserAddressColumn { get; set; }
        
        public List<string> GetColumnList()
        {
            var columnList = new List<string>();
            columnList.Add(AmountDueColumn);
            columnList.Add(UserNameColumn);
            columnList.Add(CellphoneColumn);
            columnList.Add(UserAddressColumn);
            return columnList;
        }

        public static List<string> GetColumnDefinationList()
        {
            var columnList = new List<string>();
            columnList.Add("AmountDue");
            columnList.Add("UserName");
            columnList.Add("Cellphone");
            columnList.Add("UserAddress");
            return columnList;
        }
    }
}
