﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace CCSPrototypeCommon
{
    class CookieHelper
    {
        private static string _mobilePhone = "MobilePhone";
        private static string _password = "Password";
        public bool ReadPasswordFromCookie(HttpRequestBase request, out string mobilePhone, out string password)
        {
            var cookie1 = request.Cookies.Get(_mobilePhone);
            var cookie2 = request.Cookies.Get(_password);
            if (cookie1 != null && cookie2 != null)
            {
                mobilePhone = cookie1.Value;
                password = cookie2.Value;
                return true;
            }

            mobilePhone = string.Empty;
            password = string.Empty;
            return false;
        }

        public void WritePasswordIntoCookie(HttpResponseBase response, string mobilePhone, string password, DateTime expiration)
        {
            HttpCookie cookie = new HttpCookie(_mobilePhone, mobilePhone);
            cookie.Expires = expiration;
            response.SetCookie(cookie);

            cookie = new HttpCookie(_password, password);
            cookie.Expires = expiration;
            response.SetCookie(cookie);
        }
    }
}