﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Data.Entity;
    using System.Data.Entity.Infrastructure;
    using System.ComponentModel.DataAnnotations.Schema;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;

    public class AllContext : DbContext
    {
        public AllContext()
            : base("name=BillDbConnectionString")
        { }

        public AllContext(string connString) : base(connString)
        { }

        public virtual DbSet<CCS_Customer_V1> CustomerTable { get; set; }

        public virtual DbSet<CCS_CustomerInfo_V1> CustomerInfoTable { get; set; }

        public virtual DbSet<CCS_Staff_V1> StaffTable { get; set; }

        public virtual DbSet<CCS_StaffInfo_V1> StaffInfoTable { get; set; }

        public virtual DbSet<CCS_Bill_V1> BillTable { get; set; }

        public virtual DbSet<CCS_BillInfo_V1> BillInfoTable { get; set; }
        public virtual DbSet<CCS_BillTemplate_V1> BillTemplateTable { get; set; }

        public virtual DbSet<CCS_User_V1> UserTable { get; set; }

        public virtual DbSet<CCS_UserInfo_V1> UserInfoTable { get; set; }

        public virtual DbSet<CCS_UserStaffFavorites_V1> UserStaffFavoritesTable { get; set; }

        public virtual DbSet<CCS_Payment_V1> PaymentTable { get; set; }

        public virtual DbSet<CCS_PaymentInfo_V1> PaymentInfoTable { get; set; }

        public virtual DbSet<CCS_Payment_AliPayNotif_V1> PaymentAliPayNotif { get; set; }

        public virtual DbSet<CCS_RawData_V1> RawDataTable { get; set; }

        public virtual DbSet<CCS_PhoneData_V1> PhoneDataTable { get; set; }
    }
}
