﻿namespace CCSPrototypeCommon
{
    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;
    using System.Data.Entity;
    using System.Data.Entity.Infrastructure;

    public class BillContext : DbContext
    {
        public BillContext()
            : base("name=BillDbConnectionString")
        { }

        public BillContext(string connString) : base(connString)
        { }

        public virtual DbSet<CCS_User_V1> UserTable { get; set; }

        public virtual DbSet<CCS_UserInfo_V1> UserInfoTable { get; set; }

        public virtual DbSet<CCS_UserStaffFavorites_V1> UserStaffFavoritesTable { get; set; }

        public virtual DbSet<Bill> Bills { get; set; }

        public virtual DbSet<CCS_Bill_V1> BillTable { get; set; }

        public virtual DbSet<CCS_BillInfo_V1> BillInfoTable { get; set; }

        public virtual DbSet<CCS_BillTemplate_V1> BillTemplateTable { get; set; }
    }

}

