﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Data.Entity;
    using Microsoft.Azure;

    public class BillContextFactory : DBEFContextFactoryBase
    {
        private static BillContextFactory _singletonInstance;

        protected BillContextFactory(string sqlConnString)
            : base(sqlConnString)
        {
            _singletonInstance = null;
        }

        public static DBEFContextFactoryBase GetInstance()
        {
            if (_singletonInstance == null)
            {
                string sqlConnString = CloudConfigurationManager.GetSetting("BillDbConnectionString");
                _singletonInstance = new BillContextFactory(sqlConnString);
            }
            return (DBEFContextFactoryBase)_singletonInstance;
        }

        public override DbContext GetDBEFContext()
        {
            var billContext = new BillContext(SQLConnString);
            billContext.Database.CreateIfNotExists();
            return billContext;
        }
    }
}
