﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Data.Entity;
    using Microsoft.Azure;


    public class CustomerContextFactory : DBEFContextFactoryBase
    {
        private static CustomerContextFactory _singletonInstance;

        protected CustomerContextFactory(string sqlConnString)
            : base(sqlConnString)
        {
            _singletonInstance = null;
        }

        public static DBEFContextFactoryBase GetInstance()
        {
            if (_singletonInstance == null)
            {
                string sqlConnString = CloudConfigurationManager.GetSetting("BillDbConnectionString");
                _singletonInstance = new CustomerContextFactory(sqlConnString);
            }
            return (DBEFContextFactoryBase)_singletonInstance;
        }

        public override DbContext GetDBEFContext()
        {
            var customerContext = new CustomerContext(SQLConnString);
            customerContext.Database.CreateIfNotExists();
            return customerContext;
        }
    }
}
