﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CCSPrototypeCommon
{
    using System;
    using System.Data.Entity;
    using Microsoft.Azure;

    public class LogsContextFactory : DBEFContextFactoryBase
    {
        private static LogsContextFactory _singletonInstance;

        protected LogsContextFactory(string sqlConnString)
            : base(sqlConnString)
        {
            _singletonInstance = null;
        }

        public static DBEFContextFactoryBase GetInstance()
        {
            if (_singletonInstance == null)
            {
                string sqlConnString = CloudConfigurationManager.GetSetting("LogsDbConnectionString");
                _singletonInstance = new LogsContextFactory(sqlConnString);
            }
            return (DBEFContextFactoryBase)_singletonInstance;
        }

        public override DbContext GetDBEFContext()
        {
            var logsContext = new LogsContext(SQLConnString);
            logsContext.Database.CreateIfNotExists();
            return logsContext;
        }
    }
}
