﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CCSPrototypeCommon
{
    using System;
    using System.Data.Entity;
    using Microsoft.Azure;

    public class PaymentContextFactory : DBEFContextFactoryBase
    {
        private static PaymentContextFactory _singletonInstance;

        protected PaymentContextFactory(string sqlConnString)
            : base(sqlConnString)
        {
            _singletonInstance = null;
        }

        public static DBEFContextFactoryBase GetInstance()
        {
            if (_singletonInstance == null)
            {
                string sqlConnString = CloudConfigurationManager.GetSetting("BillDbConnectionString");
                _singletonInstance = new PaymentContextFactory(sqlConnString);
            }
            return (DBEFContextFactoryBase)_singletonInstance;
        }

        public override DbContext GetDBEFContext()
        {
            var paymentContext = new PaymentContext(SQLConnString);
            paymentContext.Database.CreateIfNotExists();
            return paymentContext;
        }
    }
}
