﻿namespace CCSPrototypeCommon
{

    using System;
    using System.Data.Entity;
    using Microsoft.Azure;

    public class RawDataContextFactory : DBEFContextFactoryBase
    {
        private static RawDataContextFactory _singletonInstance;

        protected RawDataContextFactory(string sqlConnString)
            : base(sqlConnString)
        {
            _singletonInstance = null;
        }

        public static DBEFContextFactoryBase GetInstance()
        {
            if (_singletonInstance == null)
            {
                string sqlConnString = CloudConfigurationManager.GetSetting("BillDbConnectionString");
                _singletonInstance = new RawDataContextFactory(sqlConnString);
            }
            return (DBEFContextFactoryBase)_singletonInstance;
        }

        public override DbContext GetDBEFContext()
        {
            var rawDataContext = new RawDataContext(SQLConnString);
            rawDataContext.Database.CreateIfNotExists();
            return rawDataContext;
        }
    }
}