﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Data.Entity;
    using Microsoft.Azure;
    using System.Web;


    public class VendorContextFactory : DBEFContextFactoryBase
    {
        private static VendorContextFactory _singletonInstance;

        protected VendorContextFactory(string sqlConnString)
            : base(sqlConnString)
        {
            _singletonInstance = null;
        }

        public static DBEFContextFactoryBase GetInstance()
        {
            if (_singletonInstance == null)
            {
                string sqlConnString = CloudConfigurationManager.GetSetting("BillDbConnectionString");
                _singletonInstance = new VendorContextFactory(sqlConnString);
            }
            return (DBEFContextFactoryBase)_singletonInstance;
        }

        public override DbContext GetDBEFContext()
        {
            var vendorContext = new VendorContext(SQLConnString);
            vendorContext.Database.CreateIfNotExists();
            return vendorContext;
        }

        public static VendorContext Current
        {
            get
            {
                var vendor = HttpContext.Current.Session["VendorContext"] as VendorContext;
                if (vendor == null)
                {
                    vendor = new VendorContext();
                    HttpContext.Current.Session["VendorContext"] = vendor;
                }
                return vendor;
            }

            set
            {
                HttpContext.Current.Session["VendorContext"] = value;
            }
        }

    }
}
