﻿
namespace CCSPrototypeCommon
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public class CCS_BillInfo_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long BillInfoID { get; set; }

        public Guid BillID { get; set; }

        [ForeignKey("BillID")]
        public virtual CCS_Bill_V1 BillTable { get; set; }

        [Display(Name = "项名/类别", Prompt = "项名/类别")]
        public string Name { get; set; }

        [Display(Name = "值/内容", Prompt = "值/内容")]
        public string Value { get; set; }

        public DBItemState Status { get; set; }

        public CCS_BillInfo_V1()
        {
            Status = DBItemState.Valid;
        }
    }
}
