﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public class CCS_Bill_Joined_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long BillRecID { get; set; }

        public Guid BillID { get; set; }
        [ForeignKey("BillID")]
        public virtual CCS_Bill_V1 BillTable { get; set; }
        public string BillType { get; set; }

        public Guid CustomerID { get; set; }
        [ForeignKey("CustomerID")]
        public virtual CCS_Customer_V1 CustomerTable { get; set; }

        public Guid UserID { get; set; }
        [ForeignKey("UserID")]
        public virtual CCS_User_V1 UserTable { get; set; }

        public double AmountDue { get; set; }

        public DateTime ModifiedDate { get; set; }

        [DisplayName("First Name")]
        public string FirstName { get; set; }

        [DisplayName("Middle Name")]
        public string MiddleName { get; set; }

        [DisplayName("Last Name")]
        public string LastName { get; set; }

        [DisplayName("Cell Phone")]
        public string Cellphone { get; set; }

        [DisplayName("Second Phone")]
        public string SecondPhone { get; set; }

        [DisplayName("Email")]
        public string Email { get; set; }

        [DisplayName("Address")]
        public string Address { get; set; }

        [DisplayName("身份证号")]
        public string IDNumber { get; set; }

    }
}
