﻿
namespace CCSPrototypeCommon
{

    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;


    public class CCS_Bill_V1
    {
        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid BillID { get; set; }

        [DisplayName("应收金额")]
        public double AmountDue { get; set; }

        [DisplayName("账单类型")]
        public string BillType { get; set; }

        public Guid CustomerID { get; set; }

        //[ForeignKey("CustomerID")]
        //public virtual CSS_Customer_V1 CustomerTable { get; set; }

        public Guid UserID { get; set; }

        [ForeignKey("UserID")]
        public virtual CCS_User_V1 UserTable { get; set; }

        [DisplayName("更新时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日 HH时mm分}", ApplyFormatInEditMode = true)]
        public DateTime ModifiedDate { get; set; }

        public virtual ICollection<CCS_BillInfo_V1> BilInfos { get; set; } 
    }
}
