﻿namespace CCSPrototypeCommon
{

    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public enum DBItemState : byte
    {
        Unknown = 0,

        Valid = 1,

        Invalid = 255
    }

    public class CCS_CustomerInfo_V1
    {

        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public long CustomerInfoID { get; set; }

        public Guid CustomerID { get; set; }

        [ForeignKey("CustomerID")]
        public virtual CCS_Customer_V1 CustomerTable { get; set; }

        [MinLength(1)]
        [MaxLength(255)]
        [Display(Name = "项名/类别", Prompt = "项名/类别")]
        public string Name { get; set; }

        [MaxLength(255)]
        [Display(Name = "值/内容", Prompt = "值/内容")]
        public string Value { get; set; }

        public DBItemState Status { get; set; }

        public CCS_CustomerInfo_V1()
        {
            Status = DBItemState.Valid;
        }
    }
}
