﻿namespace CCSPrototypeCommon
{

    using System;
    using System.ComponentModel;
    using System.ComponentModel.DataAnnotations;
    using System.ComponentModel.DataAnnotations.Schema;

    public enum OperationLevel : byte
    {
        [Display(Name = "Unkown")]
        Unkown = 0,

        [Display(Name = "代缴点")]
        Vendor = 1,

        [Display(Name = "职员账户")]
        Staff = 2,

        [Display(Name = "催缴员")]
        Gatherer = 3,

        [Display(Name = "抄表员")]
        MeterReader = 4,

        [Display(Name = "管理员")]
        Admin = 254,

        [Display(Name = "超级管理员")]
        SysAdmin = 255
    }

    public enum GeoRegion
    {
        [Display(Name = "Unkown")] 
        Unkown = 0,

        [Display(Name = "北京")]
        Beijing = 1,

        [Display(Name = "天津")]
        Tianjin = 2,

        [Display(Name = "上海")]
        Shanghai = 3,

        [Display(Name = "重庆")]
        Chongqing = 4,

        [Display(Name = "湖北")]
        Hubei = 5,

        [Display(Name = "湖南")]
        Hunan = 6,

        [Display(Name = "广东")]
        Guangdong = 7,

        [Display(Name = "广西")]
        Guangxi = 8
    }

    public enum CustomerAccountState : byte
    {
        Unknown = 0,

        Active = 1,

        Disable = 255
    }

    public class CCS_Customer_V1
    {

        [Key]
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]
        public Guid CustomerID { get; set; }

        [Required]
        [MaxLength(255)]
        [DisplayName("客户名称")]
        public string Name { get; set; }

        [Required]
        [MaxLength(255)]
        [DisplayName("域名")]
        public string DomainName { get; set; }

        [Required]
        [DisplayName("地区")]
        public GeoRegion Region { get; set; }

        public CustomerAccountState State { get; set; }

        [DisplayName("更新时间")]
        [DisplayFormat(DataFormatString = "{0:yyyy年MM月dd日}")]
        public DateTime LastUpdatedDate { get; set; }

        public CCS_Customer_V1()
        {
            State = CustomerAccountState.Active;
        }
    }

}
